/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");

    @Override
    @NotNull
    public String getDriverName() {
        return "LLDB";
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        try {
            GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine();
            commandLine.addParameter("--version");
            displayVersion = CidrToolsUtil.readOneLineWithProgress(commandLine, 10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            return null;
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        return ToolVersion.parse(displayVersion, VERSION_PATTERN);
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) throws ExecutionException {
        return new LLDBDriver(handler, this);
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        return LLDBDriverConfiguration.getBundledLLDBFrameworkFile();
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return CidrDebuggerPathManager.getLLDBBinFile(relativePath, null);
    }

    @NotNull
    protected static File getBundledLLDBFrameworkFile() {
        return CidrDebuggerPathManager.getLLDBBinFile(SystemInfo.isWindows ? "bin/liblldb.dll" : (SystemInfo.isMac ? "LLDB.framework" : "lib/liblldb.so"), SystemInfo.isMac ? "LLDB.framework/Resources" : "bin");
    }

    public static boolean hasBundledLLDB() {
        if (SystemInfo.isWindows && !Boolean.getBoolean("idea.is.internal") && !Boolean.getBoolean("idea.is.unit.test")) {
            return false;
        }
        return LLDBDriverConfiguration.getBundledLLDBFrameworkFile().exists();
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        GeneralCommandLine result = this.createLLDBFrontendCommandLine();
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result);
        return result;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine() throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "bin/LLDBFrontend.exe" : (SystemInfo.isMac ? "LLDBFrontend" : "bin/LLDBFrontend"));
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_PRELOAD", lldbFrameworkFile.getAbsolutePath());
        } else if (SystemInfo.isWindows) {
            env.put("PATH", lldbFrameworkFile.getParent() + ";" + frontendExecutable.getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (debugserver.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
                env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            }
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
            result.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        LLDBDriverConfiguration.setupCommonParameters(result);
        return result;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        return new LLDBEvaluationContext(driver, expirable, frame);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return Registry.is((String)"cidr.debugger.lldb.statics");
    }

    public boolean disableASLR() {
        return false;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }
}

