/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.util.text.StringKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "", "symbolName", "", "offset", "", "(Ljava/lang/String;J)V", "getOffset", "()J", "getSymbolName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.cidr.debugger"})
public final class LLSymbolOffset {
    @NotNull
    private final String symbolName;
    private final long offset;
    private static final Regex ANGLE_BRACKETS_RE;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(this.symbolName);
        if (this.offset == 0L) {
            string = "";
        } else {
            String string2 = "%+d";
            Object[] objectArray = new Object[]{this.offset};
            StringBuilder stringBuilder2 = stringBuilder;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
            String string4 = string3;
            stringBuilder = stringBuilder2;
            string = string4;
        }
        return stringBuilder.append(string).toString();
    }

    @NotNull
    public final String getSymbolName() {
        return this.symbolName;
    }

    public final long getOffset() {
        return this.offset;
    }

    public LLSymbolOffset(@NotNull String symbolName, long offset) {
        this.symbolName = symbolName;
        this.offset = offset;
    }

    static {
        Companion = new Companion(null);
        String string = "<(.*?)(?:\\+([\\d]+|0x[0-9a-fA-F]+))?>";
        ANGLE_BRACKETS_RE = new Regex(string);
    }

    @NotNull
    public final String component1() {
        return this.symbolName;
    }

    public final long component2() {
        return this.offset;
    }

    @NotNull
    public final LLSymbolOffset copy(@NotNull String symbolName, long offset) {
        return new LLSymbolOffset(symbolName, offset);
    }

    @NotNull
    public static /* synthetic */ LLSymbolOffset copy$default(LLSymbolOffset lLSymbolOffset, String string, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = lLSymbolOffset.symbolName;
        }
        if ((n & 2) != 0) {
            l = lLSymbolOffset.offset;
        }
        return lLSymbolOffset.copy(string, l);
    }

    public int hashCode() {
        String string = this.symbolName;
        return (string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.offset);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LLSymbolOffset)) break block3;
                LLSymbolOffset lLSymbolOffset = (LLSymbolOffset)object;
                if (!Intrinsics.areEqual((Object)this.symbolName, (Object)lLSymbolOffset.symbolName) || !(this.offset == lLSymbolOffset.offset)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final LLSymbolOffset parseAngleBrackets(@NotNull String s, @Nullable String defaultFunctionName) {
        return Companion.parseAngleBrackets(s, defaultFunctionName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset$Companion;", "", "()V", "ANGLE_BRACKETS_RE", "Lkotlin/text/Regex;", "parseAngleBrackets", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "s", "", "defaultFunctionName", "intellij.cidr.debugger"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final LLSymbolOffset parseAngleBrackets(@NotNull String s, @Nullable String defaultFunctionName) {
            void symbolName;
            CharSequence charSequence;
            long offset;
            long l;
            MatchResult.Destructured destructured;
            MatchResult matchResult = ANGLE_BRACKETS_RE.matchEntire((CharSequence)s);
            if (matchResult == null) {
                throw (Throwable)new IllegalArgumentException("Couldn't parse <symbol+offset>: '" + s + '\'');
            }
            MatchResult result = matchResult;
            MatchResult.Destructured destructured2 = destructured = result.getDestructured();
            String string = (String)destructured2.getMatch().getGroupValues().get(1);
            destructured2 = destructured;
            String offsetString = (String)destructured2.getMatch().getGroupValues().get(2);
            CharSequence charSequence2 = offsetString;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                charSequence2 = offsetString;
                l = Long.parseLong((String)charSequence2);
            } else {
                l = offset = 0L;
            }
            if ((charSequence = StringKt.nullize((String)symbolName, (boolean)true)) == null) {
                charSequence2 = defaultFunctionName;
                CharSequence charSequence3 = charSequence2;
                if (charSequence3 == null) {
                    charSequence3 = "";
                }
                CharSequence charSequence4 = charSequence3;
                charSequence = charSequence4;
            }
            long l2 = offset;
            String string2 = charSequence;
            return new LLSymbolOffset(string2, l2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

