/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValueData {
    private static final Pattern HEX_VALUE_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)\\b");
    private static final Pattern INTEGER_WITH_DATA_PATTERN = Pattern.compile("^(-?(?:0x\\p{XDigit}+|\\d+))\\b(?!\\.)\\s*(.*?)\\s*$");
    private static final String NIL_PATTERN_STRING = "0x0+";
    private static final Pattern NULL_POINTER_PATTERN = Pattern.compile("0x0+");
    @NotNull
    private final String myValue;
    @Nullable
    private final String myDescription;
    private final boolean myHasLongerDescription;
    private final boolean myMayHaveChildren;
    private final boolean myIsSynthetic;

    public LLValueData(@NotNull String value, @Nullable String description, boolean hasLongerDescription, boolean mayHaveChildren, boolean isSynthetic) {
        this.myValue = value;
        this.myDescription = description;
        this.myHasLongerDescription = hasLongerDescription;
        this.myMayHaveChildren = mayHaveChildren;
        this.myIsSynthetic = isSynthetic;
    }

    @NotNull
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public boolean hasLongerDescription() {
        return this.myHasLongerDescription;
    }

    @NotNull
    public String getPresentableValue() {
        return this.myDescription != null ? this.myDescription : this.myValue;
    }

    public boolean mayHaveChildren() {
        return this.myMayHaveChildren;
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isPointer() {
        return this.getPointerOrNull() != null;
    }

    public boolean isValidPointer() {
        String pointer = this.getPointerOrNull();
        return pointer != null && !NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    public boolean isNullPointer() {
        return LLValueData.isNullPointer(this.getPointerOrNull());
    }

    private static boolean isNullPointer(@Nullable String pointer) {
        return pointer != null && NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    @NotNull
    public String getPointer() throws DebuggerCommandException {
        String result = this.getPointerOrNull();
        if (result == null) {
            throw new DebuggerCommandException(CidrDebuggerBundle.message("debug.command.error.notAPointer", this.myValue));
        }
        return result;
    }

    @Nullable
    public String getPointerOrNull() {
        return LLValueData.getPointer(this.myValue);
    }

    @Nullable
    public static String getPointer(@Nullable String value) {
        if (value == null) {
            return null;
        }
        List matches = StringUtil.findMatches((String)value, (Pattern)HEX_VALUE_PATTERN);
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return null;
    }

    @Nullable
    public String getPresentablePointer() {
        int i;
        String pointer = this.getPointerOrNull();
        if (pointer == null) {
            return null;
        }
        if (LLValueData.isNullPointer(pointer)) {
            return "0x0";
        }
        for (i = 2; i < pointer.length() && pointer.charAt(i) == '0'; ++i) {
        }
        if (i > 2) {
            pointer = "0x" + pointer.substring(i);
        }
        return pointer;
    }

    @NotNull
    public Pair<String, String> splitNumberAndData() {
        String description = this.myDescription != null ? this.myDescription : this.myValue;
        Matcher matcher = INTEGER_WITH_DATA_PATTERN.matcher(description);
        if (!matcher.matches()) {
            return Pair.create(null, (Object)description);
        }
        try {
            Long.decode(matcher.group(1));
        }
        catch (NumberFormatException e) {
            return Pair.create(null, (Object)description);
        }
        return Pair.create((Object)matcher.group(1), (Object)matcher.group(2));
    }

    public boolean isTrue() {
        return !this.isFalse();
    }

    public boolean isFalse() {
        String[] s;
        for (String s1 : s = new String[]{NIL_PATTERN_STRING, "0+", "false", "NO", "'\\\\0'", "0 [LUu]?'.*'"}) {
            if (!Pattern.compile(s1).matcher(this.myValue).matches()) continue;
            return true;
        }
        return false;
    }

    public long intValue() throws DebuggerCommandException {
        try {
            String pointer = this.getPointerOrNull();
            if (pointer != null) {
                return DebuggerDriver.parseAddressSafe(pointer).unsignedLongValue();
            }
            return new BigInteger(this.myValue).longValue();
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(CidrDebuggerBundle.message("debug.command.error.cannotReadInteger", this.myValue));
        }
    }

    public String toString() {
        return (this.myIsSynthetic ? "[synthetic]" : "") + this.myValue + "(" + this.myDescription + ")" + (this.myMayHaveChildren ? ",has children" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLValueData valueData = (LLValueData)o;
        if (this.myMayHaveChildren != valueData.myMayHaveChildren) {
            return false;
        }
        if (this.myIsSynthetic != valueData.myIsSynthetic) {
            return false;
        }
        if (!this.myValue.equals(valueData.myValue)) {
            return false;
        }
        return !(this.myDescription != null ? !this.myDescription.equals(valueData.myDescription) : valueData.myDescription != null);
    }

    public int hashCode() {
        int result = this.myValue.hashCode();
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myMayHaveChildren ? 1 : 0);
        result = 31 * result + (this.myIsSynthetic ? 1 : 0);
        return result;
    }
}

