/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.VersionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBVarsCache;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtilKt;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.pty4j.unix.Pty;
import gnu.trove.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBDriver
extends DebuggerDriver {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^GNU gdb (?:\\(GDB(?:;[^)]*+)?\\) )?(?:[\\w ]*\\()?([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    private static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern INSTRUCTION_LINE = Pattern.compile("^.{0,4}0x([0-9a-f]+)(?: (<.*>))?:\t((?:[0-9a-f]{2}(?: |(?=\t)))+)\t(.*)$");
    private static final Pattern INSTRUCTION_COMMENT = Pattern.compile("^([^#]*?)\\s*#\\s*(.*)$");
    private static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME = Pattern.compile("^([^#]*(?:0|0x[0-9a-f]+))\\s*(<.*>)\\s*$", 2);
    private static final Pattern WHATIS_TYPE_OUTPUT = Pattern.compile("^type = (?:(?:/\\* real type = (.*) \\*/\\n.*)|(.*))\\n");
    private static final Pattern NON_ID_PATTERN = Pattern.compile("\\W+");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    private static final Pattern PRINT_RESULT = Pattern.compile("^\\$\\d+ = (\\d+)\\s*");
    private static final Pattern SECTIONS_INFO = Pattern.compile("^\\s*(0x[0-9a-f]+)->(0x[0-9a-f]+)(?: at 0x[0-9a-f]+): (\\S+)(.*)$");
    private static final String OBJECT_FILE_PREFIX = "  Object file: ";
    private static final int IGNORE_RESPONSE_COMMAND_TOKEN = 0;
    @Nullable
    private static Boolean ourShellAvailable;
    @Nullable
    private volatile Consumer<String> myFrameVarDisposeListener;
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @NotNull
    private final DebuggerDriverConfiguration myStarter;
    @NotNull
    private final String myInterruptSignalName;
    @Nullable
    private Version myGdbVersion;
    @Nullable
    private String myWinBreakPath;
    @NotNull
    private final GeneralCommandLine myGdbCommandLine;
    @NotNull
    private final BaseProcessHandler myProcessHandler;
    private final boolean myEmulateStepMode;
    private volatile boolean myMIAsyncMode = false;
    private volatile boolean myStepMode = false;
    private volatile int myPromptLevel;
    @NotNull
    private final Writer mySink;
    @Nullable
    private volatile OutputStream myProcessInput;
    private int myVarNameCounter;
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i) throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i);
            }
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i, i1);
            }
        }

        @Override
        public void close() throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.flush();
            }
        }
    };
    private final Semaphore myCommandSemaphore = new Semaphore();
    private final ExecutorService myCommandExecutor;
    private final BlockingQueue<Response> myResultQueue = new LinkedBlockingQueue<Response>();
    private final Semaphore myStopSemaphore = new Semaphore();
    private boolean myIsInterruptedStop;
    private final Semaphore myPendingForAttachNotification = new Semaphore();
    @Nullable
    private volatile Integer myTargetPID = null;
    @Nullable
    private volatile TLongHashSet myIndirectSymbols;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace = null;
    @NotNull
    private volatile Communication myCommunication = new Communication("");
    @Nullable
    private volatile String myLastCommand = null;
    private boolean myIsConsoleCommand;
    private final List<GDBResponse.Record> myVarsDropPool = new ArrayList<GDBResponse.Record>();
    private final GDBVarsCache myVarsCache = new GDBVarsCache(this.myVarsDropPool::add);
    private final HashMap<String, LLValue> myFrameVarCache = new HashMap();
    private final BidirectionalMap<String, String> myFrameVarIDCache = new BidirectionalMap();
    private final HashMap<String, LLValueLoadedData> myFrameVarDataCache = new HashMap();
    private static final Pattern VALUE_DESCRIPTION_PATTERN;

    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        this.setMIOutputFilterInTests((NotNullFunction<String, String>)((NotNullFunction)s -> s.replaceAll(regexp, replacement)));
    }

    public void setMIOutputFilterInTests(@Nullable NotNullFunction<String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    public void setFrameVarDisposeListenerInTests(@Nullable Consumer<String> listener) {
        this.myFrameVarDisposeListener = listener;
    }

    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter) throws ExecutionException {
        super(handler);
        this.myStarter = starter;
        this.myInterruptSignalName = this.getInterruptSignalName();
        this.myEmulateStepMode = this.isMac();
        this.myCommandExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)this.getClass().getSimpleName(), (int)1);
        this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this);
        this.myProcessHandler = this.createDebugProcessHandler(this.myGdbCommandLine, this.myStarter);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            @NotNull
            private StringBuilder myBuffer = new StringBuilder();

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text = event.getText();
                if (outputType == ProcessOutputTypes.STDOUT) {
                    int end;
                    this.myBuffer.append(text);
                    String content = this.myBuffer.toString();
                    boolean changed = false;
                    while ((end = content.indexOf("\n")) != -1) {
                        String response = content.substring(0, end).trim();
                        content = content.substring(end + 1);
                        changed = true;
                        MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                        if (filter != null) {
                            for (String line : StringUtil.splitByLines((String)filter.apply(((GDBDriver)GDBDriver.this).myCommunication.command, response))) {
                                GDBDriver.this.processResponse(line);
                            }
                            continue;
                        }
                        GDBDriver.this.processResponse(response);
                    }
                    if (changed) {
                        this.myBuffer = new StringBuilder(content);
                    }
                } else {
                    if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug("<" + text);
                    }
                    if (ProcessOutputType.isStderr((Key)outputType)) {
                        GDBDriver.this.handleTargetOutput(text, outputType);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                CidrDebuggerLog.LOG.info("Debugger exited with code " + event.getExitCode());
                CidrDebuggerLog.LOG.debug("<[terminated]");
                GDBDriver.this.cleanupOnTermination();
                GDBDriver.this.handleExited(event.getExitCode());
            }
        });
        OutputStream input = this.myProcessHandler.getProcessInput();
        Charset charset = this.myProcessHandler.getCharset();
        assert (input != null);
        assert (charset != null);
        this.mySink = new OutputStreamWriter(input, charset);
        this.myCommandSemaphore.down();
        this.executeCommandNoUserException(() -> {
            this.handlePrompt();
            CidrDebuggerLog.LOG.info("Debugger started");
        });
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return GDBLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(File file, File module2) {
    }

    @Override
    public boolean isInPromptMode() {
        return this.myPromptLevel > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(DebuggerDriver.TargetState state) {
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() {
                    for (GDBResponse.Record record : GDBDriver.this.myVarsDropPool) {
                        GDBDriver.this.doDeleteVar(record);
                    }
                    GDBDriver.this.myVarsDropPool.clear();
                }
            });
        }
    }

    private void doDeleteVar(GDBResponse.Record var) {
        try {
            String name2 = var.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(name2));
        }
        catch (ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @NotNull
    private String getInterruptSignalName() {
        String signalName;
        if (this.isWindows()) {
            return "INT";
        }
        try {
            String signalNameFromRegistry = Registry.stringValue((String)"cidr.debugger.gdb.interrupt.signal");
            signalName = StringUtil.trimStart((String)StringUtil.toUpperCase((String)signalNameFromRegistry.trim()), (String)"SIG");
            if (!StringUtil.isLatinAlphanumeric((CharSequence)signalName)) {
                this.warnUser("Invalid interrupt signal name '" + signalNameFromRegistry + "'; falling back to SIGSTOP");
                signalName = "STOP";
            }
        }
        catch (MissingResourceException e) {
            signalName = "STOP";
        }
        if (!this.getHostMachine().isRemote() && UnixProcessManager.getSignalNumber((String)signalName) == -1) {
            this.warnUser("Unknown interrupt signal SIG" + signalName + "; falling back to SIGINT");
            signalName = "INT";
        }
        return signalName;
    }

    @NotNull
    protected String shellQuote(@NotNull String s) {
        if (this.isWindows()) {
            return CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false);
        }
        return String.format("'%s'", s.replace("'", "'\\''"));
    }

    private void warnUser(@NotNull String message) {
        this.warnUser(message, null);
    }

    private void warnUser(@NotNull String message, @Nullable Throwable e) {
        message = message.trim();
        this.handleTargetOutput(message + "\n\n", ProcessOutputTypes.SYSTEM);
        CidrDebuggerLog.LOG.warn(message, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) {
    }

    private void doSetUpGDB(boolean isRemoteTarget) throws ExecutionException {
        try {
            this.doSetMaxDescription(true);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("print asm-demangle", true);
            this.gdbSet("python print-stack", "full");
            if (this.myEmulateStepMode) {
                this.gdbSet("step-mode", true);
            }
            this.gdbSet("backtrace past-main", true);
            if (this.isMac()) {
                this.gdbSet("backtrace past-entry", true);
            }
            this.doSetMIAsync(isRemoteTarget || Registry.is((String)"cidr.debugger.gdb.forceMIAsync", (boolean)false));
            if (!isRemoteTarget) {
                this.sendSilentRequestAndWaitForDone("handle SIG%s stop nopass", this.myInterruptSignalName);
            }
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            String script = "import sys; sys.dont_write_bytecode = True; ";
            String printersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            if (printersPath != null) {
                Response response;
                boolean hasSTLprinters;
                script = script + "sys.path.insert(0, " + GDBDriver.stringify(this.toEnvPath(printersPath)) + "); ";
                script = script + "from default.printers import register_default_printers; register_default_printers(None); ";
                if (this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE && !(hasSTLprinters = (response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0])).getOutput().contains("libstdc++-v6"))) {
                    script = script + "from default.libstdcxx_printers import patch_libstdcxx_printers_module; patch_libstdcxx_printers_module(); ";
                    script = script + "from libstdcxx.v6.printers import register_libstdcxx_printers; register_libstdcxx_printers(None); ";
                }
                this.sendSilentRequestAndWaitForDone("python %s", script);
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
            }
        }
        catch (GDBCommandException e) {
            this.warnUser("Error during pretty printers setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.\n\n" + e.getResponse().getOutput(), e);
        }
    }

    private void doSetStepMode(boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (this.myStepMode == enabled) {
            return;
        }
        if (!this.myEmulateStepMode) {
            this.gdbSet("step-mode", enabled);
        }
        this.myStepMode = enabled;
    }

    private void doSetMIAsync(boolean enabled) throws ExecutionException, DebuggerCommandException {
        try {
            this.gdbSet("mi-async", enabled);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Can't enable 'mi-async' mode (too old GDB?); falling back to 'target-async'");
            this.gdbSet("target-async", enabled);
        }
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", enabled ? 1000 : 0);
    }

    protected void gdbSet(@NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NotNull String setting, int value) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, String.valueOf(value));
    }

    protected void gdbSet(@NotNull String setting, @Nullable String value) throws ExecutionException, DebuggerCommandException {
        String command;
        String string = command = value != null ? String.format("-gdb-set %s %s", setting, value) : String.format("unset %s", setting);
        if (StringUtil.containsLineBreak((CharSequence)command)) {
            command = GDBDriver.createMI2Command(command, -1L, -1);
        }
        this.sendRequestAndWaitForDone("%s", command);
    }

    @NotNull
    protected GDBTuple gdbShow(@NotNull String setting) throws ExecutionException, DebuggerCommandException {
        return this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
    }

    private int doAllocateInferior() throws ExecutionException, GDBCommandException {
        GDBTuple threadGroup;
        GDBTuple threadGroupsResult = this.sendRequestAndWaitForDone("-list-thread-groups", new Object[0]).getResultList();
        GDBTuple groups = threadGroupsResult.getTupleOrEmpty("groups");
        if (groups.size() == 1 && (threadGroup = (GDBTuple)groups.get(0)).getRequiredString("type").equals("process") && threadGroup.getString("executable") == null) {
            return this.doSelectInferior(threadGroup.getRequiredString("id"), threadGroup);
        }
        GDBTuple addInferiorResult = this.sendRequestAndWaitForDone("-add-inferior", new Object[0]).getResultList();
        return this.doSelectInferior(addInferiorResult.getRequiredString("inferior"), addInferiorResult);
    }

    private int doSelectInferior(@NotNull String iIdString, @NotNull GDBTuple tuple) throws ExecutionException, GDBCommandException {
        int id;
        try {
            id = Integer.parseUnsignedInt(iIdString.substring(1));
        }
        catch (NumberFormatException e) {
            throw new ExecutionException("Malformed inferior id '" + iIdString + "' in tuple: " + tuple.get(0));
        }
        this.sendSilentRequestAndWaitForDone("inferior %d", id);
        return id;
    }

    @NotNull
    private Command<Integer> loadInferiorCommand(final @NotNull LoadingCommand loadingCommand) {
        return new Command<Integer>(){

            @Override
            @NotNull
            public Integer call() throws ExecutionException, DebuggerCommandException {
                int inferiorId = GDBDriver.this.doAllocateInferior();
                loadingCommand.call();
                return inferiorId;
            }

            @Override
            public long getTimeout() {
                return loadingCommand.getTimeout();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        if (this.isMac()) {
            this.tryLoadIndirectSymbols(targetCommandLine);
        }
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> {
            this.doSetUpGDB(false);
            this.doLoadExecutable(installer.getExecutableFile());
        }));
        return new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                return GDBDriver.this.launch(targetCommandLine);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(@NotNull String name2, boolean wait) throws ExecutionException {
        throw new ExecutionException("Attaching by name is not implemented for GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        if (this.isMac()) {
            throw new ExecutionException("Attaching is unsupported for GDB on OS X");
        }
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> this.doSetUpGDB(false)));
        return new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.attachTo(pid);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> {
            this.doSetUpGDB(true);
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            for (DebuggerDriver.PathMapping each : pathMappings) {
                String from = FileUtil.toSystemIndependentName((String)each.from);
                String to = FileUtil.toSystemIndependentName((String)each.to);
                try {
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                    String envFrom = this.toEnvPath(from);
                    if (from.equals(envFrom)) continue;
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
                }
            }
        }));
        return new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.connectTo(connectionString);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(true);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void tryLoadIndirectSymbols(@NotNull GeneralCommandLine line) {
        try {
            this.myIndirectSymbols = MacOSDebugSymbols.load(line);
        }
        catch (IOException e) {
            this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
        }
    }

    private void doLoadExecutable(@NotNull File file) throws ExecutionException, DebuggerCommandException {
        String path = this.toEnvPath(file.getPath());
        this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(FileUtil.toSystemIndependentName((String)path)));
        this.handleModulesLoaded(Collections.singletonList(new LLModule(path)));
    }

    private int launch(@NotNull GeneralCommandLine targetCommandLine) throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            File workDirectory;
            this.printTargetCommandLine(targetCommandLine);
            Charset charset = targetCommandLine.getCharset();
            ArrayList<String> charsetNames = new ArrayList<String>();
            charsetNames.add(charset.name());
            charsetNames.addAll(ContainerUtil.sorted(charset.aliases()));
            for (String charsetName : charsetNames) {
                try {
                    this.gdbSet("charset", charsetName);
                    break;
                }
                catch (DebuggerCommandException e) {
                    CidrDebuggerLog.LOG.warn(e.getMessage());
                }
            }
            if ((workDirectory = targetCommandLine.getWorkDirectory()) != null) {
                this.sendRequestAndWaitForDone("-environment-cd %s", GDBDriver.stringify(this.toEnvPath(workDirectory.getPath())));
            }
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            this.doPrepareInferiorEnv(targetCommandLine, gdbEnv);
            boolean useStartupWithShellWorkaroundOnSierra = this.isMacOSSierra() && Registry.is((String)"cidr.debugger.gdb.workaround.macOS.startupWithShell", (boolean)true);
            Request execRunRequest = this.buildRequest("-exec-run", new Object[0]);
            boolean gdbSupportsIORedirectionOnWindows = this.myGdbVersion != null && this.myGdbVersion.major >= 8 && !Registry.is((String)"cidr.debugger.gdb.workaround.windows.forceExternalConsole", (boolean)false);
            String params = this.getInferiorArgs(targetCommandLine.getParametersList(), !useStartupWithShellWorkaroundOnSierra, gdbSupportsIORedirectionOnWindows);
            try {
                Object pipe;
                if (!this.isWindows() && !this.getHostMachine().isRemote()) {
                    Pty pty = new Pty(true);
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(pty.getSlaveName()));
                    this.myProcessInput = pty.getOutputStream();
                } else if (this.getHostMachine().isRemote()) {
                    pipe = this.getHostMachine().openNamedPipe();
                    params = params + String.format(" < %s ", this.shellQuote(pipe.getName()));
                    this.myProcessInput = pipe.getOutputStream();
                } else if (this.isWindows() && gdbSupportsIORedirectionOnWindows) {
                    pipe = WinPipe.createOutboundPipe("stdin");
                    params = String.format(" < %s ", this.shellQuote(((WinPipe)pipe).getPipeName())) + params;
                    this.myProcessInput = ((WinPipe)pipe).getOutputStream();
                }
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
            }
            if (this.myToRedirect) {
                if (this.isWindows() && !gdbSupportsIORedirectionOnWindows) {
                    this.gdbSet("new-console", true);
                } else {
                    boolean isCsh;
                    ProcessOutputReaders readers = this.initReaders(this.getHostMachine(), targetCommandLine, !this.isWindows());
                    String redirectParams = String.format(" 1> %s 2> %s ", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())), this.shellQuote(this.toEnvPath(readers.getErrFileAbsolutePath())));
                    String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                    boolean bl = isCsh = this.isUnix() && gdbShell.endsWith("csh");
                    if (useStartupWithShellWorkaroundOnSierra) {
                        this.gdbSet("startup-with-shell", false);
                        String[] symbolNames = new String[]{"main", "__cxx_global_var_init", "__libc_csu_init", "__static_initialization_and_destruction_0"};
                        ArrayList<Integer> startBreakpointNumbers = new ArrayList<Integer>(symbolNames.length);
                        for (String symbolName : symbolNames) {
                            startBreakpointNumbers.add(this.doInsertSymbolicBreakpoint(symbolName, null, true).getId());
                        }
                        ThreadPlan.BreakpointHit startThreadPlan = (stopPlace, breakpointNumber) -> {
                            this.executeAsyncCommand(() -> {
                                this.sendSilentRequestAndWaitForDone("-break-delete %s", StringUtil.join((Iterable)startBreakpointNumbers, (String)" "));
                                try {
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getOutFileAbsolutePath()), 1)));
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getErrFileAbsolutePath()), 2)));
                                }
                                catch (GDBCommandException e) {
                                    this.warnUser("Unable to setup IO redirection: " + e.getMessage(), e);
                                }
                                if (!startBreakpointNumbers.contains(breakpointNumber) || !this.doResumeInternal(false)) {
                                    this.handleBreakpoint(stopPlace, breakpointNumber);
                                }
                            });
                            return false;
                        };
                        execRunRequest = execRunRequest.withThreadPlan(startThreadPlan).suppressRunningEvent();
                        if (ContainerUtil.find((Iterable)targetCommandLine.getParametersList().getList(), StringUtil::containsWhitespaces) != null) {
                            this.warnUser("'startup-with-shell' is turned off in order to make GDB run on macOS Sierra and higher.\nThe program arguments might be passed incorrectly");
                        }
                    } else if (this.isWindows()) {
                        params = redirectParams + params;
                    } else if (!isCsh) {
                        boolean isZsh = gdbShell.endsWith("zsh");
                        String ARGV0 = "ARGV0";
                        if (isZsh && gdbEnv.containsKey("ARGV0") && !targetCommandLine.getEnvironment().containsKey("ARGV0")) {
                            this.gdbSet("env ARGV0", null);
                        }
                        params = params + redirectParams;
                    } else if (GDBDriver.isBourneShellAvailable()) {
                        this.doWrapExec(this.getShellCommandLineString("exec \"$@\" " + redirectParams));
                    } else {
                        params = params + String.format(" >&! %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())));
                        this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                    }
                }
            }
            this.doSelectWinbreakBinary();
            this.gdbSet("args", params);
            try {
                execRunRequest.send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
            catch (GDBCommandException e) {
                if (this.isMacOSSierra() && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
            Integer pid = this.myTargetPID;
            CidrDebuggerLog.LOG.assertTrue(pid != null);
            return pid;
        });
    }

    @NotNull
    protected static String createDupFdCall(@NotNull String path, int fd) {
        String open = "((int (*)(const char *, int))open)";
        String dup2 = "((int (*)(int, int))dup2)";
        String openCall = String.format("%s(%s, %o)", "((int (*)(const char *, int))open)", GDBDriver.stringify(path), 1);
        return String.format("%s(%s, %d)", "((int (*)(int, int))dup2)", openCall, fd);
    }

    protected void doWrapExec(@NotNull String wrapper) throws ExecutionException, DebuggerCommandException {
        String oldWrapper = this.gdbShow("exec-wrapper").getString("value");
        if (oldWrapper != null) {
            wrapper = wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", wrapper);
    }

    protected static boolean isBourneShellAvailable() throws ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters) {
        return new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters);
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull String command) {
        return this.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        return commandLine.getCommandLineList(null).stream().map(s -> this.shellQuote((String)s)).collect(Collectors.joining(" "));
    }

    @NotNull
    protected String getInferiorArgs(@NotNull ParametersList parametersList, boolean escapeParameters, boolean escapeForIORedirectionOnWindows) {
        Function<String, String> quoteFunction = parameter -> parameter;
        List<String> params = parametersList.getList();
        if (escapeParameters) {
            if (!this.isWindows()) {
                quoteFunction = parameter -> this.shellQuote((String)parameter);
            } else if (!escapeForIORedirectionOnWindows) {
                quoteFunction = parameter -> CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            } else {
                params = GDBDriver.quoteParametersForIORedirectionOnWindows(params);
            }
        }
        return params.stream().map(quoteFunction).collect(Collectors.joining(" "));
    }

    @NotNull
    private static List<String> quoteParametersForIORedirectionOnWindows(@NotNull List<String> params) {
        ArrayList<String> quotedParams = new ArrayList<String>(params.size());
        boolean quote = false;
        for (String parameter : params) {
            String escapedParameter = CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            StringBuilder sb = new StringBuilder();
            boolean wildRedirection = false;
            char prev = '\u0000';
            for (int i = 0; i < escapedParameter.length(); ++i) {
                char ch = escapedParameter.charAt(i);
                if (ch == '\"') {
                    if (prev == '\\') {
                        sb.append(prev);
                    } else {
                        boolean bl = quote = !quote;
                    }
                }
                if (!(ch != '<' && ch != '>' || quote)) {
                    wildRedirection = true;
                }
                sb.append(ch);
                prev = ch;
            }
            if (wildRedirection) {
                if (sb.charAt(0) == '\"') {
                    sb.insert(0, '\\');
                } else {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
            }
            quotedParams.add(sb.toString());
        }
        return quotedParams;
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value = (String)((Couple)entry.getValue()).first;
            this.gdbSet("env " + key, value);
        }
        if (this.isMac() && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doSelectWinbreakBinary() throws ExecutionException, DebuggerCommandException {
        if (!this.isWindows() || this.myMIAsyncMode) {
            return;
        }
        String winBreakName = null;
        Pattern pattern = Pattern.compile(".+, file type (.+)\\.");
        Response response = this.sendSilentRequestAndWaitForDone("info target", new Object[0]);
        String consoleOutput = response.getOutput();
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String type = matcher.group(1);
            if (type.matches(".*\\bi\\d86\\b.*")) {
                winBreakName = "winbreak32.exe";
            } else if (type.contains("86_64") || type.contains("86-64")) {
                winBreakName = "winbreak64.exe";
            } else {
                throw new ExecutionException("Cannot determine architecture of the target: " + type);
            }
            CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + type);
            break;
        }
        if (winBreakName == null) {
            throw new ExecutionException("Cannot determine architecture of the target:\n" + consoleOutput);
        }
        File winBreakFile = CidrDebuggerPathManager.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new ExecutionException("Cannot find " + winBreakFile.getPath());
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    private void attachTo(final int pid) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(GDBDriver.this.isWindows()).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                return pid;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    private void detach(boolean isRemoteTarget) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message = response.getGDBErrorMessage();
            if (message != null) {
                if (message.equals("Remote connection closed") || message.matches("Remote communication error\\. *Target disconnected\\..*") || message.equals("Remote doesn't know how to detach") || message.equals("Can't detach process.")) {
                    this.warnUser(message);
                } else if (!message.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message);
                }
            }
            if (isRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    private void connectTo(final @NotNull String connectionString) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.sendRequest("-target-select remote %s", connectionString).waitFor(GDBResponse.ResultRecord.Type.connected);
                return -1;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleConnected(connectionString);
            }
        });
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommandNoUserException(() -> this.doInterrupt(false));
    }

    private boolean doInterrupt(boolean tearDownRequest) throws ExecutionException {
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        Integer pid = this.myTargetPID;
        if (pid == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myMIAsyncMode) {
            return this.doInterruptAsync(tearDownRequest);
        }
        this.doInterruptWithSignal(pid, tearDownRequest);
        return true;
    }

    protected boolean doInterruptAsync(boolean tearDownRequest) throws ExecutionException {
        try {
            this.buildRequest("-exec-interrupt", new Object[0]).tearDownRequest(tearDownRequest).send().waitFor(GDBResponse.ResultRecord.Type.done);
            return true;
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn((Throwable)e);
            return false;
        }
    }

    protected void doInterruptWithSignal(int pid, boolean tearDownRequest) throws ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", tearDownRequest, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
            if (this.isWindows()) {
                this.doInterruptWinBreak(pid);
            } else {
                this.doInterruptUnixSignal(pid);
            }
        }));
    }

    private void doInterruptWinBreak(int pid) throws ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new ExecutionException("winbreak was not selected");
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            StringBuilder errorMessage;
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            try (Scanner scanner = new Scanner(new ByteArrayInputStream(stderr.getBytes(Charset.forName("UTF-8"))));){
                errorMessage = new StringBuilder();
                while (scanner.hasNext()) {
                    if (scanner.findInLine("ERROR: (.*)") != null) {
                        MatchResult result = scanner.match();
                        if (errorMessage.length() > 0) {
                            errorMessage.append('\n');
                        }
                        errorMessage.append(result.group(1));
                    }
                    scanner.nextLine();
                }
            }
            throw new ExecutionException(errorMessage.toString());
        }
    }

    private void doInterruptUnixSignal(int pid) throws ExecutionException {
        String signalDisplayName = "SIG" + this.myInterruptSignalName;
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        int err = this.getHostMachine().sendSignal(pid, this.myInterruptSignalName);
        if (err == -1) {
            throw new ExecutionException("Couldn't send " + signalDisplayName + " to " + pid);
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        return this.doInterruptAndWait(false);
    }

    private boolean doInterruptAndWait(boolean tearDownRequest) throws ExecutionException {
        this.myStopSemaphore.down();
        try {
            if (this.doInterrupt(tearDownRequest)) {
                if (tearDownRequest && !GDBDriver.waitForSemaphore(this.myStopSemaphore, 1500L)) {
                    throw new ExecutionException("Couldn't interrupt GDB to request exit");
                }
                GDBDriver.waitForSemaphore(this.myStopSemaphore);
                boolean bl = this.myIsInterruptedStop;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myStopSemaphore.up();
        }
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommandNoUserException(this::doResume);
    }

    private boolean doResume() throws ExecutionException, DebuggerCommandException {
        return this.doResume(false);
    }

    private boolean doResume(boolean suppressRunningEvent) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        return this.doResumeInternal(suppressRunningEvent);
    }

    private boolean doResumeInternal(boolean suppressRunningEvent) throws ExecutionException, GDBCommandException {
        try {
            this.buildRequest("-exec-continue %s", this.onStoppedThreadAndFrame()).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    private boolean getInstructionMode(@Nullable Boolean stepByInstruction) {
        boolean frameHasNoDebugInfo;
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        boolean bl = frameHasNoDebugInfo = stopPlace != null && !stopPlace.frame.hasDebugInfo();
        if (stepByInstruction != Boolean.TRUE) {
            if (frameHasNoDebugInfo && stepByInstruction == Boolean.FALSE) {
                CidrDebuggerLog.LOG.error("Attempt to line-step through function with no source line information; forcing instruction stepping mode");
            }
            stepByInstruction = frameHasNoDebugInfo;
        }
        return stepByInstruction;
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(stepByInstruction);
            if (!instructionMode) {
                this.doSetStepMode(forceStepIntoFramesWithNoDebugInfo);
            }
            this.buildRequest("-exec-step%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished(stopPlace -> {
                if (instructionMode || forceStepIntoFramesWithNoDebugInfo || stopPlace.frame.hasDebugInfo()) {
                    return true;
                }
                if (this.isMac() && this.isIndirectSymbolFrame(stopPlace.frame)) {
                    this.executeAsyncCommand(() -> this.sendSilentRequest("-exec-step %s", this.onStoppedThreadAndFrame()));
                    return false;
                }
                return this.asyncStepOutUntilFrameWithDebugInfo(stopPlace);
            }).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(stepByInstruction);
            if (!instructionMode) {
                this.doSetStepMode(false);
            }
            this.buildRequest("-exec-next%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOut() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(null);
            this.doSetStepMode(false);
            this.buildRequest("-exec-finish %s", this.onStoppedThreadAndFrame()).onSteppingFinished(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    private boolean asyncStepOutUntilFrameWithDebugInfo(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean shouldStop = stopPlace.frame.hasDebugInfo();
        if (!shouldStop) {
            this.executeAsyncCommand(() -> this.buildRequest("-exec-next %s", this.onStoppedThreadAndFrame()).suppressAll().onSteppingFinished(this::asyncStepOutUntilFrameWithDebugInfo).send());
        }
        return shouldStop;
    }

    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        this.runTo(GDBDriver.atSourceLine(this.toEnvPath(path), line));
    }

    @Override
    public void runTo(@NotNull Address address) throws ExecutionException {
        this.runTo(GDBDriver.atAddress(address));
    }

    protected void runTo(@NotNull String location) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            String command = String.format("advance %s", location);
            String consoleCommand = GDBDriver.createConsoleCommand(command, this.myStopPlace);
            return this.sendRequestAndWaitForRunning("%s", consoleCommand);
        });
    }

    private boolean abort() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
                return false;
            }
            this.doInterruptAndWait();
            try {
                this.sendSilentRequest("kill", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                if ("The program is not being run.".equals(e.getMessage())) {
                    return false;
                }
                throw e;
            }
            return true;
        });
    }

    @Override
    protected void doExit() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            try {
                this.doInterruptAndWait(true);
            }
            catch (ExecutionFinishedException executionFinishedException) {
                // empty catch block
            }
            this.buildRequest("-gdb-exit", new Object[0]).tearDownRequest(true).send();
        });
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
                throw new ExecutionException("Cannot set watchpoint while program is running");
            }
            String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
            Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
            return GDBDriver.readWatchpoint(response.getResultList(), accessType);
        });
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression) throws ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + expression + ")", null);
            String value = GDBDriver.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + value;
        }
        return expression;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                LLBreakpoint breakpoint = this.doInsertBreakpoint(GDBDriver.atSourceLine(this.toEnvPath(path), line), condition);
                List<LLBreakpoint> list = Collections.singletonList(breakpoint);
                return list;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    public String interruptAndExecuteConsole(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                String miCommand = GDBDriver.createConsoleCommand(command);
                String string = this.sendSilentRequestAndWaitForDone("%s", miCommand).getOutput();
                return string;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @NotNull
    private LLBreakpoint doInsertBreakpoint(@NotNull String location, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        GDBTuple resultList = this.doGdbBreakInsert(location, condition, false);
        return GDBDriver.readBreakpoint(resultList, condition);
    }

    @NotNull
    private GDBTuple doGdbBreakInsert(@NotNull String location, @Nullable String condition, boolean temporary) throws ExecutionException, GDBCommandException {
        return this.sendRequestAndWaitForDone("-break-insert -f %s %s %s", temporary ? "-t" : "", GDBDriver.withCondition(condition), location).getResultList();
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doInsertSymbolicBreakpoint(symBreakpoint.getPattern(), symBreakpoint.getCondition(), false));
    }

    @NotNull
    private LLSymbolicBreakpoint doInsertSymbolicBreakpoint(@NotNull String function, @Nullable String condition, boolean temporary) throws ExecutionException, DebuggerCommandException {
        GDBTuple bkpt = this.doGdbBreakInsert(GDBDriver.atFunction(function), condition, temporary).getRequiredTuple("bkpt");
        int number = bkpt.getRequiredInt("number");
        return new LLSymbolicBreakpoint(number);
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @NotNull
    private static LLBreakpoint readBreakpoint(@NotNull GDBTuple info, String condition) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, List<GDBTuple>> breakpointWithLocations = info.getWithSuccessors("bkpt", GDBTuple.class);
        GDBTuple breakpointTuple = (GDBTuple)breakpointWithLocations.first;
        List multipleLocationTuples = (List)breakpointWithLocations.second;
        if (breakpointTuple == null) {
            throw new DebuggerCommandException("No code at this line");
        }
        int number = breakpointTuple.getRequiredInt("number");
        String addr = breakpointTuple.getString("addr");
        boolean multipleLocations = "<MULTIPLE>".equals(addr) && !multipleLocationTuples.isEmpty();
        boolean pending = "<PENDING>".equals(addr);
        GDBTuple.Location location = (multipleLocations ? (GDBTuple)multipleLocationTuples.get(0) : breakpointTuple).getLocation("fullname", "line");
        if (location == null && pending) {
            location = breakpointTuple.getLocation("pending");
        }
        if (location == null) {
            location = breakpointTuple.getRequiredLocationOrThrow("original-location", msg -> {
                CidrDebuggerLog.LOG.warn(msg);
                return new DebuggerCommandException("GDB does not allow to set breakpoint here");
            });
        }
        return new LLBreakpoint(number, location.path, location.line, "<PENDING>".equals(addr), condition, null);
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws ExecutionException {
        long threadId = stopTuple.getRequiredInt("thread-id");
        LLThread thread = new LLThread(threadId, "STOPPED", null);
        GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> new ExecutionException("Cannot read stop place: " + stopTuple));
        LLFrame frame = this.doReadFrame(0, frameTuple);
        return new DebuggerDriver.StopPlace(thread, frame);
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        return (List)this.executeCommand(this::doGetThreads);
    }

    @NotNull
    private List<LLThread> doGetThreads() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result = new ArrayList<LLThread>(threads.size());
        for (GDBTuple each : threads) {
            int id = each.getRequiredInt("id");
            String name2 = each.getString("name");
            String state = each.getRequiredString("state");
            result.add(new LLThread(id, state.toUpperCase(), null, name2));
        }
        Collections.sort(result, Comparator.comparingLong(LLThread::getId));
        return result;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doGetFrames(threadId, from, count, untilFirstLineWithCode));
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = response.getGDBErrorMessage();
        if (frames == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                return DebuggerDriver.ResultList.empty();
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result = new ArrayList<LLFrame>(frames.size());
        for (int i = 0; i < Math.min(frames.size(), count); ++i) {
            GDBTuple each = frames.get(i);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result.add(frame);
            if (untilFirstLineWithCode && frame.getLine() != -1) break;
        }
        boolean hasMore = result.size() < frames.size();
        return DebuggerDriver.ResultList.create(result, hasMore);
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        int line = -1;
        if (file != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        return new LLFrame(level, "??".equals(func) ? null : func, file, line, addr, null, false);
    }

    private boolean isIndirectSymbolFrame(@NotNull LLFrame frame) {
        TLongHashSet indirectSymbols = this.myIndirectSymbols;
        if (indirectSymbols == null) {
            return false;
        }
        return !frame.hasDebugInfo() && !frame.hasSymbolInfo() && indirectSymbols.contains(frame.getProgramCounter().unsignedLongValue());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        return (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex));
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        return response.getResultList().getRequiredStringOrThrow("value", () -> new ExecutionException("Cannot evaluate frame address for thread: " + threadId + " frame: " + frameIndex));
    }

    @NotNull
    private List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        SmartList result = new SmartList();
        String currentFrameAddr = this.doGetFrameAddr(threadId, frameIndex);
        for (Object o : this.doUpdateAndListFrameVariables(threadId, frameIndex, currentFrameAddr)) {
            result.add(this.doReadVariable((GDBTuple)o, "", currentFrameAddr, null, threadId, frameIndex));
        }
        return result;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return (LLValueData)this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)value).data);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            String id = GDBDriver.doLoadVariable((LLValue)value).id;
            boolean bl = lengthChanged = maxLength != 1000;
            if (lengthChanged) {
                this.doSetMaxDescription(false);
            }
            try {
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(true);
                }
            }
            return (String)GDBDriver.getDescriptionFromValue((String)response.getResultList().getRequiredString((String)"value")).second;
        });
    }

    @NotNull
    public String getVariableID(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)value).id);
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        return (DebuggerDriver.ResultList)this.executeCommand(() -> this.doGetVariableChildren(value, from, count));
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset, 2));
            boolean hasMore = endOffset < 2;
            return DebuggerDriver.ResultList.create(list, hasMore);
        }
        if (data.isMap) {
            return this.doGetMapChildren(var, offset, count);
        }
        final ArrayList result = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result.add(GDBDriver.this.doReadVariable(child, var.getReferenceExpression()));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result.addAll(((GDBDriver)GDBDriver.this).doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result.size() < childrenCount;
            return DebuggerDriver.ResultList.create(result, hasMore);
        }
        return this.doGetPlainVariableChildren(var, offset, offset + count);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        if (offset > endPos) {
            throw new ExecutionException("Internal error, incorrect children range. from = " + offset + " to = " + endPos);
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result.add(this.doReadVariable(each, var.getReferenceExpression()));
        }
        return DebuggerDriver.ResultList.create(result, hasMore);
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded = GDBDriver.doLoadVariable(var);
        if (!loaded.mayHaveChildren()) {
            return Pair.create((Object)new GDBTuple(), (Object)false);
        }
        String id = loaded.id;
        Response response = this.sendRequestAndWaitForDone("-var-list-children --all-values %s %d %d", GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        return Pair.create((Object)children, (Object)hasMore);
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount = GDBDriver.doLoadVariable((LLValue)var).childrenCount;
        if (childrenCount == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children == null) {
            children = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children);
        }
        Iterator iterator2 = children.iterator();
        while (iterator2.hasNext() && (each = GDBDriver.getChildTuple(children, o = iterator2.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name2 = each.getRequiredStringOrThrow("name", msg -> new ExecutionException("Internal error: Unexpected gdb fake variable: " + msg));
            LLValue fakeValue = new LLValue("", "", null, name2);
            int numchild = each.getInt("numchild", 0);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(name2, null, numchild, false, false, "", null));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i = 0; i < size - 1; i += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key = this.doReadVariable(keyTuple, var.getReferenceExpression(), "first");
            LLValue value = this.doReadVariable(valueTuple, var.getReferenceExpression(), "second");
            LLValue element = new LLValue("[" + (offset + i / 2) + "]", "std::pair<" + key.getType() + ", " + value.getType() + ">", null, value.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", null, 2, false, false, "", null));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
            result.add(element);
        }
        return DebuggerDriver.ResultList.create(result, hasMore);
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws ExecutionException {
        if (!(o instanceof Pair)) {
            throw new ExecutionException("Invalid object in the list: " + varObjList);
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new ExecutionException("pair.first required to be \"child\": " + p.toString());
        }
        GDBTuple result = (GDBTuple)p.second;
        String name2 = result.getString("name");
        return name2 != null && name2.matches(".*\\.<error at.*") ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String expression, long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response;
        block11: {
            String varId = String.format("var%d_%s", ++this.myVarNameCounter, NON_ID_PATTERN.matcher(expression).replaceAll(""));
            String command = GDBDriver.createMI2Command(String.format("-var-create %s * %s", varId, GDBDriver.stringify(expression)), threadId, frameIndex);
            GDBCommandException err = null;
            response = null;
            try {
                response = this.sendRequestAndWaitForDone("%s", command);
            }
            catch (GDBCommandException e) {
                err = e;
            }
            if (response == null || response.getReceivedSignalCount() != 0) {
                try {
                    this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(varId));
                }
                catch (GDBCommandException e) {
                    if (!"Variable object not found".equals(e.getResponse().getGDBErrorMessage())) {
                        if (err != null) {
                            err.addSuppressed(e);
                        }
                    }
                }
                finally {
                    if (err == null) break block11;
                    throw err;
                }
            }
        }
        return response.getRecord();
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef) throws ExecutionException {
        return this.doReadVariable(varTuple, parentRef, null);
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String displayName2) throws ExecutionException {
        return this.doReadVariable(varTuple, parentRef, null, displayName2, -1L, -1);
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String frameAddress, @Nullable String displayName2, long threadId, int frameIndex) throws ExecutionException {
        boolean isFrameVariable = frameAddress != null;
        LLValue result = null;
        String name2 = varTuple.getString("name");
        String type = varTuple.getString("type");
        String fvKey = null;
        if (name2 != null && isFrameVariable) {
            fvKey = GDBDriver.makeFVKey(frameAddress, name2);
            result = this.myFrameVarCache.get(fvKey);
            if (type == null) {
                if (result != null) {
                    type = result.getType();
                } else {
                    try {
                        type = this.doGetExpressionType(name2, threadId, frameIndex);
                    }
                    catch (GDBCommandException e) {
                        String error = e.getMessage();
                        type = "value has been optimized out".equals(error) ? "<optimized out>" : "error: " + error;
                    }
                }
            }
        }
        boolean invalid = name2 == null || type == null;
        name2 = StringUtil.notNullize((String)name2, (String)"<unknown>");
        type = StringUtil.notNullize((String)type, (String)"<unknown>");
        String id = name2;
        String value = varTuple.getString("value");
        String displayHint = varTuple.getString("displayhint");
        if (result == null) {
            String exp = varTuple.getString("exp");
            if (exp != null) {
                name2 = exp;
            }
            result = new LLValue(displayName2 != null ? displayName2 : name2, GDBDriver.fixType(type), null, parentRef.isEmpty() ? name2 : parentRef + "." + name2);
        } else {
            result = new LLValue(result.getName(), result.getType(), result.getTypeClass(), result.getReferenceExpression());
        }
        if (fvKey != null) {
            this.myFrameVarCache.put(fvKey, result);
        }
        if (invalid) {
            GDBDriver.doUpdateLoadedData(result, new LLValueLoadedData("", null, 0, false, false, StringUtil.notNullize((String)value), displayHint));
        } else {
            LLValueLoader loader = null;
            if (isFrameVariable) {
                loader = new FrameValueLoader(fvKey, threadId, frameIndex, value, displayHint);
            } else {
                LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, id, null, StringUtil.notNullize((String)value));
                if (value == null) {
                    loader = new CreatedValueLoader(data);
                } else {
                    GDBDriver.doUpdateLoadedData(result, data);
                }
            }
            result.putUserData(LLVALUE_DATA_LOADER, loader);
        }
        return result;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariable(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader = (LLValueLoader)value.getUserData(LLVALUE_DATA_LOADER);
        if (loader != null) {
            loader.loadValue(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value.getUserData(LLVALUE_DATA)) == null) {
            throw new ExecutionException("Internal error, variable is not initialized: " + (Object)((Object)value));
        }
        return data;
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull String id, @Nullable String fvKey, @NotNull String value) {
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        String displayHint = varTuple.getString("displayhint");
        return new LLValueLoadedData(id, fvKey, childrenCount, isDynamic, hasDynamicChildren, value, displayHint);
    }

    private static void doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        var.putUserData(LLVALUE_DATA, data);
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        return (Integer)this.executeCommand(() -> this.doGetChildrenCount(var));
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", "");
    }

    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        final String debuggerLanguage = GDBDriver.convertLanguage(language);
        return this.executeCommand(new EvaluationCommand<LLValue>(expression){

            @Override
            public LLValue call() throws ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage);
            }
        });
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doDisassembleFunction(address, fallbackRange));
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doDisassembleRange(range, null));
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        assert (fallbackRange.contains(address));
        Pair<Address, String> functionStart = this.doGetFunctionStart(address);
        if (functionStart == null) {
            return this.doDisassembleRange(fallbackRange, null);
        }
        Address startAddress = (Address)functionStart.first;
        String functionName = (String)functionStart.second;
        if (address.minus(startAddress) > 65536L) {
            return this.doDisassembleRange(fallbackRange, functionName);
        }
        Pair<Address, String> pastFunctionEnd = this.doGetFunctionStart(startAddress.plus(65536));
        if (pastFunctionEnd != null && ((Address)pastFunctionEnd.first).equals(startAddress)) {
            AddressRange startUntilFallbackEndRange = startAddress.rangeTo(fallbackRange.getEndInclusive());
            return this.doDisassembleRange(fallbackRange.intersectWith(startUntilFallbackEndRange), functionName);
        }
        return this.doDisassemble(startAddress.toString(), functionName);
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleRange(@NotNull AddressRange range, @Nullable String functionName) throws ExecutionException, DebuggerCommandException {
        return this.doDisassemble(String.format("%s,+%d", range.getStart(), range.getSize()), functionName);
    }

    @NotNull
    private ArrayList<LLInstruction> doDisassemble(@NotNull String disassembleAddressArg, @Nullable String functionName) throws ExecutionException, GDBCommandException {
        Response response = this.sendSilentRequestAndWaitForDone("disassemble /r %s", disassembleAddressArg);
        String[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        ArrayList<LLInstruction> result = new ArrayList<LLInstruction>(outputLines.length);
        for (String line : outputLines) {
            LLInstruction instruction;
            Matcher lineMatcher = INSTRUCTION_LINE.matcher(line);
            if (!lineMatcher.matches() || (instruction = GDBDriver.parseInstruction(functionName, lineMatcher.group(1), lineMatcher.group(2), lineMatcher.group(3), lineMatcher.group(4))) == null) continue;
            result.add(instruction);
        }
        return result;
    }

    @Nullable
    protected static LLInstruction parseInstruction(@Nullable String functionName, @NotNull String addressString, @Nullable String functionOffsetStr, @NotNull String opcodes, @NotNull String disassembly) {
        if (CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(disassembly).matches()) {
            return null;
        }
        String instruction = null;
        String comment = null;
        if (!BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
            Matcher commentMatcher = INSTRUCTION_COMMENT.matcher(disassembly = INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME.matcher(disassembly).replaceAll("$1  # $2"));
            if (commentMatcher.matches()) {
                instruction = commentMatcher.group(1);
                comment = commentMatcher.group(2);
            } else {
                instruction = disassembly;
            }
        }
        Address address = Address.parseHexString(addressString);
        LLSymbolOffset functionOffset = functionOffsetStr == null ? null : LLSymbolOffset.parseAngleBrackets(functionOffsetStr, functionName);
        return LLInstruction.create(address, opcodes, instruction, comment, functionOffset);
    }

    @Nullable
    protected Pair<Address, String> doGetFunctionStart(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        Response response = this.doDataDisassemble(address.rangeTo(address));
        if (response.getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
            return null;
        }
        GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
        if (asmInsns.isEmpty()) {
            return null;
        }
        GDBTuple insn = (GDBTuple)asmInsns.get(0);
        String funcName = insn.getString("func-name");
        Integer offset = insn.getInteger("offset", null);
        if (funcName == null || offset == null) {
            return null;
        }
        Address functionStart = insn.getRequiredAddress("address").minus(offset);
        if (functionStart.equals(Address.NULL)) {
            return null;
        }
        return Pair.create((Object)functionStart, (Object)funcName);
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), AddressUtilKt.getEndCoerced(range)).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.error);
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        List modules = sectionsMap.keySet().stream().map(LLModule::new).collect(Collectors.toList());
        return Collections.unmodifiableList(modules);
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module2) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
            List<LLSection> sections = sectionsMap.get(module2.getPath());
            if (sections == null) {
                throw new DebuggerCommandException("Unknown module '" + module2 + "'");
            }
            return sections;
        });
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException, GDBCommandException {
        if (this.mySectionsMap == null) {
            Response response = this.sendSilentRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("maintenance info sections ALLOBJ"));
            this.mySectionsMap = GDBDriver.doReadSectionsMap(response.getOutput());
        }
        return this.mySectionsMap;
    }

    @NotNull
    protected static Map<String, List<LLSection>> doReadSectionsMap(@NotNull String output) throws ExecutionException {
        LinkedHashMap<String, List<LLSection>> sectionsMap = new LinkedHashMap<String, List<LLSection>>();
        ArrayList<LLSection> sections = null;
        for (String str : output.split("\n")) {
            Matcher matcher;
            if (str.startsWith(OBJECT_FILE_PREFIX)) {
                String objectName = StringUtil.trimStart((String)str, (String)OBJECT_FILE_PREFIX);
                sections = new ArrayList<LLSection>();
                sectionsMap.putIfAbsent(objectName, Collections.unmodifiableList(sections));
                continue;
            }
            if (sections == null || !(matcher = SECTIONS_INFO.matcher(str)).matches()) continue;
            Address start = GDBDriver.parseAddress(matcher.group(1));
            Address end = GDBDriver.parseAddress(matcher.group(2));
            String name2 = matcher.group(3);
            List flags = StringUtil.split((String)matcher.group(4), (String)" ");
            sections.add(new LLSection(name2, flags, start.until(end)));
        }
        return sectionsMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            Response response = this.sendRequestAndWaitForDone("-data-read-memory-bytes %s %d", range.getStart(), range.getSize());
            ArrayList<LLMemoryHunk> list = new ArrayList<LLMemoryHunk>();
            for (Object o : response.getResultList().getRequiredTuple("memory")) {
                GDBTuple tuple = (GDBTuple)o;
                Address begin = tuple.getRequiredAddress("begin").plus(tuple.getInt("offset", 0));
                Address end = tuple.getRequiredAddress("end");
                AddressRange hunkRange = begin.until(end);
                String contents = tuple.getRequiredString("contents");
                byte[] bytes = GDBDriver.bytesFromString(contents);
                if ((long)bytes.length != range.getSize()) {
                    CidrDebuggerLog.LOG.warn("Memory range of size " + range.getSize() + "; content size is " + bytes.length);
                    continue;
                }
                LLMemoryHunk hunk = new LLMemoryHunk(hunkRange, bytes);
                list.add(hunk);
            }
            return list;
        });
    }

    private static byte[] bytesFromString(@NotNull String data) {
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((Character.digit(data.charAt(i * 2), 16) << 4) + Character.digit(data.charAt(i * 2 + 1), 16));
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
        GDBResponse.Record response = this.myVarsCache.getFromCache(expression);
        if (response != null) {
            String name2 = response.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-update %s", GDBDriver.stringify(name2));
        } else {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language %s", language);
            }
            try {
                response = this.doCreateVar(expression, threadId, frameIndex);
            }
            finally {
                if (language != null) {
                    this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
                }
            }
            this.myVarsCache.putIntoCache(expression, response);
        }
        return this.doReadVariable(response.getResultList(), "", null);
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return "c";
                }
                case C_PLUS_PLUS: {
                    return "c++";
                }
                case OBJC: {
                    return "objective-c";
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        throw new ExecutionException("Not implemented yet");
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException, DebuggerCommandException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(final long threadId, final int frameIndex, final String command) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(new ConsoleCommand<Object>(command){

            @Override
            public Object call() throws ExecutionException, DebuggerCommandException {
                String commandToSend;
                if (GDBDriver.this.isInPromptMode()) {
                    commandToSend = command;
                } else {
                    String trimmed;
                    long actualThreadId = threadId;
                    int actualFrameIndex = frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = command.trim())) {
                        GDBDriver.this.handleGDBOutput("Command '" + trimmed + "' is not supported.\n");
                        return null;
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                GDBDriver.this.sendRequest("%s", commandToSend).waitFor(new GDBResponse.ResultRecord.Type[0]);
                return null;
            }
        });
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) {
    }

    @Override
    public void handleSignal(String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = String.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request) {
        return GDBDriver.createConsoleCommand(request, -1L, -1);
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @Nullable DebuggerDriver.StopPlace stopPlace) {
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(stopPlace));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int frameIndex) {
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(threadId, frameIndex));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @NotNull String onThreadAndFrame) {
        return String.format("-interpreter-exec %s console %s", onThreadAndFrame, GDBDriver.stringify(request));
    }

    @NotNull
    protected static String createMI2Command(@NotNull String request, long threadId, int frameIndex) {
        return String.format("%d-interpreter-exec %s %s %s", 0, GDBDriver.onThreadAndFrame(threadId, frameIndex), "mi2", GDBDriver.stringify(request));
    }

    private String onStoppedThreadAndFrame() {
        return GDBDriver.onThreadAndFrame(this.myStopPlace);
    }

    private static String onThreadAndFrame(@Nullable DebuggerDriver.StopPlace stopPlace) {
        long threadId = stopPlace == null ? -1L : stopPlace.thread.getId();
        int frameIndex = stopPlace == null ? -1 : stopPlace.frame.getIndex();
        return GDBDriver.onThreadAndFrame(threadId, frameIndex);
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? String.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        return GDBDriver.stringify(String.format("%s:%d", source, line + 1));
    }

    private static String atAddress(@NotNull Address address) {
        return String.format("*%s", address);
    }

    private static String atFunction(@NotNull String func) {
        return String.format("--function %s", GDBDriver.stringify(func));
    }

    private static String withCondition(@Nullable String condition) {
        return condition != null ? String.format("-c %s", GDBDriver.stringify(condition)) : "";
    }

    private static String withInstructionMode(boolean stepByInstruction) {
        return stepByInstruction ? "-instruction" : "";
    }

    @NotNull
    @Contract(pure=true)
    protected Request buildRequest(@NotNull @PrintFormat String command, Object ... args) {
        return new Request(String.format(command, args));
    }

    @NotNull
    protected Communication sendRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).send();
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
    }

    @NotNull
    private Communication sendSilentRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).suppressAll().send();
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, boolean tearDownRequest, @NotNull ThrowableRunnable<ExecutionException> r) throws ExecutionException {
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(">" + commandDisplayString);
        }
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors(boolean tearDownRequest) throws ExecutionException {
        if (!tearDownRequest && this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws ExecutionException {
        Response response;
        while ((response = (Response)this.myResultQueue.poll()) != null) {
            try {
                response.checkError();
            }
            catch (ExecutionException e) {
                if (ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class)) continue;
                throw e;
            }
        }
    }

    @Override
    protected void handleGDBOutput(@NotNull String text) {
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleGDBOutput(text);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetFinished(int code, @Nullable String description) {
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myStopSemaphore.up();
        super.handleTargetFinished(code, description);
    }

    @Override
    protected void handleTargetTerminated() {
        this.myStopSemaphore.up();
        super.handleTargetTerminated();
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    private static ExecutionException unexpectedResponse(Object response) {
        return new ExecutionException("Unexpected response: " + response);
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message = e.getMessage();
        return message != null && message.contains(string);
    }

    private static void waitForSemaphore(@NotNull Semaphore s) throws ExecutionException {
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private static boolean waitForSemaphore(@NotNull Semaphore s, long msTimeout) throws ExecutionException {
        try {
            return s.waitForUnsafe(msTimeout);
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private void setPromptMode(int promptLevel) {
        this.myPromptLevel = promptLevel;
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        GDBResponse.AsyncRecord record = new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, "read-one-line", new GDBTuple());
        this.setPromptMode(prompt.length());
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
        this.myCommandSemaphore.up();
        return true;
    }

    private void processResponse(@NotNull String output) {
        try {
            this.doProcessResponse(output);
        }
        catch (Throwable e) {
            this.myResultQueue.offer(new ErrorResponse("Failed to process MI record:\n>" + this.myCommunication.command + "\n<" + output, e));
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, ExecutionException {
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        if (output.startsWith("0^")) {
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
                if (this.myGdbVersion == null) {
                    this.myGdbVersion = VersionUtil.parseVersion((String)text, (Pattern[])new Pattern[]{VERSION_PATTERN});
                }
                this.myCommunication.consoleOutput.append(text);
            }
            case log: {
                this.handleGDBOutput(text);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) throws ExecutionException {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                if (!this.myCommunication.suppressRunningResult) break;
                return;
            }
            case error: {
                DebuggerDriver.StopPlace stopPlace;
                GDBTuple tuple = record.getResultList();
                String reason = tuple.getString("reason");
                if (!"breakpoint-hit".equals(reason)) break;
                this.myStopPlace = stopPlace = this.doReadStopPlace(tuple);
                this.processBreakpointHit(stopPlace, tuple);
                break;
            }
        }
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws ExecutionException {
        String type = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
        GDBTuple resultTuple = record.getResultList();
        switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
            case notify: {
                switch (type) {
                    case "library-loaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            this.handleModulesLoaded(Collections.singletonList(new LLModule(moduleName)));
                        }
                    }
                    case "library-unloaded": {
                        this.mySectionsMap = null;
                        return;
                    }
                    case "thread-group-exited": {
                        int code = resultTuple.getInt("exit-code", 1);
                        this.handleTargetFinished(code, null);
                        return;
                    }
                    case "thread-group-started": {
                        this.myTargetPID = resultTuple.getRequiredInt("pid");
                        return;
                    }
                }
                return;
            }
            case exec: {
                DebuggerDriver.StopPlace stopPlace;
                if (!type.equals("stopped")) {
                    return;
                }
                if (resultTuple.getAll("reason", String.class).stream().anyMatch(o -> o.startsWith("exited"))) {
                    DebuggerDriver.TargetState state = this.getState();
                    CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + (Object)((Object)state)));
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                this.myStopPlace = stopPlace = this.doReadStopPlace(resultTuple);
                boolean bl = this.myIsInterruptedStop = resultTuple.getString("reason", "").equals("signal-received") && (resultTuple.getString("signal-name", "").equals("SIGINT") || resultTuple.getString("signal-name", "").equals("SIG" + this.myInterruptSignalName));
                if (this.myStopSemaphore.tryUp() && this.myIsInterruptedStop) {
                    return;
                }
                switch (resultTuple.getString("reason", "")) {
                    case "signal-received": {
                        ++this.myCommunication.receivedSignalCount;
                        String name2 = resultTuple.getString("signal-name");
                        String meaning = resultTuple.getString("signal-meaning");
                        if (GDBDriver.isTargetTerminationSignal(name2)) {
                            this.handleTargetTerminated();
                            return;
                        }
                        if (name2 == null || meaning == null) break;
                        this.handleSignal(stopPlace, name2, meaning);
                        return;
                    }
                    case "breakpoint-hit": {
                        this.processBreakpointHit(stopPlace, resultTuple);
                        return;
                    }
                    case "location-reached": {
                        break;
                    }
                    case "function-finished": 
                    case "end-stepping-range": {
                        boolean shouldHandle = this.myCommunication.myThreadPlan.onSteppingFinished(stopPlace);
                        if (shouldHandle) break;
                        return;
                    }
                    case "watchpoint-trigger": 
                    case "read-watchpoint-trigger": 
                    case "access-watchpoint-trigger": {
                        String tupleKey;
                        String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                        GDBTuple wpt = null;
                        String[] stringArray = tupleKeys;
                        int n = stringArray.length;
                        for (int i = 0; i < n && (wpt = resultTuple.getTuple(tupleKey = stringArray[i])) == null; ++i) {
                        }
                        if (wpt == null) break;
                        int number = wpt.getRequiredInt("number");
                        this.handleWatchpoint(stopPlace, number);
                        return;
                    }
                    case "watchpoint-scope": {
                        int wpnum = resultTuple.getRequiredInt("wpnum");
                        this.handleWatchpointScope(wpnum);
                        return;
                    }
                }
                this.handleInterrupted(stopPlace);
                return;
            }
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple) throws ExecutionException {
        int num = resultTuple.getRequiredInt("bkptno");
        boolean shouldHandle = this.myCommunication.myThreadPlan.onBreakpointHit(stopPlace, num);
        if (shouldHandle) {
            this.handleBreakpoint(stopPlace, num);
        }
    }

    private void cleanupOnTermination() {
        OutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        this.myResultQueue.offer(new ErrorResponse((NotNullProducer<ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        this.myCommandSemaphore.up();
        this.myStopSemaphore.up();
        this.myPendingForAttachNotification.up();
        this.myCommandExecutor.shutdown();
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws ExecutionException {
        long timeout = c.getTimeout();
        try {
            Future<T> future = this.doExecuteCommand(c, false);
            return timeout < 0L ? ExecutionResult.get(future) : ExecutionResult.get(future, timeout, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            throw new ExecutionFinishedException((Throwable)e);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private void executeAsyncCommand(Command<?> c) {
        this.doExecuteCommand(c, true);
    }

    private <T> Future<T> doExecuteCommand(Command<T> c, boolean async) {
        return this.myCommandExecutor.submit(() -> {
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && this.isInPromptMode()) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                return c.call();
            }
            catch (Throwable e) {
                if (async) {
                    this.myResultQueue.offer(new ErrorResponse(e));
                }
                throw e;
            }
        });
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value) {
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(1);
            description = matcher.group(2);
        }
        if (description == null) {
            description = value;
        }
        return Pair.create((Object)value, (Object)description);
    }

    @NotNull
    private GDBTuple doUpdateAndListFrameVariables(long threadId, int frameIndex, @NotNull String currentFrameAddr) throws ExecutionException, DebuggerCommandException {
        Consumer<String> frameVarDisposeListener = this.myFrameVarDisposeListener;
        Response updateResponse = this.sendRequestAndWaitForDone("-var-update --all-values *", new Object[0]);
        GDBTuple changeList = updateResponse.getResultList().getRequiredTuple("changelist");
        for (Object each : changeList) {
            if (!(each instanceof GDBTuple)) continue;
            GDBTuple change = (GDBTuple)each;
            String fVar = change.getString("name", "");
            boolean inScope = change.getBoolean("in_scope", false);
            boolean typeChanged = change.getBoolean("type_changed");
            if (!inScope || typeChanged) {
                this.myFrameVarIDCache.removeValue((Object)fVar);
                LLValueLoadedData data = this.myFrameVarDataCache.remove(fVar);
                if (data != null && data.fvKey != null) {
                    this.myFrameVarCache.remove(data.fvKey);
                }
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            String changedValue = change.getString("value");
            String changedDisplayHint = change.getString("displayhint");
            if (changedValue == null) continue;
            this.updateFrameVarDataCache(fVar, changedValue, changedDisplayHint);
        }
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --no-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        HashSet<String> uniqueSet = new HashSet<String>();
        GDBTuple result = new GDBTuple();
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        for (Object each : variables) {
            GDBTuple gdbTuple = (GDBTuple)each;
            String name2 = gdbTuple.getString("name", "");
            String fvKey = GDBDriver.makeFVKey(currentFrameAddr, name2);
            if (uniqueSet.contains(name2)) {
                this.myFrameVarCache.remove(fvKey);
                String fVar = (String)this.myFrameVarIDCache.remove((Object)fvKey);
                if (fVar == null) continue;
                this.myFrameVarDataCache.remove(fVar);
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            uniqueSet.add(name2);
            result.add(each);
        }
        return result;
    }

    @Nullable
    private String doGetExpressionType(@NotNull String expr, long threadId, int frameIndex) throws ExecutionException, GDBCommandException {
        if (StringUtil.isEmptyOrSpaces((String)expr)) {
            return null;
        }
        String command = GDBDriver.createConsoleCommand(String.format("whatis/mt %s", expr), threadId, frameIndex);
        String output = this.sendSilentRequestAndWaitForDone("%s", command).getOutput();
        Matcher m = WHATIS_TYPE_OUTPUT.matcher(output);
        if (m.matches()) {
            String substring = m.group(1) != null ? m.group(1) : m.group(2);
            return StringUtil.convertLineSeparators((String)substring, (String)" ").trim();
        }
        return null;
    }

    private void updateFrameVarDataCache(@NotNull String id, @NotNull String newValue, @Nullable String displayHint) {
        LLValueLoadedData data = this.myFrameVarDataCache.get(id);
        if (data != null) {
            data = new LLValueLoadedData(data.id, data.fvKey, data.childrenCount, data.isDynamic, data.hasDynamicChildren, newValue, displayHint);
            this.myFrameVarDataCache.put(id, data);
        }
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name2) {
        return frameAddr + "-" + name2;
    }

    @NotNull
    public HostMachine getHostMachine() {
        return this.myStarter.getHostMachine();
    }

    @NotNull
    private String toEnvPath(@NotNull String path) {
        return this.myStarter.convertToEnvPath(path);
    }

    private boolean isWindows() {
        return this.getHostMachine().getOSType() == OSType.WIN;
    }

    private boolean isMac() {
        return this.getHostMachine().getOSType() == OSType.MAC;
    }

    private boolean isUnix() {
        return !this.isWindows();
    }

    private boolean isMacOSSierra() {
        return !this.getHostMachine().isRemote() && SystemInfo.isMacOSSierra;
    }

    private boolean isLinux() {
        return this.getHostMachine().getOSType() == OSType.LINUX;
    }

    static {
        VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: (\\w?\".*\"(?:\\.\\.\\.)?))?$");
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        GDBCommandException(@NotNull Response response, @NotNull String message) {
            super(message);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            return this.myResponse;
        }
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFvKey;
        private final long myThreadId;
        private final int myFrameIndex;
        @Nullable
        private final String myAvailableValue;
        @Nullable
        private final String myAvailableDisplayHint;

        FrameValueLoader(String fvKey, long threadId, @Nullable int frameIndex, @Nullable String availableValue, String availableDisplayHint) {
            this.myFvKey = fvKey;
            this.myThreadId = threadId;
            this.myFrameIndex = frameIndex;
            this.myAvailableValue = availableValue;
            this.myAvailableDisplayHint = availableDisplayHint;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            LLValueLoadedData data;
            String name2 = value.getName();
            String id = (String)GDBDriver.this.myFrameVarIDCache.get((Object)this.myFvKey);
            if (id == null) {
                GDBResponse.Record varObj = GDBDriver.this.doCreateVar(name2, this.myThreadId, this.myFrameIndex);
                id = varObj.getResultList().getRequiredString("name");
                String v = varObj.getResultList().getString("value", "");
                data = GDBDriver.doReadLoadedData(varObj.getResultList(), id, this.myFvKey, v);
                GDBDriver.this.myFrameVarIDCache.put((Object)this.myFvKey, (Object)id);
                GDBDriver.this.myFrameVarDataCache.put(id, data);
            } else {
                if (this.myAvailableValue != null) {
                    GDBDriver.this.updateFrameVarDataCache(id, this.myAvailableValue, this.myAvailableDisplayHint);
                }
                data = (LLValueLoadedData)GDBDriver.this.myFrameVarDataCache.get(id);
            }
            GDBDriver.doUpdateLoadedData(value, data);
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            String id = this.partialLoadedData.id;
            GDBTuple varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id)).getResultList();
            String val = varObj.getRequiredString("value");
            String displayHint = varObj.getString("displayhint", "");
            GDBDriver.doUpdateLoadedData(value, new LLValueLoadedData(id, this.partialLoadedData.fvKey, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, val, displayHint));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;
    }

    private static class LLValueLoadedData {
        @NotNull
        public final String id;
        @Nullable
        public final String fvKey;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        @NotNull
        public final LLValueData data;

        LLValueLoadedData(@NotNull String id, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, @NotNull String value, @Nullable String displayHint) {
            this.id = id;
            this.fvKey = fvKey;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = displayHint != null && "map".equals(displayHint.split("=", 2)[0]);
            String descriptionFromDisplayHint = LLValueLoadedData.extractDescriptionFromDisplayHint(displayHint);
            if (descriptionFromDisplayHint != null && value.equals("{...}")) {
                value = descriptionFromDisplayHint;
            }
            Pair<String, String> valueAndDescription = GDBDriver.getDescriptionFromValue(value);
            value = (String)valueAndDescription.first;
            String description = (String)valueAndDescription.second;
            boolean hasLongerDescription = description != null && description.length() >= 1000;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren || isDynamic;
            this.data = new LLValueData(value, description, hasLongerDescription, mayHaveChildren, isDynamic);
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }

        @Nullable
        private static String extractDescriptionFromDisplayHint(@Nullable String displayHint) {
            int eqIndex;
            if (displayHint != null && (eqIndex = displayHint.indexOf(61)) != -1) {
                return displayHint.substring(eqIndex + 1);
            }
            return null;
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            return this.myKey;
        }

        @NotNull
        public LLValue getValue() {
            return this.myValue;
        }
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<ExecutionException> myErrorSupplier;

        ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(throwable)));
        }

        ErrorResponse(@Nullable String message, @Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(message, throwable)));
        }

        ErrorResponse(@NotNull NotNullProducer<ExecutionException> errorSupplier) {
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public ExecutionException getError() {
            return (ExecutionException)((Object)this.myErrorSupplier.produce());
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws ExecutionException {
            throw this.getError();
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            return this.myRecord;
        }

        @Override
        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }
    }

    protected static interface Response {
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws ExecutionException {
            return this.getRecord().getResultList();
        }

        @NotNull
        public String getOutput() throws ExecutionException;

        default public void checkError() throws ExecutionException {
        }

        @NotNull
        default public GDBCommandException createGDBError() throws ExecutionException {
            String errorMessage = this.getGDBErrorMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown GDB error";
            }
            return new GDBCommandException(this, errorMessage);
        }

        @Nullable
        default public String getGDBErrorMessage() throws ExecutionException {
            return this.getRecord().getResultList().getString("msg");
        }

        public int getReceivedSignalCount() throws ExecutionException;
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;
        @NotNull
        private ThreadPlan myThreadPlan = ThreadPlan.DEFAULT;
        private boolean myTearDownRequest;

        public Request(String command) {
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws ExecutionException {
            Communication communication = new Communication(this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult, this.myTearDownRequest, this.myThreadPlan);
            communication.initiate();
            return communication;
        }

        @NotNull
        public String getCommand() {
            return this.myCommand;
        }

        public Request suppressAll() {
            return this.suppressOutputEvent().suppressRunningEvent().suppressRunningResult();
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }

        private Request tearDownRequest(boolean tearDownRequest) {
            this.myTearDownRequest = tearDownRequest;
            return this;
        }

        public Request withThreadPlan(@Nullable ThreadPlan threadPlan) {
            this.myThreadPlan = threadPlan != null ? threadPlan : ThreadPlan.DEFAULT;
            return this;
        }

        public Request onSteppingFinished(@Nullable ThreadPlan.SteppingFinished threadPlan) {
            return this.withThreadPlan(threadPlan);
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        ConsoleCommand(@NotNull String expression) {
            super(expression);
        }
    }

    protected static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression) {
            this.myExpression = expression;
        }

        @NotNull
        public String getExpression() {
            return this.myExpression;
        }

        @Override
        public long getTimeout() {
            return GDBDriver.getEvaluationTimeoutMs();
        }
    }

    protected static interface SuspendedCommand<T>
    extends Command<T> {
    }

    protected static interface DestroyCommand
    extends VoidCommand {
        @Override
        default public long getTimeout() {
            return 1500L;
        }
    }

    protected abstract class AttachConnectCommand
    implements LaunchCommand {
        protected AttachConnectCommand() {
        }

        @Override
        @NotNull
        public Integer call() throws ExecutionException, DebuggerCommandException {
            int pid;
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                pid = this.attach();
                GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doSelectWinbreakBinary();
            this.whenAttached();
            GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
            return pid;
        }

        protected abstract int attach() throws ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws ExecutionException, DebuggerCommandException;
    }

    protected static interface LaunchCommand
    extends StartCommand<Integer> {
    }

    protected static interface LoadingCommand
    extends StartCommand<Void>,
    VoidCommand {
    }

    protected static interface StartCommand<T>
    extends Command<T> {
        @Override
        default public long getTimeout() {
            return GDBDriver.getLoadTimeoutMs();
        }
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws ExecutionException, DebuggerCommandException;
    }

    protected static interface Command<T> {
        @Nullable
        public T call() throws ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return GDBDriver.getTimeoutMs();
        }
    }

    protected class Communication {
        private static final String GDB_POKE_COMMAND = "0-gdb-set $__poke_gdb=1";
        @NotNull
        public final String command;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        public final boolean tearDownRequest;
        @NotNull
        public final ThreadPlan myThreadPlan;
        @NotNull
        public final StringBuffer consoleOutput = new StringBuffer();
        public int receivedSignalCount;

        public Communication(String command) {
            this(command, false, false, false, false, false, ThreadPlan.DEFAULT);
        }

        public Communication(String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult, @NotNull boolean tearDownRequest, ThreadPlan threadPlan) {
            this.command = command;
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || this.isMultilineCommand(), (Object)("MI command must not contain unescaped newlines: " + command));
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
            this.tearDownRequest = tearDownRequest;
            this.myThreadPlan = threadPlan;
        }

        protected boolean isMultilineCommand() {
            return GDBDriver.this.isInPromptMode() ? this.command.equals("end") : this.command.endsWith("\nend");
        }

        protected boolean usePokeCommandWorkaround() {
            if (GDBDriver.this.isLinux() && this.command.startsWith("-exec-run")) {
                return true;
            }
            if (GDBDriver.this.isLinux() && this.command.startsWith("-target-attach")) {
                return true;
            }
            return GDBDriver.this.isWindows() && this.isMultilineCommand();
        }

        public void initiate() throws ExecutionException {
            GDBDriver.this.sendRequestOrSpecialCommunication(this.command, this.tearDownRequest, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                GDBDriver.this.myCommunication = this;
                this.doInitiate();
            }));
        }

        public void doInitiate() throws ExecutionException {
            try {
                GDBDriver.this.mySink.write(this.command + "\n");
                if (this.usePokeCommandWorkaround()) {
                    GDBDriver.this.mySink.write("0-gdb-set $__poke_gdb=1\n");
                }
                GDBDriver.this.mySink.flush();
            }
            catch (IOException e) {
                if (GDBDriver.this.isTerminated()) {
                    throw new ExecutionFinishedException((Throwable)e);
                }
                throw new ExecutionException("Cannot send request", (Throwable)e);
            }
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }

        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            Response response = this.doWaitForResponse();
            GDBResponse.Record result = response.getRecord();
            Object resultType = result.getType();
            if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
                return response;
            }
            String errorMessage = response.getGDBErrorMessage();
            if (!"-exec-interrupt".equals(this.command) || !GDBDriver.INFERIOR_NOT_EXECUTING.equals(errorMessage)) {
                CidrDebuggerLog.LOG.warn(">" + this.command);
                CidrDebuggerLog.LOG.warn("<" + result);
            }
            if (GDBDriver.this.getState() != DebuggerDriver.TargetState.NOT_READY && "ptrace: No such process.".equals(errorMessage)) {
                GDBDriver.this.handleTargetTerminated();
                throw new ExecutionFinishedException();
            }
            if (resultType == GDBResponse.ResultRecord.Type.error) {
                throw response.createGDBError();
            }
            throw GDBDriver.unexpectedResponse(result);
        }

        @NotNull
        private Response doWaitForResponse() throws ExecutionException {
            try {
                return (Response)GDBDriver.this.myResultQueue.take();
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Execution interrupted", (Throwable)e);
            }
        }
    }

    protected static interface ThreadPlan {
        public static final ThreadPlan DEFAULT = new ThreadPlan(){};

        default public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace stopPlace) throws ExecutionException {
            return true;
        }

        default public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) throws ExecutionException {
            return true;
        }

        @FunctionalInterface
        public static interface BreakpointHit
        extends ThreadPlan {
            @Override
            public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace var1, int var2) throws ExecutionException;
        }

        @FunctionalInterface
        public static interface SteppingFinished
        extends ThreadPlan {
            @Override
            public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace var1) throws ExecutionException;
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
            return true;
        }
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }
}

