/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbBaseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBResponseVisitor
extends GdbBaseVisitor<GDBResponse> {
    private static final Pattern ID_PATTERN = Pattern.compile("[\\w-]*");

    private static <T> T getResultValue(GDBResponse.ResultRecord val) {
        GDBTuple tuple = val.getResultList();
        switch ((GDBResponse.ResultRecord.Type)val.getType()) {
            case tuple_value: {
                return (T)tuple;
            }
            case list_value: 
            case str_value: {
                return GDBResponseVisitor.getSoleElement(tuple);
            }
        }
        assert (false);
        return null;
    }

    private static <T> T getSoleResult(GDBResponse.ResultRecord val) {
        GDBTuple tuple = val.getResultList();
        return GDBResponseVisitor.getSoleElement(tuple);
    }

    private static <T> T getSoleElement(GDBTuple tuple) {
        if (tuple.size() != 1) {
            throw new IllegalArgumentException("Expected tuple of a single element: " + tuple);
        }
        return (T)tuple.get(0);
    }

    public static GDBResponse getResponse(@Nullable String varName, GDBResponse.ResultRecord val) {
        Object value = GDBResponseVisitor.getResultValue(val);
        if (varName != null) {
            value = Pair.create((Object)varName, value);
        }
        GDBTuple r = GDBTuple.of(new Object[]{value});
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.result, r);
    }

    @Override
    public GDBResponse visitResult(@NotNull GdbParser.ResultContext ctx) {
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value());
        return GDBResponseVisitor.getResponse(ctx.variable == null ? null : ctx.variable.getText(), val);
    }

    @Override
    public GDBResponse visitCnst(@NotNull GdbParser.CnstContext ctx) {
        GDBTuple r = GDBTuple.of(new Object[]{GDBResponseVisitor.getUnquotedString(ctx.cString(), true)});
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.str_value, r);
    }

    @Override
    public GDBResponse visitTuple(@NotNull GdbParser.TupleContext ctx) {
        GDBTuple results = this.doVisitTuple(ctx.result());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.tuple_value, results);
    }

    private GDBTuple doVisitTuple(List<GdbParser.ResultContext> items) {
        return items.stream().map(each -> GDBResponseVisitor.getSoleResult((GDBResponse.ResultRecord)this.visitResult((GdbParser.ResultContext)((Object)each)))).collect(Collectors.toCollection(GDBTuple::new));
    }

    private GDBTuple doVisitList(List<GdbParser.ResultContext> items) {
        return GDBTuple.of(new Object[]{this.doVisitTuple(items)});
    }

    @Override
    public GDBResponse visitList(@NotNull GdbParser.ListContext ctx) {
        GDBTuple result = this.doVisitList(ctx.result());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.list_value, result);
    }

    @Override
    public GDBResponse visitResultRecord(@NotNull GdbParser.ResultRecordContext ctx) {
        GDBTuple results = this.doVisitTuple(ctx.result());
        if (ctx.listTailToken != null) {
            results = GDBTuple.of(new Object[]{Couple.of((Object)"changelist", (Object)results)});
        } else if (results.size() == 1 && results.get(0) instanceof String) {
            results = GDBTuple.of(new Object[]{Couple.of((Object)"msg", results.get(0))});
        }
        GDBResponse.ResultRecord.Type type = GDBResponse.ResultRecord.Type.valueOf(ctx.resultClass.getText());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, type, results);
    }

    @Override
    public GDBResponse visitAsyncRecord(@NotNull GdbParser.AsyncRecordContext ctx) {
        String type;
        String prefix;
        if (ctx.quirk == null) {
            prefix = ctx.prefix.getText();
            type = ctx.asyncClass.getText();
        } else {
            String prefixAndType = ctx.quirk.getText();
            prefix = prefixAndType.substring(0, 1);
            type = GDBResponseVisitor.extractIdentifier(prefixAndType, 1);
        }
        GDBTuple results = this.doVisitTuple(ctx.result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.forPrefix(prefix), type, results);
    }

    private static String extractIdentifier(String s, int start) {
        Matcher matcher = ID_PATTERN.matcher(s);
        if (!matcher.find(start)) {
            throw new RuntimeException("Unable to parse: '" + s + "'");
        }
        return matcher.group();
    }

    @Override
    public GDBResponse visitStreamRecord(@NotNull GdbParser.StreamRecordContext ctx) {
        String prefix = ctx.prefix.getText();
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.forPrefix(prefix), GDBResponseVisitor.getUnquotedString(ctx.cString(), true));
    }

    @NotNull
    private static String getUnquotedString(@NotNull GdbParser.CStringContext stringContext, boolean unescape) {
        String str = stringContext.getText();
        assert (str.length() >= 2) : "at least the enclosing quotes must be there";
        String result = str.substring(1, str.length() - 1);
        return unescape ? DebuggerDriver.unescapeString(result) : result;
    }
}

