/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class LLDBParser
implements PsiParser {
    private static final String[] LLDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "po", "expression", "expr"};
    private static final String[] LLDB_NOUNS = new String[]{"breakpoint", "command", "frame", "log", "memory", "platform", "process", "register", "settings", "source", "target", "thread", "type"};

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        this.parseLLDBCommand(builder);
        LLDBParser.eatEverything(builder);
        mark.done(root);
        return builder.getTreeBuilt();
    }

    private void parseLLDBCommand(PsiBuilder builder) {
        PsiBuilder.Marker command = builder.mark();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder.mark();
            builder.advanceLexer();
            if (LLDBParser.isNoun(commandName) && !builder.eof() && builder.getTokenType() == GDBTokenType.IDENTIFIER) {
                builder.advanceLexer();
            }
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (!builder.eof()) {
                LLDBParser.parseCommandArguments(builder, LLDBParser.isExpressionCommand(commandName));
            }
        } else {
            LLDBParser.eatEverything(builder);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isNoun(String name2) {
        return ArrayUtil.contains((String)name2, (String[])LLDB_NOUNS);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])LLDB_EXPRESSION_COMMANDS);
    }

    private static void parseCommandArguments(PsiBuilder builder, boolean isExpr) {
        PsiBuilder.Marker body = builder.mark();
        boolean optionsEaten = LLDBParser.eatEverythingUntilDashDash(builder);
        if (optionsEaten) {
            body.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
            PsiBuilder.Marker dashDash = builder.mark();
            builder.advanceLexer();
            dashDash.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
            body = builder.mark();
            LLDBParser.eatEverything(builder);
        }
        body.done((IElementType)(isExpr ? GDBTokenType.EXPRESSION_PLACEHOLDER : GDBTokenType.COMMAND_ARGUMENTS));
    }

    private static boolean eatEverythingUntilDashDash(PsiBuilder builder) {
        while (!builder.eof()) {
            if (builder.getTokenType() == GDBTokenType.DASHDASH && builder.rawLookup(1) != GDBTokenType.IDENTIFIER) {
                return true;
            }
            builder.advanceLexer();
        }
        return false;
    }

    private static void eatEverything(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }
}

