/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointFileTypesProvider;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrLineBreakpointType
extends XLineBreakpointType<XBreakpointProperties> {
    public static final String TYPE_ID = "com.jetbrains.cidr.execution.debugger.OCBreakpointType";
    private final Set<FileType> myFileTypes;

    public CidrLineBreakpointType() {
        this(TYPE_ID, CidrDebuggerBundle.message("debug.breakpoint.line", new Object[0]));
    }

    public CidrLineBreakpointType(String id, String displayName2) {
        super(id, displayName2);
        CidrLineBreakpointFileTypesProvider[] extensions = (CidrLineBreakpointFileTypesProvider[])CidrLineBreakpointFileTypesProvider.EP_NAME.getExtensions();
        this.myFileTypes = Arrays.stream(extensions).flatMap(it -> it.getFileTypes().stream()).collect(Collectors.toSet());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project2) {
        return this.myFileTypes.contains(file.getFileType());
    }

    public XBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        return null;
    }

    public String getBreakpointsDialogHelpTopic() {
        return super.getBreakpointsDialogHelpTopic();
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, @NotNull Project project2) {
        return CidrDebuggerLanguageSupportManager.createEditor(breakpoint);
    }
}

