/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerTypesHelper {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process2) {
        this.myProcess = process2;
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project2) {
        if (sourcePosition == null) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document2 == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document2, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document2, PsiFile psiFile) {
        PsiElement element;
        int positionOffset = sourcePosition.getOffset();
        if (!DocumentUtil.isValidOffset((int)positionOffset, (Document)document2)) {
            return null;
        }
        int lineEndOffset = document2.getLineEndOffset(document2.getLineNumber(positionOffset));
        int offset = positionOffset;
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(positionOffset);
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    @Nullable
    public Integer getSizeOf(@NotNull CidrPhysicalValue value) {
        return null;
    }

    @Nullable
    public abstract XSourcePosition computeSourcePosition(@NotNull CidrMemberValue var1);

    public PsiElement getContextElement(XSourcePosition position) {
        return CidrDebuggerTypesHelper.getContextElement(position, this.myProcess.getProject());
    }

    @Nullable
    public abstract XSourcePosition resolveProperty(@NotNull CidrMemberValue var1, @Nullable String var2);

    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        PsiReference ref = this.createReferenceFromText(var, context);
        if (ref == null) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return null;
        }
        if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
            return null;
        }
        return resolved;
    }

    @Nullable
    protected abstract PsiReference createReferenceFromText(@NotNull LLValue var1, @NotNull PsiElement var2);

    @Nullable
    public abstract Boolean isImplicitContextVariable(@NotNull XSourcePosition var1, @NotNull LLValue var2);

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        Matcher m = OPTIONAL_PATTERN.matcher(typeName);
        return m.matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        return StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
    }
}

