/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    private List<String> myPresentationErrors = Collections.synchronizedList(new ArrayList());

    public CidrValue(@NotNull String displayName2, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName2);
        this.myProcess = process2;
        this.myPosition = position;
        this.myFrame = frame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        return this.getEvaluationExpression(false);
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.getName();
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        navigatable.setSourcePosition(position == null ? null : this.doComputePosition(position));
    }

    @Nullable
    protected abstract XSourcePosition doComputePosition(@NotNull XSourcePosition var1);

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            if (node.isObsolete()) {
                return;
            }
            boolean hasChildren = false;
            try {
                XFullValueEvaluator evaluator;
                XValuePresentation presentation;
                Icon icon;
                EvaluationContext context = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                try {
                    hasChildren = this.doComputeMayHaveChildren(context);
                    icon = this.doComputeIcon(context, hasChildren);
                }
                catch (DebuggerCommandException e) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                    this.myPresentationErrors.add(e.getMessage());
                    hasChildren = true;
                }
                try {
                    Pair<XValuePresentation, XFullValueEvaluator> presentationAndEvaluator = this.doComputePresentationAndEvaluator(context);
                    presentation = (XValuePresentation)presentationAndEvaluator.first;
                    evaluator = (XFullValueEvaluator)presentationAndEvaluator.second;
                }
                catch (DebuggerCommandException e) {
                    CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                    return;
                }
                if (evaluator != null) {
                    node.setFullValueEvaluator(evaluator);
                }
                node.setPresentation(icon, presentation, hasChildren);
            }
            catch (ExecutionException e) {
                CidrErrorValue.doComputePresentation(node, CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)), hasChildren);
                throw e;
            }
        });
    }

    protected abstract boolean doComputeMayHaveChildren(@NotNull EvaluationContext var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    protected abstract Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    protected Pair<XValuePresentation, XFullValueEvaluator> doComputePresentationAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String type = this.doComputeType(context);
        Pair<String, XFullValueEvaluator> valueAndEvaluator = this.doComputeValueAndEvaluator(context);
        return Pair.create((Object)this.createValuePresentation(context, (String)valueAndEvaluator.first, type), (Object)valueAndEvaluator.second);
    }

    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        return new XRegularValuePresentation(value, type);
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        if (!this.myPresentationErrors.isEmpty()) {
            node.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        return errorNodesList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process2, position, frame));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode.addChildren(list, true);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws ExecutionException, DebuggerCommandException;

    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        return this.getProcess().createEvaluationContext(driver, expirable, this.myFrame);
    }
}

