/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationExpiredException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationContext
implements Expirable {
    private static final Key<Map<String, UserDataHolder>> TYPES_CACHE_KEY = Key.create((String)"TYPES_CACHE_KEY");
    @NotNull
    private final CidrStackFrame myFrame;
    protected final long myThreadId;
    protected final int myFrameIndex;
    @NotNull
    private final DebuggerDriver myDriver;
    @Nullable
    private final Expirable myExpirable;

    public EvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        this.myThreadId = frame.getThreadId();
        this.myFrameIndex = frame.getFrameIndex();
        this.myFrame = frame;
        this.myDriver = driver;
        this.myExpirable = expirable;
    }

    public boolean isExpired() {
        return this.myExpirable != null && this.myExpirable.isExpired();
    }

    public void checkExpiration() {
        if (this.myExpirable != null && this.isExpired()) {
            throw new EvaluationExpiredException(this, this.myExpirable);
        }
    }

    @NotNull
    public LLValue evaluate(@NotNull String expression) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(expression, null);
    }

    @NotNull
    public LLValueData evaluateData(@NotNull String expression) throws ExecutionException, DebuggerCommandException {
        return this.getData(this.evaluate(expression, null));
    }

    @NotNull
    public LLValue evaluate(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        return this.myDriver.evaluate(this.myThreadId, this.myFrameIndex, expression, language);
    }

    @NotNull
    public LLValueData evaluateData(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        return this.getData(this.evaluate(expression, language));
    }

    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        return EvaluationContext.cast(expr, type);
    }

    @NotNull
    public abstract String convertToRValue(@NotNull LLValueData var1, @NotNull Pair<LLValue, String> var2) throws DebuggerCommandException, ExecutionException;

    public static String cast(String expr, String type) {
        return "((" + type + ")(" + expr + "))";
    }

    @NotNull
    public LLValue messageSend(LLValueData self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(EvaluationContext.messageSendExpr(self.getPointer(), selectorAndArgs, returnType), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        return this.messageSend(this.getData(self), selectorAndArgs, returnType);
    }

    protected static String messageSendExpr(String expr, String selectorAndArgs, String returnType) {
        return EvaluationContext.cast("[" + EvaluationContext.cast(expr, "id") + " " + selectorAndArgs + "]", returnType);
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs) throws ExecutionException, DebuggerCommandException {
        return this.messageSend(self, selectorAndArgs, "id");
    }

    @NotNull
    public LLValueData messageSendData(LLValue self, String selectorAndArgs) throws ExecutionException, DebuggerCommandException {
        return this.getData(this.messageSend(self, selectorAndArgs));
    }

    public boolean isKindOfClass(String className, LLValue value) throws ExecutionException, DebuggerCommandException {
        return this.evaluateData("(unsigned char)((Class)objc_getClass(\"" + className + "\")?" + EvaluationContext.cast("[" + EvaluationContext.cast(this.getData(value).getPointer(), "id") + " isKindOfClass:(Class)objc_lookUpClass(\"" + className + "\")]", "unsigned char") + ":0)", DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).isTrue();
    }

    @NotNull
    public String stringFromNSString(LLValue nsstring) throws ExecutionException, DebuggerCommandException {
        return this.stringFromNSString(this.getData(nsstring).getPointer());
    }

    @NotNull
    public String stringFromNSString(String expr) throws ExecutionException, DebuggerCommandException {
        return StringUtil.unquoteString((String)this.evaluateData(EvaluationContext.stringFromNSStringExpr(expr), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).getPresentableValue());
    }

    private static String stringFromNSStringExpr(String expr) {
        String lengthExpr = EvaluationContext.messageSendExpr(expr, "length", "int");
        String substringExpr = EvaluationContext.messageSendExpr(expr, "substringToIndex:" + String.format("(((%s) > %d) ? %d : %s)", lengthExpr, 1000, 1000, lengthExpr), "id");
        return EvaluationContext.messageSendExpr(substringExpr, "UTF8String", "char *");
    }

    @NotNull
    public LLValueData getData(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        return this.myDriver.getData(var);
    }

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        return this.myDriver.getChildrenCount(var);
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue var, int offset, int size) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        return this.myDriver.getVariableChildren(var, offset, size);
    }

    @Nullable
    public <T> T getCachedTypeInfo(@NotNull String type, @NotNull Key<T> key) {
        UserDataHolder holder = this.getTypeInfoHolder(type);
        return (T)(holder == null ? null : holder.getUserData(key));
    }

    public <T> void putCachedTypeInfo(@NotNull String type, @NotNull Key<T> key, @Nullable T value) {
        UserDataHolder holder = this.getTypeInfoHolder(type);
        if (holder != null) {
            holder.putUserData(key, value);
        }
    }

    @Nullable
    private UserDataHolder getTypeInfoHolder(@NotNull String type) {
        if (type.equals("id")) {
            return null;
        }
        Map map2 = this.myFrame.getUserData(TYPES_CACHE_KEY);
        if (map2 == null) {
            map2 = this.myFrame.putUserDataIfAbsent(TYPES_CACHE_KEY, FactoryMap.create(key -> new UserDataHolderBase()));
        }
        return map2.get(type);
    }
}

