/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSEnumerableCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSCollectionValueRenderer
extends NSContainerValueRenderer {
    private static final List<Pattern> KNOWN_TYPES = Arrays.asList(Pattern.compile("(const )?_*NS(CF)?(Mutable)?Array\\w? \\*"), Pattern.compile("(const )?_*NS(CF)?(Mutable)?Set\\w? \\*"), Pattern.compile("(const )?_*NS(CF)?(Mutable)?Dictionary\\w? \\*"), Pattern.compile("Foundation\\.NS(Mutable)?Array"), Pattern.compile("Foundation\\.NS(Mutable)?Set"), Pattern.compile("Foundation\\.NS(Mutable)?Dictionary"), Pattern.compile("(const )?CF(Mutable)?ArrayRef"), Pattern.compile("(const )?CF(Mutable)?SetRef"), Pattern.compile("(const )?CF(Mutable)?DictionaryRef"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Array(Ref)?"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Set(Ref)?"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Dictionary(Ref)?"));
    private static final Pattern BROKEN_SWIFT_CF_TYPES = Pattern.compile("(const )?CF(Mutable)?((Array)|(Dictionary))Ref");
    private final Kind myKind;

    public NSCollectionValueRenderer(@NotNull CidrPhysicalValue value, @NotNull Kind kind) {
        super(value);
        this.myKind = kind;
    }

    @Nullable
    public static Kind getNSCollectionKind(@NotNull ValueRendererFactory.FactoryContext context) {
        LLValue var = context.getLLValue();
        LLValueData data = context.getLLValueData();
        if (!data.isValidPointer()) {
            return null;
        }
        String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(var.getType());
        if (KNOWN_TYPES.stream().noneMatch(each -> each.matcher(type).matches())) {
            return null;
        }
        if (type.contains("Dictionary")) {
            return Kind.DICTIONARY;
        }
        if (type.contains("Set")) {
            return Kind.SET;
        }
        return Kind.ARRAY;
    }

    @Override
    protected boolean mayHaveChildrenViaChildrenCount() {
        return true;
    }

    @Override
    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String description = StringUtil.notNullize((String)this.myValue.getVarData(context).getDescription()).trim();
        if ("0 elements".equals(description) || "{\n}".equals(description)) {
            return 0;
        }
        return super.doComputeChildrenCount(context);
    }

    @Override
    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children.size());
        for (LLValue each : children) {
            Couple<LLValue> keyValue;
            if (container.isObsolete()) {
                return;
            }
            Couple<LLValue> couple = keyValue = this.myKind == Kind.DICTIONARY ? NSCollectionValueRenderer.getDictionaryEntryChildren(context, each) : null;
            if (keyValue != null) {
                values.add(this.nextMapElementValue((LLValue)((Object)keyValue.first), (LLValue)((Object)keyValue.second)));
                continue;
            }
            values.add(this.nextElementValue(each));
        }
        CidrValue.addAllTo(values, container);
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        return NSCollectionValueRenderer.getChildEvaluationExpression(this.myValue, this.myKind, child, lvalue);
    }

    @NotNull
    static String getChildEvaluationExpression(@NotNull CidrPhysicalValue self, @NotNull Kind kind, @NotNull CidrPhysicalValue child, boolean lvalue) {
        int childIndex = ((CidrElementValue)child).getIndex();
        StringBuilder sb = new StringBuilder();
        String propertyName = null;
        if (kind == Kind.SET) {
            propertyName = "allObjects";
        } else if (kind == Kind.DICTIONARY) {
            String string = propertyName = "key".equals(child.getName()) ? "allKeys" : "allValues";
        }
        if (self.isSwiftContext()) {
            String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(self.getType());
            String castToType = null;
            if (type.startsWith("CoreFoundation.CF")) {
                castToType = type.replace("CoreFoundation.CF", "NS").replace("Ref", "");
            }
            if (castToType != null) {
                sb.append('(');
            }
            sb.append(self.getEvaluationExpression());
            if (self.isSwiftOptional()) {
                sb.append('!');
            }
            if (castToType != null) {
                sb.append(" as ").append(castToType).append(')');
            }
            if (propertyName != null) {
                sb.append('.').append(propertyName);
            }
            return sb.append("[").append(childIndex).append(']').toString();
        }
        sb.append("(id)[");
        String referenceExpression = self.getEvaluationExpression();
        if (propertyName != null) {
            sb.append('[').append(referenceExpression).append(' ').append(propertyName).append(']');
        } else {
            sb.append(referenceExpression);
        }
        return sb.append(" objectAtIndex:").append(childIndex).append(']').toString();
    }

    public static class Factory
    implements ValueRendererFactory {
        @Override
        @Nullable
        public ValueRenderer createRenderer(@NotNull ValueRendererFactory.FactoryContext context) throws DebuggerCommandException {
            if (!context.getSettings().COCOA_RENDERERS_ENABLED) {
                return null;
            }
            Kind kind = NSCollectionValueRenderer.getNSCollectionKind(context);
            if (kind == null) {
                return null;
            }
            if (!context.getLLValueData().isSynthetic() || BROKEN_SWIFT_CF_TYPES.matcher(context.getLLValue().getType()).matches()) {
                return new NSEnumerableCollectionValueRenderer(context.getPhysicalValue(), kind);
            }
            return new NSCollectionValueRenderer(context.getPhysicalValue(), kind);
        }
    }

    public static enum Kind {
        ARRAY,
        SET,
        DICTIONARY;

    }
}

