/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NSContainerValueRenderer
extends ContainerValueRenderer {
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("@?\"?\\d+ ((values?)|(elements?)|(key/value pairs?))\"?");

    public NSContainerValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected boolean ignoreDescription(@NotNull String description) {
        return super.ignoreDescription(description) || !DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @Override
    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        String type = this.getValue().getType();
        String name2 = StringUtil.containsIgnoreCase((String)type, (String)"Dictionary") ? "key/value pair" : (StringUtil.contains((CharSequence)type, (CharSequence)"NS") ? "element" : "value");
        int count = this.computeChildrenCount(context);
        return count + " " + StringUtil.pluralize((String)name2, (int)count);
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_array;
    }

    @Nullable
    protected static Couple<LLValue> getDictionaryEntryChildren(@NotNull EvaluationContext context, @NotNull LLValue entry) throws ExecutionException, DebuggerCommandException {
        DebuggerDriver.ResultList<LLValue> result = context.getVariableChildren(entry, 0, 2);
        if (result.list.size() == 2 && !result.hasMore) {
            return Couple.of(result.list.get(0), result.list.get(1));
        }
        CidrDebuggerLog.LOG.warn("Unexpected dictionary layout");
        return null;
    }
}

