/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorValueRenderer
extends ValueRenderer {
    public SelectorValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Nullable
    public static ValueRenderer createIfSelector(@NotNull ValueRendererFactory.FactoryContext context) {
        String type;
        SelectorValueRenderer result = null;
        if (context.getLLValueData().isValidPointer() && SelectorValueRenderer.isSelectorType(type = context.getLLValue().getType())) {
            result = new SelectorValueRenderer(context.getPhysicalValue());
        }
        return result;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String result = this.getValue().getVarData(context).getDescription();
        if (StringUtil.isEmptyOrSpaces((String)result) || StringUtil.unquoteString((String)result).isEmpty()) {
            String pointer = context.getData(this.myValue.getVar()).getPointer();
            result = context.evaluateData("(char *)sel_getName((void *)" + pointer + ")").getPresentableValue();
        }
        return Pair.create((Object)result, null);
    }

    public static boolean isSelectorType(@NotNull String type) {
        return type.endsWith("objc_selector *") || type.equals("SEL");
    }
}

