/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceImpl;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtilKt;
import com.jetbrains.cidr.execution.debugger.memory.InternalMutableIntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import com.jetbrains.cidr.execution.debugger.memory.IntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.IntervalTreeMap;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001EB\u0011\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0001\u0010\u0018*\u00028\u00002\u0006\u0010\u0019\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ;\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0001\u0010\u0018*\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00180\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ4\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!\"\b\b\u0001\u0010\u0018*\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00180\u001eH\u0016J6\u0010\"\u001a\u0002H\u0018\"\b\b\u0001\u0010\u0018*\u00028\u00002\u0006\u0010#\u001a\u00020$2\u0014\b\u0004\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00180\u001eH\u0082\b\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0011\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0096\u0002J\u0010\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0011\u0010,\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0096\u0002J \u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000.2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000.2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J)\u0010/\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u001eH\u0016\u00a2\u0006\u0002\u00100J\u0017\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u00102J\u001b\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00104J7\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0019\u001a\u00028\u00002\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u000006H\u0016\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001f\u00109\u001a\u0002H:\"\b\b\u0001\u0010:*\u00020\f2\u0006\u0010)\u001a\u0002H:H\u0002\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001d\u0010=\u001a\u00020>2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010?J\u0015\u0010@\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u00102J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0016\u0010<\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010A\u001a\u00020(H\u0002J\u001c\u0010<\u001a\u00020\u0005*\u00020\u00052\u0006\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020(H\u0002J\f\u0010D\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0004\u0018\u00018\u0000*\u00020\f8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006F"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl;", "G", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "arena", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "myIntervalMap", "Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;", "(Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;)V", "intervals", "", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "getIntervals", "()Ljava/util/Collection;", "range", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "asRegion", "asRegion$annotations", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)V", "getAsRegion", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "allocate", "R", "region", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "createRegion", "Lkotlin/Function1;", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "allocateMissing", "", "allocateRegion", "hole", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "allocationHoleFor", "contains", "", "interval", "contiguousRegions", "filterRegions", "get", "getNeighbors", "Lkotlin/Pair;", "getOrAllocate", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "getRegion", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "reallocate", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "shrinkEdgeRegion", "Lkotlin/Function2;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;Lkotlin/jvm/functions/Function2;)Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "regionSpan", "replaceIntervalWithHole", "I", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "span", "splitHolePutRegion", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)V", "unallocate", "beyondBoundaries", "beyondLeftBoundary", "beyondRightBoundary", "spanAdjacentHoles", "Hole", "intellij.cidr.debugger"})
public class AddressSpaceImpl<G extends AddressSpace.Region>
implements MutableAddressSpace<G> {
    private final InternalMutableIntervalMap myIntervalMap;

    private static /* synthetic */ void asRegion$annotations(Interval interval) {
    }

    private final G getAsRegion(@NotNull Interval $receiver) {
        AddressSpace.Region region;
        Interval interval = $receiver;
        if (!(interval instanceof AddressSpace.Region)) {
            interval = null;
        }
        if (!((region = (AddressSpace.Region)interval) instanceof AddressSpace.Region)) {
            region = null;
        }
        return (G)region;
    }

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.myIntervalMap.getRange();
    }

    @Override
    @NotNull
    public Collection<Interval> getIntervals() {
        return this.myIntervalMap.getIntervals();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<G> filterRegions() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getIntervals();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            G g;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            Interval it = (Interval)element$iv$iv;
            boolean bl = false;
            if (this.getAsRegion(it) == null) continue;
            G it$iv$iv = g;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<G> contiguousRegions() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getIntervals();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            G g;
            void it;
            Interval interval = (Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (this.getAsRegion((Interval)it) == null) {
                return null;
            }
            collection.add(g);
        }
        return (List)var3_3;
    }

    @Override
    @Nullable
    public G getRegion(@NotNull Address address) {
        return this.getAsRegion(this.myIntervalMap.get(address));
    }

    @Override
    @NotNull
    public Interval get(@NotNull Address address) {
        return this.myIntervalMap.get(address);
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> get(@NotNull AddressRange range) {
        return new AddressSpaceImpl<G>(this.myIntervalMap.get(range));
    }

    @Override
    public boolean contains(@NotNull Interval interval) {
        return this.myIntervalMap.contains(interval);
    }

    @Override
    @NotNull
    public Pair<G, G> getNeighbors(@NotNull Address address) {
        Interval interval = this.myIntervalMap.get(address);
        return this.getNeighbors(interval.getRange());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<G, G> getNeighbors(@NotNull AddressRange range) {
        void prev;
        AddressRange addressRange = this.span(this.spanAdjacentHoles(range), true);
        Address address = addressRange.component1();
        Address next = addressRange.component2();
        return new Pair(range.contains((Comparable)prev) ? null : this.getRegion((Address)prev), range.contains((Comparable)next) ? null : this.getRegion(next));
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> reallocate(@NotNull G region) {
        MutableAddressSpace<G> unallocatedSpace = this.unallocate(region.getRange());
        this.allocate(region);
        return unallocatedSpace;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableAddressSpace<G> reallocate(@NotNull G region, @NotNull Function2<? super G, ? super AddressRange, ? extends G> shrinkEdgeRegion) {
        AddressRange range = region.getRange();
        MutableAddressSpace<G> unallocatedSpace = this.unallocate(range);
        this.allocate(region);
        List unallocatedRegions = unallocatedSpace.filterRegions();
        Pair<AddressRange, AddressRange> pair2 = AddressSpace.DefaultImpls.regionSpan$default(unallocatedSpace, null, 1, null).splitBy(range);
        AddressRange addressRange = (AddressRange)pair2.component1();
        AddressRange tailRange = (AddressRange)pair2.component2();
        Function2 reallocateEdge$ = new Function2<G, AddressRange, Unit>(this, shrinkEdgeRegion){
            final /* synthetic */ AddressSpaceImpl this$0;
            final /* synthetic */ Function2 $shrinkEdgeRegion;

            public final void invoke(@NotNull G edgeRegion, @NotNull AddressRange subRange) {
                AddressSpace.Region region = (AddressSpace.Region)this.$shrinkEdgeRegion.invoke(edgeRegion, (Object)subRange);
                if (region == null) {
                    return;
                }
                AddressSpace.Region subRegion = region;
                AddressUtilKt.checkInRange((Interval)subRegion, subRange);
                this.this$0.allocate(subRegion);
            }
            {
                this.this$0 = addressSpaceImpl;
                this.$shrinkEdgeRegion = function2;
                super(2);
            }
        };
        Collection collection = unallocatedRegions;
        if (!collection.isEmpty()) {
            void headRange;
            if (!headRange.isEmpty()) {
                reallocateEdge$.invoke((AddressSpace.Region)CollectionsKt.first(unallocatedRegions), (AddressRange)headRange);
            }
            if (!tailRange.isEmpty()) {
                reallocateEdge$.invoke((AddressSpace.Region)CollectionsKt.last(unallocatedRegions), tailRange);
            }
        }
        return unallocatedSpace;
    }

    @Override
    @NotNull
    public <R extends G> R allocate(@NotNull R region) {
        boolean bl;
        AddressRange holeRange$iv;
        Interval interval;
        AddressRange range = region.getRange();
        Collection<Interval> intervals = this.myIntervalMap.get(range).getIntervals();
        Object object = CollectionsKt.singleOrNull((Iterable)intervals);
        if (!(object instanceof Hole)) {
            object = null;
        }
        Hole it = interval = (Hole)object;
        boolean bl2 = false;
        if (it == null) {
            boolean bl3 = false;
            String string = "Range " + range + " is occupied with " + intervals;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Hole hole = interval;
        if (hole == null) {
            Intrinsics.throwNpe();
        }
        Hole hole2 = hole;
        AddressSpaceImpl this_$iv = this;
        boolean $i$f$allocateRegion = false;
        AddressRange it2 = holeRange$iv = hole2.getRange();
        boolean bl4 = false;
        AddressSpace.Region region$iv = (AddressSpace.Region)AddressUtilKt.checkInRange((Interval)region, holeRange$iv);
        this_$iv.splitHolePutRegion(hole2, region$iv);
        Interval it22 = interval = region$iv;
        boolean bl5 = false;
        boolean bl6 = bl = it22 == region;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (R)interval;
    }

    @Override
    @NotNull
    public G getOrAllocate(@NotNull Address address, @NotNull Function1<? super AddressRange, ? extends G> createRegion) {
        G g = this.getRegion(address);
        if (g == null) {
            g = this.allocate(address, this.get(address).getRange(), createRegion);
        }
        return g;
    }

    @Override
    @NotNull
    public <R extends G> R allocate(@NotNull Address address, @NotNull AddressRange range, @NotNull Function1<? super AddressRange, ? extends R> createRegion) {
        AddressRange holeRange$iv;
        AddressUtilKt.requireInRange(address, range);
        AddressSpaceKt.access$requireAddressInArena(this.myIntervalMap, address);
        Hole hole = this.allocationHoleFor(address);
        AddressSpaceImpl this_$iv = this;
        boolean $i$f$allocateRegion = false;
        AddressRange holeRange = holeRange$iv = hole.getRange();
        boolean bl = false;
        AddressSpace.Region region$iv = (AddressSpace.Region)AddressUtilKt.checkInRange((Interval)((AddressSpace.Region)createRegion.invoke((Object)holeRange.intersectWith(range))), holeRange$iv);
        this_$iv.splitHolePutRegion(hole, region$iv);
        return (R)region$iv;
    }

    private final Hole allocationHoleFor(Address address) {
        Interval interval = this.myIntervalMap.get(address);
        boolean bl = interval instanceof Hole;
        if (!bl) {
            boolean bl2 = false;
            String string = "Interval at " + address + " is occupied by " + interval;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (Hole)interval;
    }

    @Override
    @NotNull
    public <R extends G> List<R> allocateMissing(@NotNull AddressRange range, @NotNull Function1<? super AddressRange, ? extends R> createRegion) {
        List allocatedRegions = new ArrayList();
        Iterable $receiver$iv = this.myIntervalMap.get(range).getIntervals();
        for (Object element$iv : $receiver$iv) {
            AddressRange holeRange$iv;
            Interval interval = (Interval)element$iv;
            boolean bl = false;
            if (!(interval instanceof Hole)) continue;
            Collection collection = allocatedRegions;
            AddressSpaceImpl this_$iv = this;
            boolean $i$f$allocateRegion = false;
            AddressRange holeRange = holeRange$iv = ((Hole)interval).getRange();
            boolean bl2 = false;
            AddressSpace.Region region$iv = (AddressSpace.Region)AddressUtilKt.checkInRange((Interval)((AddressSpace.Region)createRegion.invoke((Object)holeRange.intersectWith(range))), holeRange$iv);
            this_$iv.splitHolePutRegion((Hole)interval, region$iv);
            AddressSpace.Region region = region$iv;
            collection.add(region);
        }
        return allocatedRegions;
    }

    private final <R extends G> R allocateRegion(Hole hole, Function1<? super AddressRange, ? extends R> createRegion) {
        int $i$f$allocateRegion = 0;
        AddressRange holeRange = hole.getRange();
        AddressSpace.Region region = (AddressSpace.Region)AddressUtilKt.checkInRange((Interval)createRegion.invoke((Object)holeRange), holeRange);
        this.splitHolePutRegion(hole, region);
        return (R)region;
    }

    /*
     * WARNING - void declaration
     */
    private final void splitHolePutRegion(Hole hole, G region) {
        AddressRange holeRange = hole.getRange();
        AddressRange regionRange = region.getRange();
        this.myIntervalMap.remove(hole);
        if (Intrinsics.areEqual((Object)regionRange, (Object)holeRange) ^ true) {
            Hole hole2;
            void precedingRange;
            AddressUtilKt.checkInRange(regionRange, holeRange);
            Pair<AddressRange, AddressRange> pair2 = holeRange.splitBy(regionRange);
            AddressRange addressRange = (AddressRange)pair2.component1();
            AddressRange followingRange = (AddressRange)pair2.component2();
            splitHolePutRegion.1 newHoleUnlessEmpty$ = splitHolePutRegion.1.INSTANCE;
            Hole hole3 = newHoleUnlessEmpty$.invoke((AddressRange)precedingRange);
            if (hole3 != null) {
                Hole precedingHole = hole2 = hole3;
                boolean bl = false;
                this.myIntervalMap.put(precedingHole);
            }
            this.myIntervalMap.put((Interval)region);
            Hole hole4 = newHoleUnlessEmpty$.invoke(followingRange);
            if (hole4 != null) {
                Hole followingHole = hole2 = hole4;
                boolean bl = false;
                this.myIntervalMap.put(followingHole);
            }
        } else {
            this.myIntervalMap.put((Interval)region);
        }
    }

    @Override
    @Nullable
    public G unallocate(@NotNull Address address) {
        G g = this.getAsRegion(this.myIntervalMap.get(address));
        if (g == null) {
            return null;
        }
        G unallocatedRegion = g;
        return (G)((AddressSpace.Region)this.replaceIntervalWithHole((Interval)unallocatedRegion));
    }

    @Override
    @NotNull
    public G unallocate(@NotNull G region) {
        boolean bl = this.contains((Interval)region);
        if (!bl) {
            boolean bl2 = false;
            String string = "Attempting to unallocate region " + region + " which is not allocated";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (G)((AddressSpace.Region)this.replaceIntervalWithHole((Interval)region));
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> unallocate(@NotNull AddressRange range) {
        IntervalMap unallocatedSpace = this.get(range);
        return (MutableAddressSpace)this.replaceIntervalWithHole((Interval)unallocatedSpace);
    }

    private final <I extends Interval> I replaceIntervalWithHole(I interval) {
        AddressRange holeRange = this.spanAdjacentHoles(interval.getRange());
        this.myIntervalMap.removeAll(holeRange);
        this.myIntervalMap.put(new Hole(holeRange));
        return interval;
    }

    @Override
    @NotNull
    public AddressRange span(@NotNull AddressRange range) {
        return this.myIntervalMap.span(range);
    }

    @Override
    @NotNull
    public AddressRange regionSpan(@NotNull AddressRange range) {
        Interval lastInterval;
        AddressRange span2 = this.span(range);
        Interval firstInterval = this.get(span2.getStart());
        if (firstInterval == (lastInterval = this.get(span2.getEndInclusive()))) {
            return firstInterval instanceof Hole ? AddressRange.EMPTY : firstInterval.getRange();
        }
        Address start = firstInterval instanceof Hole ? firstInterval.getRange().getEndInclusive().plus(1) : firstInterval.getRange().getStart();
        Address endInclusive = lastInterval instanceof Hole ? lastInterval.getRange().getStart().minus(1) : lastInterval.getRange().getEndInclusive();
        return start.rangeTo(endInclusive);
    }

    private final AddressRange span(@NotNull AddressRange $receiver, boolean beyondBoundaries) {
        return this.span($receiver, beyondBoundaries, beyondBoundaries);
    }

    static /* synthetic */ AddressRange span$default(AddressSpaceImpl addressSpaceImpl, AddressRange addressRange, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: span");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return addressSpaceImpl.span(addressRange, bl);
    }

    private final AddressRange span(@NotNull AddressRange $receiver, boolean beyondLeftBoundary, boolean beyondRightBoundary) {
        AddressRange addressRange;
        AddressRange addressRange2;
        AddressRange $receiver2 = addressRange2 = this.span($receiver);
        boolean bl = false;
        if (!beyondLeftBoundary && !beyondRightBoundary) {
            addressRange = $receiver2;
        } else {
            span.1.1 plus$ = span.1.1.INSTANCE;
            span.1.2 minus$ = span.1.2.INSTANCE;
            addressRange = this.span(minus$.invoke($receiver2.getStart(), beyondLeftBoundary).rangeTo(plus$.invoke($receiver2.getEndInclusive(), beyondRightBoundary)));
        }
        return addressRange;
    }

    private final AddressRange spanAdjacentHoles(@NotNull AddressRange $receiver) {
        AddressRange addressRange;
        AddressRange $receiver2 = addressRange = AddressSpaceImpl.span$default(this, $receiver, false, 1, null);
        boolean bl = false;
        AddressRange adjacentRange = this.span($receiver2, true);
        return this.span($receiver2, this.myIntervalMap.get(adjacentRange.getStart()) instanceof Hole, this.myIntervalMap.get(adjacentRange.getEndInclusive()) instanceof Hole);
    }

    private AddressSpaceImpl(InternalMutableIntervalMap myIntervalMap) {
        this.myIntervalMap = myIntervalMap;
    }

    public AddressSpaceImpl(@NotNull AddressRange arena) {
        this(new IntervalTreeMap(arena, null, 2, null));
        this.myIntervalMap.put(new Hole(arena));
    }

    public /* synthetic */ AddressSpaceImpl(AddressRange addressRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            addressRange = AddressRange.WHOLE;
        }
        this(addressRange);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.cidr.debugger"})
    private static final class Hole
    implements Interval {
        @NotNull
        private final AddressRange range;

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        public Hole(@NotNull AddressRange range) {
            this.range = range;
        }

        @NotNull
        public final AddressRange component1() {
            return this.getRange();
        }

        @NotNull
        public final Hole copy(@NotNull AddressRange range) {
            return new Hole(range);
        }

        @NotNull
        public static /* synthetic */ Hole copy$default(Hole hole, AddressRange addressRange, int n, Object object) {
            if ((n & 1) != 0) {
                addressRange = hole.getRange();
            }
            return hole.copy(addressRange);
        }

        @NotNull
        public String toString() {
            return "Hole(range=" + this.getRange() + ")";
        }

        public int hashCode() {
            AddressRange addressRange = this.getRange();
            return addressRange != null ? ((Object)addressRange).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Hole)) break block3;
                    Hole hole = (Hole)object;
                    if (!Intrinsics.areEqual((Object)this.getRange(), (Object)hole.getRange())) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

