/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtilKt;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocInterval;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 E*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0001EB7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u00020\u001a2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u000bH\u0002J\u0014\u0010\"\u001a\u00020\u001a2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0014J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J\u0012\u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010)\u001a\u00020'H&J\u000e\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020%J\u0010\u0010,\u001a\u00020'2\u0006\u0010+\u001a\u00020%H&J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020'2\u0006\u0010+\u001a\u00020%J\u0018\u00100\u001a\u00020'2\u0006\u0010+\u001a\u00020%2\u0006\u0010)\u001a\u00020'H\u0016J\b\u00101\u001a\u00020\u001aH\u0016J$\u00102\u001a\u00020\u001a2\n\u00103\u001a\u000604j\u0002`52\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000007H&J\u0014\u00108\u001a\u00020\u001a2\n\u00103\u001a\u000604j\u0002`5H\u0016J\u0014\u00109\u001a\u00020\u001a2\n\u00103\u001a\u000604j\u0002`5H\u0016J\u0014\u0010:\u001a\u00020\u001a2\n\u0010;\u001a\u00060<j\u0002`=H\u0002J\b\u0010>\u001a\u00020?H\u0016J\"\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00070A*\u00020B2\u0006\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020'H\u0002R\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006F"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/DocInterval;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "getRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "deleteSafely", "", "dispose", "deleteFromDocument", "", "doRenderError", "exception", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataLoadException;", "doRenderReallocated", "doRenderSeamless", "oldRegion", "getAddressForLineNumberInDocument", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "line", "", "getAddressForLineNumberInsideRegion", "lineNumber", "getLineNumberInDocument", "address", "getLineNumberInsideRegion", "getLineRangeInDocument", "Lkotlin/ranges/IntRange;", "getOffsetInDocument", "getOffsetInsideLine", "markOutdated", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "replaceSafely", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "", "getProtectedRanges", "", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "startOffset", "endOffset", "Companion", "intellij.cidr.debugger"})
public abstract class DocRegion<T>
implements DocInterval,
AddressSpace.Region {
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final CidrMemoryData.Data<T> data;
    private final CidrMemoryData.DataRegion<T> dataRegion;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public final AddressRange getRange() {
        return this.dataRegion.getRange();
    }

    @Override
    @NotNull
    public final RangeMarker getRangeMarker() {
        return this.rangeMarker;
    }

    @NotNull
    protected final CidrMemoryData.Data<T> getData() {
        return this.data;
    }

    private final void doRenderError(CidrMemoryData.DataLoadException exception) {
        this.getDocument().replaceString(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset(), (CharSequence)('\n' + exception.getMessage()));
    }

    protected void doRenderSeamless(@NotNull DocRegion<?> oldRegion) {
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        Iterable<CidrMemoryData.DataEntry<T>> $receiver$iv = this.data.getEntries();
        Iterator<CidrMemoryData.DataEntry<T>> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            CidrMemoryData.DataEntry<T> element$iv;
            CidrMemoryData.DataEntry<T> entry = element$iv = iterator2.next();
            boolean bl = false;
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        if (oldRegion.getTextRange().getLength() == sb.length()) {
            super.replaceSafely(sb);
        } else {
            this.getDocument().replaceString(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset(), (CharSequence)sb);
        }
    }

    private final void doRenderReallocated(AddressSpace<DocRegion<T>> reallocatedSpace) {
        StringBuilder sb = new StringBuilder();
        int lastOffset = this.rangeMarker.getStartOffset();
        this.renderHeader(sb);
        for (CidrMemoryData.DataEntry<T> entry : this.data.getEntries()) {
            Iterable $receiver$iv = reallocatedSpace.get(entry.getRange()).filterRegions();
            for (Object element$iv : $receiver$iv) {
                Unit unit;
                boolean bl;
                DocRegion reallocatedRegion = (DocRegion)element$iv;
                boolean bl2 = false;
                boolean bl3 = bl = reallocatedRegion.getDocument() == this.getDocument();
                if (!bl) {
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.getDocument().insertString(lastOffset, (CharSequence)sb);
                Unit it = unit = Unit.INSTANCE;
                boolean bl4 = false;
                lastOffset += sb.length();
                sb.setLength(0);
                reallocatedRegion.deleteSafely();
            }
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        this.getDocument().replaceString(lastOffset, this.rangeMarker.getEndOffset(), (CharSequence)sb);
    }

    private final void replaceSafely(StringBuilder sb) {
        DocumentEx documentEx;
        Document document2 = this.getDocument();
        if (document2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        }
        DocumentEx $receiver = documentEx = (DocumentEx)document2;
        boolean bl = false;
        int offset = this.rangeMarker.getStartOffset();
        List<TextRange> protectedRanges = this.getProtectedRanges($receiver, offset, this.rangeMarker.getEndOffset());
        for (TextRange textRange : protectedRanges) {
            int startOffset = AddressUtilKt.component1(textRange);
            int endOffset = AddressUtilKt.component2(textRange);
            $receiver.replaceString(startOffset, endOffset, (CharSequence)sb.substring(startOffset - offset, endOffset - offset));
        }
    }

    private final void deleteSafely() {
        DocumentEx documentEx;
        Document document2 = this.getDocument();
        if (document2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        }
        DocumentEx $receiver = documentEx = (DocumentEx)document2;
        boolean bl = false;
        List<TextRange> protectedRanges = this.getProtectedRanges($receiver, this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset());
        for (TextRange textRange : CollectionsKt.reversed((Iterable)protectedRanges)) {
            int startOffset = AddressUtilKt.component1(textRange);
            int endOffset = AddressUtilKt.component2(textRange);
            $receiver.deleteString(startOffset, endOffset);
        }
        boolean bl2 = this.getTextRange().isEmpty();
        if (!bl2) {
            boolean bl3 = false;
            String string = "DocRegion text range is not empty after deleting it";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getProtectedRanges(@NotNull DocumentEx $receiver, int startOffset, int endOffset) {
        List list;
        int n;
        Editor[] $receiver$iv22;
        Set protectedOffsets = new LinkedHashSet();
        int length = endOffset - startOffset;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        int n2 = startOffset;
        IntRange range = new IntRange(n2, endOffset);
        Processor processor2 = (Processor)new Processor<RangeMarker>(range, protectedOffsets, startOffset){
            final /* synthetic */ IntRange $range;
            final /* synthetic */ Set $protectedOffsets;
            final /* synthetic */ int $startOffset;

            public final boolean process(RangeMarker eachMarker) {
                Integer n;
                Collection collection;
                int n2;
                int it = n2 = eachMarker.getStartOffset();
                boolean bl = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    collection.add(n);
                }
                it = n2 = eachMarker.getEndOffset();
                boolean bl2 = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    collection.add(n);
                }
                return true;
            }
            {
                this.$range = intRange;
                this.$protectedOffsets = set;
                this.$startOffset = n;
            }
        };
        $receiver.processRangeMarkersOverlappingWith(startOffset, endOffset, processor2);
        Object object = $receiver$iv22 = EditorFactory.getInstance().getEditors((Document)$receiver);
        int n3 = ((Editor[])object).length;
        for (int i = 0; i < n3; ++i) {
            EditorEx editorEx;
            Editor element$iv;
            Editor editor = element$iv = object[i];
            n = 0;
            Editor editor2 = editor;
            if (!(editor2 instanceof EditorEx)) {
                editor2 = null;
            }
            if ((editorEx = (EditorEx)editor2) == null || (editorEx = editorEx.getMarkupModel()) == null) continue;
            editorEx.processRangeHighlightersOverlappingWith(startOffset, endOffset, processor2);
        }
        boolean $receiver$iv22 = protectedOffsets.contains(0);
        if (_Assertions.ENABLED && !$receiver$iv22) {
            object = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(object));
        }
        $receiver$iv22 = protectedOffsets.contains(length);
        if (_Assertions.ENABLED && !$receiver$iv22) {
            object = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(object));
        }
        Iterable $receiver$iv = CollectionsKt.sorted((Iterable)protectedOffsets);
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void eachEndOffset;
                void eachStartOffset;
                Object next$iv = iterator$iv.next();
                int editor = ((Number)next$iv).intValue();
                n = ((Number)current$iv).intValue();
                List list2 = result$iv;
                boolean bl = false;
                TextRange textRange = new TextRange(startOffset + eachStartOffset, startOffset + eachEndOffset);
                list2.add(textRange);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    public void markOutdated() {
    }

    public void dispose(boolean deleteFromDocument) {
        if (this.rangeMarker.isValid()) {
            if (deleteFromDocument) {
                this.getDocument().deleteString(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset());
            }
            this.rangeMarker.dispose();
        }
    }

    public static /* synthetic */ void dispose$default(DocRegion docRegion, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dispose");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        docRegion.dispose(bl);
    }

    public abstract void renderEntry(@NotNull Appendable var1, @NotNull CidrMemoryData.DataEntry<? extends T> var2);

    public void renderHeader(@NotNull Appendable buffer) {
    }

    public void renderFooter(@NotNull Appendable buffer) {
    }

    @Nullable
    public abstract Address getAddressForLineNumberInsideRegion(int var1);

    public abstract int getLineNumberInsideRegion(@NotNull Address var1);

    public int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        return 0;
    }

    @NotNull
    public final IntRange getLineRangeInDocument() {
        boolean bl = this.rangeMarker.isValid();
        if (!bl) {
            boolean bl2 = false;
            String string = "Region is disposed or otherwise removed from the Document";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int regionStartLineNumber = this.getDocument().getLineNumber(this.rangeMarker.getStartOffset());
        int regionEndLineNumber = this.getDocument().getLineNumber(this.rangeMarker.getEndOffset());
        int n = regionStartLineNumber;
        return new IntRange(n, regionEndLineNumber);
    }

    @Nullable
    public final Address getAddressForLineNumberInDocument(int line) {
        int n;
        IntRange regionLineRange = this.getLineRangeInDocument();
        int it = n = RangesKt.coerceIn((int)line, (ClosedRange)((ClosedRange)regionLineRange));
        boolean bl = false;
        if (it != line) {
            CidrDebuggerLog.LOG.warn("Line number " + line + " is outside the region line range " + regionLineRange);
        }
        int lineNumberInsideRegion = n - regionLineRange.getStart();
        return this.getAddressForLineNumberInsideRegion(lineNumberInsideRegion);
    }

    public final int getLineNumberInDocument(@NotNull Address address) {
        int n;
        boolean bl = this.rangeMarker.isValid();
        if (!bl) {
            boolean bl2 = false;
            String string = "Region is disposed or otherwise removed from the Document";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int regionLineNumber = this.getDocument().getLineNumber(this.rangeMarker.getStartOffset());
        int lineNumber = !this.getRange().contains((Comparable)address) ? 0 : this.getLineNumberInsideRegion(address);
        int it = n = RangesKt.coerceIn((int)(regionLineNumber + lineNumber), (int)0, (int)(this.getDocument().getLineCount() - 1));
        boolean bl3 = false;
        if (regionLineNumber + lineNumber != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + '+' + lineNumber + " is outside the document boundary " + it);
        }
        return n;
    }

    public final int getOffsetInDocument(@NotNull Address address) {
        int lineNumber = this.getLineNumberInDocument(address);
        int offsetInLine = this.getOffsetInsideLine(address, lineNumber);
        return RangesKt.coerceIn((int)(this.getDocument().getLineStartOffset(lineNumber) + offsetInLine), (int)0, (int)(this.getDocument().getTextLength() - 1));
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(range=" + this.getRange() + ", myRangeMarker=" + this.rangeMarker + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<T> dataRegion, @NotNull AddressSpace<DocRegion<T>> reallocatedSpace) {
        boolean bl;
        void $receiver$iv;
        Object object;
        Object object2;
        Interval it;
        Object object3;
        this.dataRegion = dataRegion;
        this.rangeMarker = document2.createRangeMarker(textRange);
        this.data = this.dataRegion.getData();
        boolean bl2 = reallocatedSpace.getRange().contains(this.getRange());
        if (!bl2) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Interval interval = (Interval)CollectionsKt.singleOrNull((Iterable)reallocatedSpace.getIntervals());
        if (interval != null) {
            object3 = interval;
            it = object3;
            boolean bl3 = false;
            object2 = Intrinsics.areEqual(it.getClass(), this.getClass()) && Intrinsics.areEqual((Object)it.getRange(), (Object)this.getRange()) ? object3 : null;
        } else {
            object2 = object = null;
        }
        if (!(object2 instanceof DocRegion)) {
            object = null;
        }
        DocRegion seamlessRegionUpdate = (DocRegion)object;
        it = this.rangeMarker;
        object3 = Companion;
        boolean value$iv = true;
        boolean $i$f$withMarkerGreedy = false;
        boolean savedToLeft$iv = $receiver$iv.isGreedyToLeft();
        boolean savedToRight$iv = $receiver$iv.isGreedyToRight();
        $receiver$iv.setGreedyToLeft(value$iv);
        $receiver$iv.setGreedyToRight(value$iv);
        try {
            boolean bl4 = false;
            if (this.dataRegion instanceof CidrMemoryData.DataRegion.Completed.LoadError) {
                this.doRenderError(((CidrMemoryData.DataRegion.Completed.LoadError)this.dataRegion).getException());
            } else if (seamlessRegionUpdate != null) {
                this.doRenderSeamless(seamlessRegionUpdate);
            } else {
                this.doRenderReallocated(reallocatedSpace);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.setGreedyToLeft(savedToLeft$iv);
            $receiver$iv.setGreedyToRight(savedToRight$iv);
        }
        boolean bl5 = bl = this.rangeMarker.getStartOffset() != this.rangeMarker.getEndOffset();
        if (!bl) {
            boolean bl6 = false;
            String string = "DocRegion text range is empty after rendering";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        return DocInterval.DefaultImpls.getDocument(this);
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return DocInterval.DefaultImpls.getTextRange(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0001\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\tH\u0082\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion$Companion;", "", "()V", "withMarkerGreedy", "R", "Lcom/intellij/openapi/editor/RangeMarker;", "value", "", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/editor/RangeMarker;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.cidr.debugger"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <R> R withMarkerGreedy(@NotNull RangeMarker $receiver, boolean value, Function0<? extends R> block) {
            int $i$f$withMarkerGreedy = 0;
            boolean savedToLeft = $receiver.isGreedyToLeft();
            boolean savedToRight = $receiver.isGreedyToRight();
            $receiver.setGreedyToLeft(value);
            $receiver.setGreedyToRight(value);
            try {
                Object object = block.invoke();
                return (R)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $receiver.setGreedyToLeft(savedToLeft);
                $receiver.setGreedyToRight(savedToRight);
                InlineMarker.finallyEnd((int)1);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ Object access$withMarkerGreedy(Companion $this, RangeMarker $receiver, boolean value, Function0 block) {
            return $this.withMarkerGreedy($receiver, value, block);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

