/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\"J#\u0010#\u001a\u00020\"\"\f\b\u0000\u0010$*\u00060%j\u0002`&2\u0006\u0010'\u001a\u0002H$H&\u00a2\u0006\u0002\u0010(J(\u0010)\u001a\u00020\u0018\"\b\b\u0000\u0010**\u00020\u00002\u0006\u0010+\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H*0-H\u0002J\u001e\u0010.\u001a\u00020\u0018\"\b\b\u0000\u0010**\u00020\u00002\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H*0-J\b\u0010/\u001a\u000200H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/DocumentRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "()V", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "myMarkerInDocument", "Lcom/intellij/openapi/editor/RangeMarker;", "getMyMarkerInDocument", "()Lcom/intellij/openapi/editor/RangeMarker;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "rangeMarker", "getRangeMarker", "setRangeMarker", "(Lcom/intellij/openapi/editor/RangeMarker;)V", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getLineNumberInDocument", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getLineNumberInsideRegion", "getOffsetInDocument", "getOffsetInsideLine", "lineNumber", "insertIntoDocument", "offset", "removeFromDocument", "", "render", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "buffer", "(Ljava/lang/Appendable;)V", "replaceInternal", "T", "marker", "newRegions", "", "replaceWith", "toString", "", "intellij.cidr.debugger"})
public abstract class DocumentRegion
implements AddressSpace.Region {
    @Nullable
    private RangeMarker rangeMarker;

    @Override
    @NotNull
    public abstract AddressRange getRange();

    @Nullable
    public final RangeMarker getRangeMarker() {
        return this.rangeMarker;
    }

    public final void setRangeMarker(@Nullable RangeMarker rangeMarker) {
        this.rangeMarker = rangeMarker;
    }

    private final RangeMarker getMyMarkerInDocument() {
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Region has not been added to a document");
        }
        return rangeMarker;
    }

    @Nullable
    public final Document getDocument() {
        RangeMarker rangeMarker = this.rangeMarker;
        return rangeMarker != null ? rangeMarker.getDocument() : null;
    }

    @Nullable
    public final TextRange getTextRange() {
        TextRange textRange;
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker != null) {
            RangeMarker rangeMarker2;
            RangeMarker it = rangeMarker2 = rangeMarker;
            boolean bl = false;
            textRange = new TextRange(it.getStartOffset(), it.getEndOffset());
        } else {
            textRange = null;
        }
        return textRange;
    }

    public abstract int getLineNumberInsideRegion(@NotNull Address var1);

    public int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        return 0;
    }

    public abstract <A extends Appendable> void render(@NotNull A var1);

    public final int insertIntoDocument(@NotNull Document document2, int offset) {
        StringBuilder stringBuilder;
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker != null) {
            RangeMarker rangeMarker2;
            RangeMarker it = rangeMarker2 = rangeMarker;
            boolean bl = false;
            throw (Throwable)new IllegalStateException("Attempting to add an already added region at " + it);
        }
        StringBuilder it = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.render((Appendable)it);
        StringBuilder sb = stringBuilder;
        document2.insertString(offset, (CharSequence)sb);
        this.rangeMarker = document2.createRangeMarker(offset, offset + sb.length());
        return sb.length();
    }

    public final void removeFromDocument() {
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Attempting to remove a not yet added region");
        }
        RangeMarker marker = rangeMarker;
        marker.getDocument().deleteString(marker.getStartOffset(), marker.getEndOffset());
        marker.dispose();
        this.rangeMarker = null;
    }

    public final <T extends DocumentRegion> int replaceWith(@NotNull List<? extends T> newRegions) {
        int n;
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Attempting to replace a not yet added region");
        }
        RangeMarker marker = rangeMarker;
        int it = n = this.replaceInternal(marker, newRegions);
        boolean bl = false;
        if (this.rangeMarker == marker) {
            this.rangeMarker = null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends DocumentRegion> int replaceInternal(RangeMarker marker, List<? extends T> newRegions) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Document document2 = marker.getDocument();
        int startOffset = marker.getStartOffset();
        StringBuilder sb = new StringBuilder();
        Iterable iterable = $receiver$iv = (Iterable)newRegions;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void region;
            DocumentRegion documentRegion = (DocumentRegion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = sb;
            int n = startOffset;
            int n2 = startOffset + sb.length();
            StringBuilder it = stringBuilder;
            boolean bl2 = false;
            region.render((Appendable)it);
            StringBuilder stringBuilder2 = stringBuilder;
            int n3 = n + stringBuilder2.length();
            int n4 = n2;
            TextRange textRange = new TextRange(n4, n3);
            collection.add(textRange);
        }
        List ranges = (List)destination$iv$iv;
        document2.replaceString(startOffset, marker.getEndOffset(), (CharSequence)sb);
        marker.dispose();
        $receiver$iv = newRegions;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void region;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n5 = n;
            DocumentRegion bl = (DocumentRegion)item$iv;
            int i = n5;
            boolean bl3 = false;
            TextRange textRange = (TextRange)ranges.get(i);
            if (region.rangeMarker != null) {
                RangeMarker rangeMarker;
                RangeMarker it = rangeMarker;
                boolean bl4 = false;
                if (it != marker) {
                    throw (Throwable)new IllegalStateException("Attempting to add an already added region at " + region);
                }
            }
            region.rangeMarker = document2.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        }
        return startOffset + sb.length();
    }

    public final int getLineNumberInDocument(@NotNull Address address) {
        int n;
        RangeMarker marker = this.getMyMarkerInDocument();
        int regionLineNumber = marker.getDocument().getLineNumber(marker.getStartOffset());
        int lineNumber = !this.getRange().contains((Comparable)address) ? 0 : this.getLineNumberInsideRegion(address);
        int it = n = RangesKt.coerceIn((int)(regionLineNumber + lineNumber), (int)0, (int)(marker.getDocument().getLineCount() - 1));
        boolean bl = false;
        if (regionLineNumber + lineNumber != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + '+' + lineNumber + " is outside the document boundary " + it);
        }
        return n;
    }

    public final int getOffsetInDocument(@NotNull Address address) {
        RangeMarker marker = this.getMyMarkerInDocument();
        int lineNumber = this.getLineNumberInDocument(address);
        int offsetInLine = this.getOffsetInsideLine(address, lineNumber);
        return RangesKt.coerceIn((int)(marker.getDocument().getLineStartOffset(lineNumber) + offsetInLine), (int)0, (int)(marker.getDocument().getTextLength() - 1));
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(range=" + this.getRange() + ", myRangeMarker=" + this.rangeMarker + ')';
    }
}

