/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryAddressGutterProvider;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MemoryViewFileEditorProvider
implements FileEditorProvider {
    private final FileEditorProvider myDelegate = new PsiAwareTextEditorProvider();

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file) {
        return file instanceof MemoryViewFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file) {
        FileEditor fileEditor = this.myDelegate.createEditor(project2, file);
        if (fileEditor instanceof TextEditor && file instanceof MemoryViewFile) {
            this.setupMemoryViewEditor((TextEditor)fileEditor, (MemoryViewFile)file);
        }
        return fileEditor;
    }

    protected void setupMemoryViewEditor(@NotNull TextEditor fileEditor, @NotNull MemoryViewFile file) {
        CidrMemoryDoc<?> memoryDoc = file.getMemoryDoc();
        if (memoryDoc == null) {
            return;
        }
        Editor editor = fileEditor.getEditor();
        editor.getSettings().setGutterIconsShown(false);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getSettings().setLineNumbersShown(false);
        MemoryAddressGutterProvider gutterProvider = new MemoryAddressGutterProvider(memoryDoc);
        editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)gutterProvider, (EditorGutterAction)gutterProvider);
        ((EditorGutterComponentEx)editor.getGutter()).setCanCloseAnnotations(false);
    }

    @NotNull
    public String getEditorTypeId() {
        return "memory-view";
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file) {
        return this.myDelegate.readState(element, project2, file);
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        this.myDelegate.writeState(_state, project2, element);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

