/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.disasm.AbstractDisasmDataProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J$\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\u0014\u0010\u001d\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "nrHeaderLines", "", "getNrHeaderLines", "()I", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "getLineNumberInsideRegion", "address", "renderEntry", "", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "Companion", "intellij.cidr.debugger"})
public final class CidrDisasmRegion
extends DocRegion<LLInstruction> {
    public static final Companion Companion = new Companion(null);

    private final int getNrHeaderLines() {
        return CidrDisasmRegion.Companion.getFunctionOffset(this.getData()) != null ? 2 : (CollectionsKt.firstOrNull(this.getData().getEntries()) instanceof CidrMemoryData.DataEntry.Null ? 1 : 0);
    }

    @Override
    public void renderHeader(@NotNull Appendable buffer) {
        block0: {
            LLSymbolOffset lLSymbolOffset;
            LLSymbolOffset lLSymbolOffset2 = CidrDisasmRegion.Companion.getFunctionOffset(this.getData());
            if (lLSymbolOffset2 == null) break block0;
            LLSymbolOffset functionOffset = lLSymbolOffset = lLSymbolOffset2;
            boolean bl = false;
            buffer.append('\n');
            buffer.append(functionOffset + ":\n");
        }
    }

    @Override
    public void renderFooter(@NotNull Appendable buffer) {
        block0: {
            LLSymbolOffset lLSymbolOffset;
            LLSymbolOffset lLSymbolOffset2 = CidrDisasmRegion.Companion.getFunctionOffset(this.getData());
            if (lLSymbolOffset2 == null) break block0;
            LLSymbolOffset it = lLSymbolOffset = lLSymbolOffset2;
            boolean bl = false;
            buffer.append('\n');
        }
    }

    @Override
    public void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<LLInstruction> dataEntry) {
        LLInstruction lLInstruction = dataEntry.getValue();
        String string = lLInstruction != null ? lLInstruction.getDisassembly() : null;
        StringBuilder stringBuilder = new StringBuilder().append('\t');
        Appendable appendable = buffer;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        appendable.append(stringBuilder.append(StringsKt.replace$default((String)string3, (String)"\n", (String)"", (boolean)false, (int)4, null)).append('\n').toString());
    }

    @Override
    @Nullable
    public Address getAddressForLineNumberInsideRegion(int lineNumber) {
        if (this.getNrHeaderLines() > 0 && lineNumber == 0 || !(this.getData() instanceof AbstractDisasmDataProvider.DisasmBlock)) {
            return null;
        }
        int idx = RangesKt.coerceAtLeast((int)(lineNumber - this.getNrHeaderLines()), (int)0);
        if (idx >= ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().size()) {
            return null;
        }
        return ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().get(idx).getAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getLineNumberInsideRegion(@NotNull Address address) {
        int n;
        void $receiver$iv;
        Iterable iterable = this.getData().getEntries();
        int n2 = this.getNrHeaderLines();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                int n3;
                CidrMemoryData.DataEntry it = (CidrMemoryData.DataEntry)element$iv;
                boolean bl = false;
                if (!(it.getAddress().compareTo(address) < 0) || (n3 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_4;
        }
        int n4 = n;
        return n2 + n4;
    }

    public CidrDisasmRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<LLInstruction> dataRegion, @NotNull AddressSpace<DocRegion<LLInstruction>> reallocatedSpace) {
        super(document2, textRange, dataRegion, reallocatedSpace);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J@\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0012H\u0016R\"\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion$Companion;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "()V", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getFunctionOffset", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;)Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "intellij.cidr.debugger"})
    public static final class Companion
    implements CidrMemoryDoc.DocRegionFactory<LLInstruction> {
        @Override
        @NotNull
        public DocRegion<LLInstruction> createDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<LLInstruction> dataRegion, @NotNull AddressSpace<DocRegion<LLInstruction>> reallocatedSpace) {
            return new CidrDisasmRegion(document2, textRange, dataRegion, reallocatedSpace);
        }

        private final LLSymbolOffset getFunctionOffset(@NotNull CidrMemoryData.Data<LLInstruction> $receiver) {
            CidrMemoryData.Data<LLInstruction> data = $receiver;
            if (!(data instanceof AbstractDisasmDataProvider.DisasmBlock)) {
                data = null;
            }
            AbstractDisasmDataProvider.DisasmBlock disasmBlock = (AbstractDisasmDataProvider.DisasmBlock)data;
            return disasmBlock != null ? disasmBlock.getFunctionOffset() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

