/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.debugger.backend.BytesKt;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtilKt;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.AbstractHexdumpDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u001c\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0016J$\u0010\u001e\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060 j\u0002`!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020#H\u0016J\u0014\u0010$\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0016J\u0014\u0010%\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0016J+\u0010&\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010(R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "rangeMarkersToDispose", "", "Lcom/intellij/openapi/editor/RangeMarker;", "dispose", "", "deleteFromDocument", "", "doRenderSeamless", "oldRegion", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "", "getLineNumberInsideRegion", "address", "getOffsetInsideLine", "highlightChangedBytes", "markOutdated", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "renderSingleByte", "byte", "(Ljava/lang/Appendable;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Byte;)V", "Companion", "intellij.cidr.debugger"})
public final class CidrHexdumpRegion
extends DocRegion<Byte> {
    private final List<RangeMarker> rangeMarkersToDispose;
    private static final int WORD_BYTES = 4;
    private static final int LINE_BYTES = 16;
    public static final int PARAGRAPH_BYTES = 256;
    @NotNull
    public static final String WORD_SEPARATOR = "  ";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void doRenderSeamless(@NotNull DocRegion<?> oldRegion) {
        super.doRenderSeamless(oldRegion);
        this.highlightChangedBytes(oldRegion);
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightChangedBytes(DocRegion<?> oldRegion) {
        Editor[] $receiver$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Editor[] editorArray;
        DocRegion<?> docRegion = oldRegion;
        if (!(docRegion instanceof CidrHexdumpRegion)) {
            docRegion = null;
        }
        CidrHexdumpRegion cidrHexdumpRegion = (CidrHexdumpRegion)docRegion;
        CidrMemoryData.Data data = cidrHexdumpRegion != null ? cidrHexdumpRegion.getData() : null;
        if (!(data instanceof AbstractHexdumpDataProvider.ByteData)) {
            data = null;
        }
        AbstractHexdumpDataProvider.ByteData byteData = (AbstractHexdumpDataProvider.ByteData)data;
        if (byteData == null) {
            return;
        }
        AbstractHexdumpDataProvider.ByteData oldData = byteData;
        Editor[] it = editorArray = EditorFactory.getInstance().getEditors(this.getDocument());
        boolean $i$a$-also-CidrHexdumpRegion$highlightChangedBytes$editors$22 = false;
        Editor[] editorArray2 = it;
        if (editorArray2.length == 0) {
            return;
        }
        Editor[] editors = editorArray;
        Iterable $i$a$-also-CidrHexdumpRegion$highlightChangedBytes$editors$22 = $receiver$iv2 = (Iterable)CollectionsKt.zip(oldData.getEntries(), this.getData().getEntries());
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CidrMemoryData.DataEntry dataEntry;
            CidrMemoryData.DataEntry dataEntry2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            Pair $oldEntry_newEntry = (Pair)element$iv$iv;
            boolean bl = false;
            CidrMemoryData.DataEntry oldEntry = (CidrMemoryData.DataEntry)$oldEntry_newEntry.component1();
            CidrMemoryData.DataEntry newEntry = (CidrMemoryData.DataEntry)$oldEntry_newEntry.component2();
            boolean bl2 = Intrinsics.areEqual((Object)oldEntry.getAddress(), (Object)newEntry.getAddress());
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CidrMemoryData.DataEntry it2 = dataEntry2 = newEntry;
            boolean bl3 = false;
            Byte by = (Byte)newEntry.getValue();
            CidrMemoryData.DataEntry dataEntry3 = by == null || ((Number)oldEntry.getValue()).byteValue() != by.byteValue() ? dataEntry2 : null;
            if (dataEntry3 == null) continue;
            CidrMemoryData.DataEntry it$iv$iv = dataEntry = dataEntry3;
            destination$iv$iv.add(it$iv$iv);
        }
        List changedEntries = (List)destination$iv$iv;
        TextAttributes fgAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES.toTextAttributes();
        TextAttributes bgAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        Editor[] editorArray3 = $receiver$iv = editors;
        int n = editorArray3.length;
        for (int i = 0; i < n; ++i) {
            Editor element$iv;
            Editor editor = element$iv = editorArray3[i];
            boolean bl = false;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
            if (highlightManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
            }
            HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
            int hideFlags = 4;
            highlightManager2.hideHighlights(editor, hideFlags);
            Iterable $receiver$iv3 = changedEntries;
            for (Object element$iv2 : $receiver$iv3) {
                CidrMemoryData.DataEntry changedEntry = (CidrMemoryData.DataEntry)element$iv2;
                boolean bl4 = false;
                int offsetInDocument = this.getOffsetInDocument(changedEntry.getAddress());
                highlightManager2.addRangeHighlight(editor, offsetInDocument, offsetInDocument + 2, bgAttributes, true, null);
                highlightManager2.addOccurrenceHighlight(editor, offsetInDocument, offsetInDocument + 2, fgAttributes, hideFlags, null, null);
            }
        }
    }

    @Override
    public void markOutdated() {
        Editor[] $receiver$iv;
        TextAttributes commentAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
        TextAttributes fgAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.NO_HIGHLIGHTING).clone();
        fgAttributes.setForegroundColor(commentAttributes.getForegroundColor());
        fgAttributes.setBackgroundColor(commentAttributes.getBackgroundColor());
        Editor[] editorArray = $receiver$iv = EditorFactory.getInstance().getEditors(this.getDocument());
        int n = editorArray.length;
        for (int i = 0; i < n; ++i) {
            Editor element$iv;
            Editor editor = element$iv = editorArray[i];
            boolean bl = false;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
            if (highlightManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
            }
            HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
            int hideFlags = 4;
            highlightManager2.hideHighlights(editor, hideFlags);
            RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset(), 1000, fgAttributes, HighlighterTargetArea.EXACT_RANGE);
            Collection collection = this.rangeMarkersToDispose;
            collection.add(rangeHighlighter);
        }
    }

    @Override
    public void dispose(boolean deleteFromDocument) {
        super.dispose(deleteFromDocument);
        Iterable $receiver$iv = this.rangeMarkersToDispose;
        for (Object element$iv : $receiver$iv) {
            RangeMarker p1 = (RangeMarker)element$iv;
            boolean bl = false;
            p1.dispose();
        }
    }

    @Override
    public void renderHeader(@NotNull Appendable buffer) {
        Address start = this.getData().getRange().getStart();
        long missingStartBytesNumber = AddressUtilKt.reminder(start, 16);
        AddressRange missingStartRange = start.minus(missingStartBytesNumber).until(start);
        for (Address address : missingStartRange) {
            this.renderSingleByte(buffer, address, null);
        }
    }

    @Override
    public void renderFooter(@NotNull Appendable buffer) {
        Address endInclusive = this.getData().getRange().getEndInclusive();
        long missingEndBytesNumber = (long)16 - AddressUtilKt.reminder(endInclusive, 16) - 1L;
        AddressRange missingEndRange = endInclusive.plus(1).until(endInclusive.plus(1).plus(missingEndBytesNumber));
        for (Address address : missingEndRange) {
            this.renderSingleByte(buffer, address, null);
        }
    }

    @Override
    public void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<Byte> dataEntry) {
        this.renderSingleByte(buffer, dataEntry.getAddress(), dataEntry.getValue());
    }

    private final void renderSingleByte(Appendable buffer, Address address, Byte by) {
        boolean bl;
        Object object = by;
        if (object == null || (object = BytesKt.toUnsignedHexString((Byte)object)) == null) {
            object = WORD_SEPARATOR;
        }
        Object byteString = object;
        boolean bl2 = bl = ((String)byteString).length() == 2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = '\'' + (String)byteString + "' must be a zero-padded unsigned byte";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Companion.isAlignedTo(address, 256)) {
            buffer.append('\n');
        }
        if (Companion.isAlignedTo(address, 4)) {
            buffer.append(WORD_SEPARATOR);
        }
        buffer.append((CharSequence)byteString);
        if (Companion.isAlignedTo(address.plus(1), 16)) {
            buffer.append('\n');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Address getAddressForLineNumberInsideRegion(int lineNumber) {
        void start;
        if (lineNumber == 0) {
            return null;
        }
        AddressRange addressRange = this.getRange();
        Address address = addressRange.component1();
        Address endInclusive = addressRange.component2();
        Address alignedStart = start.minus(AddressUtilKt.reminder((Address)start, 16));
        Address alignedEndInclusive = endInclusive.minus(AddressUtilKt.reminder(endInclusive, 16)).plus(16).minus(1);
        Address address2 = alignedStart.plus((lineNumber - 1) * 16);
        return address2.compareTo(alignedEndInclusive) <= 0 ? address2 : null;
    }

    @Override
    public int getLineNumberInsideRegion(@NotNull Address address) {
        return CidrHexdumpRegion.Companion.lineOf((int)address.minus(this.getRange().getStart())) + 1;
    }

    @Override
    public int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        boolean bl;
        StringBuilder buffer = new StringBuilder();
        Address lineStartAddress = AddressUtilKt.roundDown(address, (Number)16);
        Object object = lineStartAddress.rangeTo(address).iterator();
        while (object.hasNext()) {
            Address eachAddress = object.next();
            this.renderSingleByte(buffer, eachAddress, null);
        }
        Object it = object = StringsKt.trim((CharSequence)buffer, (char[])new char[]{'\n'});
        boolean bl2 = false;
        boolean bl3 = bl = !StringsKt.contains$default((CharSequence)it, (char)'\n', (boolean)false, (int)2, null);
        if (!bl) {
            boolean bl4 = false;
            String string = "Unexpected line break inside a line: '" + (CharSequence)it + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object line = object;
        return RangesKt.coerceAtLeast((int)(line.length() - 2), (int)0);
    }

    public CidrHexdumpRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<Byte> dataRegion, @NotNull AddressSpace<DocRegion<Byte>> reallocatedSpace) {
        super(document2, textRange, dataRegion, reallocatedSpace);
        List list;
        CidrHexdumpRegion cidrHexdumpRegion = this;
        cidrHexdumpRegion.rangeMarkersToDispose = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J@\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion$Companion;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "", "()V", "LINE_BYTES", "", "PARAGRAPH_BYTES", "WORD_BYTES", "WORD_SEPARATOR", "", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "lineOf", "offset", "isAlignedTo", "", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "n", "intellij.cidr.debugger"})
    public static final class Companion
    implements CidrMemoryDoc.DocRegionFactory<Byte> {
        @Override
        @NotNull
        public DocRegion<Byte> createDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<Byte> dataRegion, @NotNull AddressSpace<DocRegion<Byte>> reallocatedSpace) {
            return new CidrHexdumpRegion(document2, textRange, dataRegion, reallocatedSpace);
        }

        public final boolean isAlignedTo(@NotNull Address $receiver, int n) {
            return $receiver.getUnsignedLongValue() % (long)n == 0L;
        }

        private final int lineOf(int offset) {
            return offset / 16;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

