/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBeforeTestRunTaskProvider
extends BeforeRunTaskProvider {
    private static final String BEFORE_TEST_ID = "BeforeTestRunTask";
    public static final Key<BeforeTestRunTask> ID = Key.create((String)"BeforeTestRunTask");
    public static final Key<Content> CONTENT = Key.create((String)"Content");
    public static final Key<ProgressIndicator> PROGRESS = Key.create((String)"ProgressIndicator");

    public Key<BeforeTestRunTask> getId() {
        return ID;
    }

    public String getName() {
        return CidrBundle.message("test.before.run", new Object[0]);
    }

    public String getDescription(BeforeRunTask task) {
        return CidrBundle.message("test.before.run", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return new LayeredIcon(new Icon[]{AllIcons.RunConfigurations.TestState.Run, AllIcons.RunConfigurations.TestMark});
    }

    public boolean isSingleton() {
        return true;
    }

    public BeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (!this.configurationNeedBeforeTestRunTask(runConfiguration)) {
            return null;
        }
        return new BeforeTestRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull BeforeRunTask task) {
        return this.configurationNeedBeforeTestRunTask(configuration);
    }

    protected boolean configurationNeedBeforeTestRunTask(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof CidrTestRunConfiguration && ((CidrTestRunConfiguration)runConfiguration).getTestData() instanceof CidrTestConfigurationNeedBeforeRunTask;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull BeforeRunTask task) {
        try {
            CidrTestCommandLineState state = (CidrTestCommandLineState)Objects.requireNonNull(env.getState());
            BackgroundableProcessIndicator progress = this.createProgress(configuration);
            ProgressManager.getInstance().runProcess(() -> state.prepareTestExecutionEnvironment((ProgressIndicator)progress), (ProgressIndicator)progress);
            return !progress.isCanceled();
        }
        catch (ExecutionException | RuntimeException e) {
            CidrTestLog.LOG.error(e);
            return false;
        }
    }

    @NotNull
    private BackgroundableProcessIndicator createProgress(final @NotNull RunConfiguration configuration) {
        return (BackgroundableProcessIndicator)UIUtil.invokeAndWaitIfNeeded(() -> {
            Project project2 = configuration.getProject();
            final Content content = this.getContent(project2);
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(project2, new TaskInfo(){

                @NotNull
                public String getTitle() {
                    return CidrBundle.message("test.before.run.progress.title", configuration.getName());
                }

                public String getCancelText() {
                    return CidrBundle.message("test.stop.run", new Object[0]);
                }

                public String getCancelTooltipText() {
                    return CidrBundle.message("test.stop.run.description", new Object[0]);
                }

                public boolean isCancellable() {
                    return true;
                }
            }, PerformInBackgroundOption.ALWAYS_BACKGROUND){
                boolean first;
                {
                    super(x0, x1, x2);
                    this.first = true;
                }

                public synchronized void start() {
                    super.start();
                    this.setText(CidrBundle.message("test.before.run.progress.text", new Object[0]));
                    this.setText2(this.getTitle());
                }

                public synchronized void stop() {
                    this.setText2(CidrBundle.message(this.isCanceled() ? "test.before.run.canceled" : "test.before.run.finished", new Object[0]));
                    PROGRESS.set((UserDataHolder)content, null);
                    super.stop();
                }

                public void setText2(String text) {
                    ConsoleViewImpl component;
                    super.setText2(text);
                    ConsoleViewImpl consoleViewImpl = component = content == null ? null : (ConsoleViewImpl)content.getComponent();
                    if (component != null) {
                        String message;
                        if (this.first) {
                            this.first = false;
                            message = text;
                        } else {
                            message = "\n" + text;
                        }
                        ConsoleViewContentType output = text.startsWith("Warning:") || text.startsWith("Error:") ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
                        component.print(message, output);
                    }
                }
            };
            CONTENT.set((UserDataHolder)indicator, (Object)content);
            PROGRESS.set((UserDataHolder)content, (Object)indicator);
            return indicator;
        });
    }

    @Nullable
    private Content getContent(final @NotNull Project project2) throws RuntimeException {
        return (Content)ApplicationManager.getApplication().runWriteAction(() -> {
            ConsoleViewImpl component;
            MessageView.SERVICE.getInstance((Project)project2);
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
            ToolWindow window = manager.getToolWindow(ToolWindowId.MESSAGES_WINDOW);
            if (window == null) {
                return null;
            }
            String displayName2 = this.getName();
            final ContentManager contentManager = window.getContentManager();
            Content content = contentManager.findContent(displayName2);
            if (content == null) {
                ConsoleViewImpl console = (ConsoleViewImpl)TextConsoleBuilderFactory.getInstance().createBuilder(project2, GlobalSearchScope.EMPTY_SCOPE).getConsole();
                JComponent component2 = console.getComponent();
                DefaultActionGroup toolbarActions = new DefaultActionGroup();
                component2.add((Component)ActionManager.getInstance().createActionToolbar("Run", (ActionGroup)toolbarActions, false).getComponent(), "West");
                content = contentManager.getFactory().createContent(component2, displayName2, true);
                contentManager.addContent(content);
                Disposer.register((Disposable)content, (Disposable)console);
                toolbarActions.add((AnAction)new StopAction(content));
                toolbarActions.addSeparator();
                toolbarActions.addAll(console.createConsoleActions());
                final Content fcontent = content;
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        contentManager.removeContentManagerListener((ContentManagerListener)this);
                    }

                    public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)fcontent);
                        if (indicator != null && indicator.isRunning()) {
                            int result = Messages.showYesNoDialog((Project)project2, (String)CidrBundle.message("test.before.run.cancelQuestion", new Object[0]), (String)CidrBundle.message("test.before.run.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                            if (result == 0) {
                                PROGRESS.set((UserDataHolder)fcontent, null);
                                indicator.cancel();
                            } else {
                                event.consume();
                            }
                        }
                    }
                });
            }
            if (!window.isAvailable()) {
                window.setAvailable(true, null);
            }
            if (!window.isActive()) {
                window.activate(null);
            }
            if ((component = (ConsoleViewImpl)content.getComponent()) != null) {
                component.clear();
            }
            contentManager.setSelectedContent(content);
            return content;
        });
    }

    public static interface CidrTestConfigurationNeedBeforeRunTask {
    }

    public static interface CidrBeforeRunTaskConverter
    extends RunConfigurationConverter {
        public String getId();

        default public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
            if (!this.getId().equals(element.getAttributeValue("type"))) {
                return false;
            }
            Element method = element.getChild("method");
            if (method != null && method.getAttributeValue("v") != null && method.getChildren("option").stream().noneMatch(option -> CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID.equals(option.getAttributeValue("name")))) {
                Element option2 = new Element("option");
                option2.setAttribute("name", CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID);
                option2.setAttribute("enabled", Boolean.TRUE.toString());
                method.addContent(option2);
                return true;
            }
            return false;
        }
    }

    private static class BeforeTestRunTask
    extends BeforeRunTask<BeforeTestRunTask> {
        private BeforeTestRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }

    private static class StopAction
    extends DumbAwareAction {
        @NotNull
        private final Content myContent;

        private StopAction(@NotNull Content content) {
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
            this.myContent = content;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent);
            if (indicator != null) {
                indicator.cancel();
            }
        }

        public void update(@NotNull AnActionEvent event) {
            ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent);
            event.getPresentation().setEnabled(indicator != null && indicator.isRunning());
        }
    }
}

