/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrFromTagInLineToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    protected final CidrTestEventProcessor myEventProcessor;
    protected volatile String myProcessFinishedMessage;
    protected volatile String myFinalTestReport;
    protected final ExecutionConsole myConsole;
    protected final Stack<String> myTestNameStack = new Stack();
    protected final Stack<TestResult> myTestResultStack = new Stack();
    protected static final String ROOT_NODE_ID = "0";
    protected volatile ServiceMessageVisitor myVisitor;

    public CidrFromTagInLineToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull CidrTestEventProcessor processor2, @NotNull ExecutionConsole console) {
        super(testFrameworkName, consoleProperties);
        this.myEventProcessor = processor2;
        this.myConsole = console;
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@Nullable String text, @Nullable Key outputType, @NotNull ServiceMessageVisitor visitor) {
        CidrOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.myVisitor = visitor;
        if (outputType != null && (ProcessOutputType.isStdout((Key)outputType) || ProcessOutputType.isStderr((Key)outputType))) {
            this.processLine(outputType, text);
            return true;
        }
        if (text != null) {
            if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
                this.myProcessFinishedMessage = text;
                return true;
            }
            if (text.equals("\n")) {
                return true;
            }
        }
        return false;
    }

    protected abstract void processLine(Key var1, String var2);

    @NotNull
    protected String getCurrentNodeId() {
        StringBuilder path = new StringBuilder();
        path.append(ROOT_NODE_ID);
        this.myTestNameStack.forEach(testName -> path.append('/').append((String)testName));
        return path.toString();
    }

    protected String getLocationFromId() {
        String nodeId = this.getCurrentNodeId();
        return nodeId.equals(ROOT_NODE_ID) ? "" : nodeId.substring(ROOT_NODE_ID.length() + 1);
    }

    public static long getTimeInMs(@Nullable String timeStringWithSuffix) {
        if (timeStringWithSuffix != null) {
            try {
                int length = timeStringWithSuffix.length();
                long parseLong = Long.parseLong(timeStringWithSuffix.substring(0, length - 2).trim());
                if (timeStringWithSuffix.endsWith("us")) {
                    return Math.round((double)parseLong / 1000.0);
                }
                if (timeStringWithSuffix.endsWith("ms")) {
                    return parseLong;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void flushBufferOnProcessTermination(int exitCode) {
        GeneralTestEventsProcessor processor2 = this.getProcessor();
        if (processor2 != null) {
            if (this.myFinalTestReport != null) {
                processor2.onUncapturedOutput(this.myFinalTestReport, ProcessOutputTypes.STDERR);
            }
            if (this.myProcessFinishedMessage != null) {
                processor2.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    protected void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    protected static class TestResult {
        public boolean success = true;
        public int durationInMs = 0;

        private TestResult() {
        }

        public void update(boolean succeed, long durationInMs) {
            this.success &= succeed;
            this.durationInMs = (int)((long)this.durationInMs + durationInMs);
        }

        public static TestResult create(boolean success, int durationInMs) {
            TestResult result = new TestResult();
            result.success = success;
            result.durationInMs = durationInMs;
            return result;
        }
    }

    protected static class TagWithAttr<TAG> {
        private final Map<Attr, String> myAttrs;
        private final TAG myTag;

        public TagWithAttr(@NotNull TAG tag, @NotNull Map<Attr, String> attrs) {
            this.myAttrs = attrs;
            this.myTag = tag;
        }

        @Nullable
        public String getAttr(Attr attrId) {
            return this.myAttrs.get((Object)attrId);
        }

        @NotNull
        public TAG getTag() {
            return this.myTag;
        }
    }

    public static enum Attr {
        SOURCE_PATH,
        LINE_NUM,
        NAME,
        MESSAGE,
        TIME,
        SUCCEEDED;

    }
}

