/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrLauncher {
    public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
        return this.createProcess(state);
    }

    protected abstract ProcessHandler createProcess(@NotNull CommandLineState var1) throws ExecutionException;

    @NotNull
    public CidrDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        CidrDebugProcess result = this.createDebugProcess(state, session);
        ((XDebugSessionImpl)session).addRestartActions(this.getAdditionalActions(state, result.getProcessHandler(), (ExecutionConsole)result.getConsole()));
        result.start();
        return result;
    }

    @NotNull
    protected abstract CidrDebugProcess createDebugProcess(@NotNull CommandLineState var1, @NotNull XDebugSession var2) throws ExecutionException;

    protected static void configProcessHandler(@NotNull ProcessHandler handler, boolean detachSupported, boolean reportExitCode, @NotNull Project project2) throws ExecutionException {
        if (!detachSupported) {
            handler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        }
        if (reportExitCode) {
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)project2);
        }
    }

    @NotNull
    protected abstract Project getProject();

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult executionResult) throws ExecutionException {
        executionResult.setRestartActions(this.getAdditionalActions(state, executionResult.getProcessHandler(), executionResult.getExecutionConsole()));
    }

    @NotNull
    private AnAction[] getAdditionalActions(@NotNull CommandLineState state, ProcessHandler handler, ExecutionConsole console) throws ExecutionException {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.collectAdditionalActions(state, handler, console, actions);
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<AnAction> actions) throws ExecutionException {
        if (state instanceof CidrTestCommandLineState) {
            actions.add((AnAction)((CidrTestCommandLineState)state).createRerunFailedTestsAction(console));
        }
    }
}

