/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestEventProcessor {
    @NotNull
    private String myLocationProtocol;

    public CidrTestEventProcessor(@NotNull String locationProtocol) {
        this.myLocationProtocol = locationProtocol;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name2, @NotNull String location) {
        return this.suiteStarted(name2, null, null, location, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name2, @Nullable String parentId, @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        return this.doSuiteStarted(name2, parentId, nodeId, location, metainfo);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doSuiteStarted(@NotNull String name2, @Nullable String parentId, @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        return Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testSuiteStarted((String)name2))))));
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NotNull String name2) {
        return this.suiteFinished(name2, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NotNull String name2, @Nullable String nodeId) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testSuiteFinished((String)name2)));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NotNull String testName, @NotNull String location) {
        return this.testStarted(testName, null, null, location, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NotNull String testName, @Nullable String parentId, @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        return this.doTestStarted(testName, parentId, nodeId, location, metainfo);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestStarted(@NotNull String testName, @Nullable String parentId, @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        return Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testStarted((String)testName))))));
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NotNull String testName, @NotNull String duration, boolean success) {
        return this.testFinished(testName, null, duration, success);
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NotNull String testName, @Nullable String nodeId, @NotNull String duration, boolean success) {
        return this.doTestFinished(testName, nodeId, duration, success, false);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestFinished(@NotNull String testName, @Nullable String nodeId, @NotNull String duration, boolean success, boolean ignored) {
        ServiceMessageBuilder statusMessage = null;
        if (!success) {
            statusMessage = ServiceMessageBuilder.testFailed((String)testName);
        } else if (ignored) {
            statusMessage = ServiceMessageBuilder.testIgnored((String)testName);
        }
        ServiceMessageBuilder finishMessage = CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setDuration(duration, ServiceMessageBuilder.testFinished((String)testName)));
        if (statusMessage == null) {
            return Collections.singletonList(finishMessage);
        }
        CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setMessage("", statusMessage));
        return Arrays.asList(statusMessage, finishMessage);
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NotNull String testName, @NotNull String output) {
        return this.testErrOut(testName, null, output);
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NotNull String testName, @Nullable String nodeId, @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdErr((String)testName).addAttribute("out", output)));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStdOut(@NotNull String testName, @Nullable String nodeId, @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdOut((String)testName).addAttribute("out", output)));
    }

    @NotNull
    private ServiceMessageBuilder setLocation(@Nullable String location, @NotNull ServiceMessageBuilder builder) {
        if (location == null) {
            return builder;
        }
        return builder.addAttribute("locationHint", this.myLocationProtocol + "://" + location);
    }

    @NotNull
    private static ServiceMessageBuilder setMetainfo(@Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("metainfo", nodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setNodeId(@Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("nodeId", nodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setParentNodeId(@Nullable String parentNodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("parentNodeId", parentNodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setMessage(@Nullable String message, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("message", message, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setDuration(@Nullable String duration, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("duration", duration, builder);
    }

    private static ServiceMessageBuilder addParamIfNeed(@NotNull String attrName, @Nullable String value, @NotNull ServiceMessageBuilder builder) {
        if (value == null) {
            return builder;
        }
        return builder.addAttribute(attrName, value);
    }

    @Nullable
    public Matcher hideOutputMatcher(@NotNull String text) {
        return null;
    }
}

