/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_FRAMEWORK extends CidrTestFrameworkBase<TEST_OBJECT>, TEST_OBJECT>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    protected CidrTestRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(binder);
    }

    @Deprecated
    protected CidrTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(configurationType, binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<TEST_OBJECT> objects = this.findTestObjects(context);
        if (objects.isEmpty()) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope((TEST_OBJECT)objects);
        if (scope == null) {
            return false;
        }
        TEST_OBJECT testObj = objects.get(0);
        this.setupTarget(configuration, this.getTargetsForFile(this.getElement(testObj).getContainingFile(), target -> this.isTestTarget(target)));
        this.setupConfiguration(configuration, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    @NotNull
    protected abstract PsiElement getElement(@NotNull TEST_OBJECT var1);

    protected abstract boolean isTestTarget(@NotNull TARGET var1);

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull List<TEST_OBJECT> objects) {
        return this.foldScope(ContainerUtil.mapNotNull(objects, e -> this.containingFileCanUseFramework(this.getElement(e)) ? this.determineScope(e) : null));
    }

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull ConfigurationContext context) {
        return this.determineScope((TEST_OBJECT)this.findTestObjects(context));
    }

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull TEST_OBJECT var1);

    @NotNull
    protected List<TEST_OBJECT> findTestObjects(@NotNull ConfigurationContext context) {
        return ContainerUtil.mapNotNull(this.getLocations(context), e -> this.containingFileCanUseFramework(e.getPsiElement()) ? this.findTestObject((Location)e) : null);
    }

    @Nullable
    protected TEST_OBJECT findTestObject(@NotNull Location location) {
        return ((CidrTestFrameworkBase)this.getTestFramework()).findTestObject(location.getPsiElement());
    }

    public boolean isConfigurationFromContext(CONFIGURATION configuration, ConfigurationContext context) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope(context);
        if (scope == null) {
            return false;
        }
        return delegate.equalTo(scope);
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration, CidrTestScopeElement scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return;
        }
        if (scope.isPatternLike()) {
            delegate.setSuiteName(null);
            delegate.setTestName(null);
            delegate.setTestPattern(scope.getPattern());
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        } else {
            delegate.setSuiteName(scope.getSuiteName());
            delegate.setTestName(scope.getTestName());
            delegate.setTestPattern(null);
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        }
        String configurationName = scope.getConfigurationName();
        configuration.setName(configurationName == null ? delegate.suggestedName(((CidrRunConfiguration)configuration).suggestNameForTarget()) : configurationName);
    }

    @NotNull
    protected List<Location> getLocations(@NotNull ConfigurationContext context) {
        Object[] psiElements;
        Object[] paths;
        SMTRunnerTestTreeView treeView = (SMTRunnerTestTreeView)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext());
        if (treeView != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(context.getProject());
            return ContainerUtil.mapNotNull((Object[])paths, path -> {
                if (treeView.isPathSelected(path.getParentPath())) {
                    return null;
                }
                SMTestProxy test = treeView.getSelectedTest(path);
                return test == null ? null : test.getLocation(context.getProject(), scope);
            });
        }
        if (context.containsMultipleSelection() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())) != null) {
            return ContainerUtil.mapNotNull((Object[])psiElements, e -> new PsiLocation(context.getProject(), e));
        }
        Location location = context.getLocation();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(location);
    }

    @Nullable
    protected CidrTestScopeElement foldScope(@NotNull List<CidrTestScopeElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, scope -> {
            firstName.setIfNull((Object)scope.getConfigurationName());
            return scope.getPattern();
        });
        if (res.isEmpty()) {
            return null;
        }
        String name2 = (String)firstName.get();
        if (res.size() > 1) {
            name2 = name2 + String.format(" and %d more", res.size() - 1);
        }
        return CidrTestScopeElementImpl.createTestScopeWithPatternAndConfigurationName(name2, StringUtil.join(new LinkedHashSet(res), (String)((CidrTestFrameworkBase)this.getTestFramework()).getPatternSeparatorInCommandLine()));
    }

    @Contract(pure=true)
    protected boolean containingFileCanUseFramework(@NotNull PsiElement context) {
        return ((CidrTestFrameworkBase)this.getTestFramework()).isAvailable(context.getContainingFile());
    }

    @NotNull
    protected abstract TEST_FRAMEWORK getTestFramework();
}

