/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CidrTestScope {
    public static final String ALL_IN_FILE_PREFIX = "all-tests(";
    public static final String ALL_IN_FILE_SUF = ")";
    private final String mySeparator;
    private List<CidrTestScopeElement> myElements;
    private String myPreRenderedScope;

    private CidrTestScope(@NotNull String separator) {
        this.mySeparator = separator;
    }

    @NotNull
    public List<CidrTestScopeElement> getElements() {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        return Collections.unmodifiableList(this.myElements.stream().sorted().distinct().collect(Collectors.toList()));
    }

    @NotNull
    public static CidrTestScope createEmptyTestScope(@NotNull String separator) {
        return new CidrTestScope(separator);
    }

    @NotNull
    public CidrTestScope configureForPreRenderedScope(@NotNull String switches) {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null && (this.myElements == null || this.myElements.isEmpty()));
        this.myPreRenderedScope = switches;
        return this;
    }

    @NotNull
    public CidrTestScope addScopeElement(@NotNull CidrTestScopeElement element) {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        this.myElements.add(element);
        return this;
    }

    @NotNull
    public CidrTestScope addPattern(@NotNull String pattern) {
        CidrTestLog.LOG.assertTrue(this.myElements == null || this.myElements.isEmpty());
        this.myPreRenderedScope = this.myPreRenderedScope == null ? pattern : this.myPreRenderedScope + this.mySeparator + pattern;
        return this;
    }

    @NotNull
    public String toString() {
        return this.getAsPattern();
    }

    @NotNull
    public String getAsPattern() {
        return this.myPreRenderedScope != null ? this.myPreRenderedScope : StringUtil.join(this.getAsPatternList(), (String)this.mySeparator);
    }

    @NotNull
    public List<String> getAsPatternList() {
        if (this.myPreRenderedScope != null) {
            if (this.myPreRenderedScope.contains(ALL_IN_FILE_PREFIX)) {
                ArrayList<String> split = new ArrayList<String>();
                int pos = 0;
                while (pos < this.myPreRenderedScope.length()) {
                    int spos;
                    String prefix = "";
                    if (StringUtil.startsWith((CharSequence)this.myPreRenderedScope, (int)pos, (CharSequence)ALL_IN_FILE_PREFIX)) {
                        int end = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)ALL_IN_FILE_SUF, (int)pos);
                        int npos = end + ALL_IN_FILE_SUF.length();
                        prefix = this.myPreRenderedScope.substring(pos, npos);
                        pos = npos;
                    }
                    if ((spos = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)this.mySeparator, (int)pos)) < 0) {
                        split.add(prefix + this.myPreRenderedScope.substring(pos));
                        break;
                    }
                    split.add(prefix + this.myPreRenderedScope.substring(pos, spos));
                    pos = spos + this.mySeparator.length();
                }
                return split;
            }
            return StringUtil.split((String)this.myPreRenderedScope, (String)this.mySeparator);
        }
        this.createElementCollectionIfNull();
        return this.myElements.stream().sorted(Comparator.comparingLong(CidrTestScopeElement::getSortIndex)).distinct().map(scope -> scope.getPattern()).collect(Collectors.toList());
    }

    @NotNull
    public static String getAsPatternForCommandLine(@NotNull Project project2, @NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull CidrTestScope testScope, final @NotNull ProgressIndicator progress) {
        String pattern = testScope.getAsPattern();
        if (!pattern.contains(ALL_IN_FILE_PREFIX)) {
            return pattern;
        }
        CidrTestLog.LOG.assertTrue(OCTestFrameworks.canWaitInThisThread());
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        CidrTestScope finalFileScope = emptyTestScopeProducer.get();
        block2: for (String _pattern : testScope.getAsPatternList()) {
            if (!(_pattern = _pattern.trim()).startsWith(ALL_IN_FILE_PREFIX) || !_pattern.endsWith(ALL_IN_FILE_SUF)) continue;
            String fileId = _pattern.substring(ALL_IN_FILE_PREFIX.length(), _pattern.length() - ALL_IN_FILE_SUF.length());
            VirtualFile vfile = virtualFileManager.findFileByUrl(fileId);
            if (vfile == null) {
                progress.setText2("Warning: File not found in FS: " + fileId);
                continue;
            }
            boolean first = true;
            while (!progress.isCanceled()) {
                if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
                    if (first) {
                        first = false;
                        progress.setText2("Waiting for symbols loading...");
                    }
                } else if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    PsiFile pfile = psiManager.findFile(vfile);
                    if (pfile == null) {
                        progress.setText2("Warning: File not found in project: " + fileId);
                        return;
                    }
                    progress.setText2("Processing file: " + vfile.getPath() + "...");
                    finalFileScope.addPattern(CidrTestScope.createFilePatternAsTestList(framework, emptyTestScopeProducer, pfile, CidrTestScopeElement::isTest));
                }, (ProgressIndicator)new AbstractProgressIndicatorBase(){

                    public boolean isCanceled() {
                        return super.isCanceled() || progress.isCanceled();
                    }
                })) continue block2;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!progress.isCanceled()) {
            String finalFileScopeAsPattern = finalFileScope.getAsPattern();
            progress.setText2("Pattern to run: " + finalFileScopeAsPattern);
            return finalFileScopeAsPattern;
        }
        return "";
    }

    @NotNull
    public static String createFilePattern(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull PsiFile file, @NotNull Predicate<CidrTestScopeElement> filter) {
        return CidrTestScope.filePatternAsRef() ? CidrTestScope.createFilePatternAsRef(framework, file) : CidrTestScope.createFilePatternAsTestList(framework, emptyTestScopeProducer, file, filter);
    }

    public static boolean filePatternAsRef() {
        return Registry.is((String)"cidr.test.framework.filePatternAsRef") && !PlatformUtils.isAppCode();
    }

    @NotNull
    public static String createFilePatternAsRef(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull PsiFile file) {
        framework.updateTestsListOrScheduleUpdateIfCannotWait(file);
        return ALL_IN_FILE_PREFIX + file.getVirtualFile().getUrl() + ALL_IN_FILE_SUF;
    }

    @NotNull
    public static String createFilePatternAsTestList(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull PsiFile file, @NotNull Predicate<CidrTestScopeElement> filter) {
        CidrTestScope fileScope = emptyTestScopeProducer.get();
        for (CidrTestScopeElement cidrTestScopeElement : framework.getTestObjects(file).values()) {
            if (!filter.test(cidrTestScopeElement)) continue;
            fileScope.addScopeElement(cidrTestScopeElement);
        }
        return fileScope.getAsPattern();
    }

    private void createElementCollectionIfNull() {
        if (this.myElements == null) {
            this.myElements = new ArrayList<CidrTestScopeElement>();
        }
    }
}

