/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SofterReference;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestScopeElementImpl
implements CidrTestScopeElement,
Comparable<CidrTestScopeElement> {
    @Nullable
    protected final String mySuiteName;
    @Nullable
    protected final String myTestName;
    @Nullable
    protected final AbstractPropertiesGenerator myDelegate;
    public static final long DEFAULT_TEST_ORDER = -1L;

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName) {
        this(suiteName, testName, (Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator>)((Function)self -> new DefaultPropertiesGenerator((CidrTestScopeElementImpl)self)));
    }

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        this.mySuiteName = StringUtil.nullize((String)suiteName, (boolean)true);
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
        this.myDelegate = factory == null ? null : (AbstractPropertiesGenerator)factory.fun((Object)this);
    }

    public CidrTestScopeElementImpl() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String getSuiteName() {
        return this.mySuiteName;
    }

    @Override
    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    @Override
    public boolean isTest() {
        this.checkDelegateNotNull();
        return this.myDelegate.isTest();
    }

    @Override
    public boolean isPatternLike() {
        this.checkDelegateNotNull();
        return this.myDelegate.isPatternLike();
    }

    public boolean isVirtualPathHolder() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        CidrTestScopeElementImpl.throwNotDefined();
        return null;
    }

    @Override
    @Nullable
    public String getId() {
        CidrTestScopeElementImpl.throwNotDefined();
        return null;
    }

    @Override
    public long getSortIndex() {
        return -1L;
    }

    @Contract(value=" -> fail")
    private static void throwNotDefined() {
        throw new RuntimeException("Not defined");
    }

    @Override
    @NotNull
    public String getTestPath() {
        if (this.isVirtualPathHolder()) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
        this.checkDelegateNotNull();
        return this.myDelegate.getTestPath();
    }

    @Override
    @NotNull
    public String getPattern() {
        this.checkDelegateNotNull();
        return this.myDelegate.getPattern();
    }

    @Override
    @Nullable
    public String getConfigurationName() {
        this.checkDelegateNotNull();
        return this.myDelegate.getConfigurationName();
    }

    private void checkDelegateNotNull() {
        if (this.myDelegate == null) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
    }

    @NotNull
    public String toString() {
        return this.getPattern();
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CidrTestScopeElement)) {
            return false;
        }
        return this.getPattern().equals(((CidrTestScopeElement)o).getPattern());
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    @Override
    public int compareTo(CidrTestScopeElement o) {
        return StringUtil.compare((String)this.getPattern(), (String)o.getPattern(), (boolean)false);
    }

    @NotNull
    public static String createPathFromParts(Collection<String> suites) {
        return CidrTestScopeElementImpl.createPathFromParts(ArrayUtil.toStringArray(suites));
    }

    @NotNull
    public static String createPathFromParts(String ... suites) {
        StringBuilder path = new StringBuilder();
        for (String suite : suites) {
            if (path.length() != 0) {
                path.append('/');
            }
            path.append(suite);
        }
        return path.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitPath(@NotNull String pathWithoutProtocolPrefix) {
        return StringUtil.split((String)pathWithoutProtocolPrefix, (String)SEPARATOR);
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForFile(final @NotNull PsiFile file, final @NotNull Supplier<String> patternForFile) {
        return new CidrTestScopeElementImpl(){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                return CidrBundle.message("test.defaultName.allTestsIn", file.getName());
            }

            @Override
            @NotNull
            public String getPattern() {
                return StringUtil.notNullize((String)((String)patternForFile.get()));
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                return file;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
        return new CidrTestScopeElementImpl(suiteName, testName, generator);
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForVirtualTestPath(final @NotNull String virtualTestPath, final @NotNull String configurationName, final @NotNull CidrTestScopeElement realElement, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        return new CidrTestScopeElementImpl(null, null, factory){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                return configurationName;
            }

            @Override
            @NotNull
            public String getTestPath() {
                return virtualTestPath;
            }

            @Override
            public boolean isVirtualPathHolder() {
                return true;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                return realElement.getElement();
            }
        };
    }

    @NotNull
    @Contract(value="_ -> new")
    public static CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> getTestSerializer(Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
        return new CidrTestWithScopeElementsSerializer(generator);
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForCaching(final @Nullable String testName, final @Nullable String suiteName, final long offsetAsNaturalOrder, final @Nullable String uniqueTestBodyElementId, @NotNull PsiFile pfile, final @Nullable OCSymbolKind kind, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
        final VirtualFile exVFile = pfile.getVirtualFile();
        final Project exProject = pfile.getProject();
        return new CidrTestScopeElementWithSerializerImpl(suiteName, testName, generator){
            @Nullable
            SofterReference<PsiElement> myPsiElement;

            @Override
            public void write(@NotNull Output output) {
                output.writeString(testName);
                output.writeString(suiteName);
                output.writeLong(offsetAsNaturalOrder);
                output.writeString(uniqueTestBodyElementId);
                output.writeString(kind == null ? null : kind.toString());
            }

            @Override
            public long getSortIndex() {
                return offsetAsNaturalOrder;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement element;
                PsiFile psiFile;
                if (this.myPsiElement != null) {
                    PsiElement element2 = (PsiElement)this.myPsiElement.get();
                    if (element2 != null && element2.isValid()) {
                        return element2;
                    }
                    this.myPsiElement = null;
                }
                CidrTestLog.LOG.assertTrue((psiFile = PsiManager.getInstance((Project)exProject).findFile(exVFile)) != null);
                if (OCTestFrameworks.canWaitInThisThread() && (element = this.getElementSlow(psiFile)) != null) {
                    CidrTestListUpdater.log("Moved element was found", new Object[0]);
                    this.myPsiElement = new SofterReference((Object)element);
                    return element;
                }
                element = psiFile.findElementAt(OCSymbolOffsetUtil.getTextOffset(offsetAsNaturalOrder));
                if (element != null) {
                    CidrTestListUpdater.log("Element from position", new Object[0]);
                    return element;
                }
                CidrTestListUpdater.log("File as element", new Object[0]);
                return psiFile;
            }

            @Nullable
            private PsiElement getElementSlow(@NotNull PsiFile psiFile) {
                PsiElement element;
                OCFile realSource;
                if (!(psiFile instanceof OCFile) || uniqueTestBodyElementId == null) {
                    return null;
                }
                OCSymbolReference.GlobalReference bodyRef = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.parse(uniqueTestBodyElementId));
                OCFile source = (OCFile)psiFile;
                if (OCInclusionContextUtil.isNeedToFindRoot(psiFile) && (realSource = ((OCFile)psiFile).getAssociatedFile()) != null) {
                    source = realSource;
                }
                List<OCSymbol> symbols = bodyRef.resolveToSymbols(OCResolveContext.forPsi(source));
                OCSymbol preDeclaration = null;
                for (OCSymbol symbol : symbols) {
                    PsiElement element2 = this.extractElement(symbol);
                    if (element2 != null) {
                        return element2;
                    }
                    if (preDeclaration != null || symbol.getKind() != OCSymbolKind.FUNCTION_PREDECLARATION) continue;
                    preDeclaration = symbol;
                }
                if (preDeclaration != null && (element = this.extractElement(preDeclaration.getDefinitionSymbol(source.getProject()))) != null) {
                    return element;
                }
                return null;
            }

            @Override
            @Nullable
            public String getId() {
                return uniqueTestBodyElementId;
            }

            @Contract(value="null -> null")
            @Nullable
            private PsiElement extractElement(@Nullable OCSymbol symbol) {
                if (symbol != null && symbol.getKind() == kind) {
                    return OCSymbolHolderVirtualPsiElement.create(symbol, exProject);
                }
                return null;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeWithPatternAndConfigurationName(final @NotNull String configurationName, final @NotNull String pattern) {
        return new CidrTestScopeElementImpl(){

            @Override
            @NotNull
            public String getConfigurationName() {
                return configurationName;
            }

            @Override
            @NotNull
            public String getPattern() {
                return pattern;
            }

            @Override
            public boolean isPatternLike() {
                return true;
            }
        };
    }

    public static class CidrTestWithScopeElementsSerializer
    implements CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> {
        Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> myGenerator;
        private static final int SKIP_WATERMARK = -1;
        private static final int TEST_WITH_SCOPE_ELEMENTS_SERIALIZER = 0;

        public CidrTestWithScopeElementsSerializer() {
            this.myGenerator = null;
        }

        public CidrTestWithScopeElementsSerializer(@NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
            this.myGenerator = generator;
        }

        public void setGenerator(@NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
            this.myGenerator = generator;
        }

        @Override
        public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestScopeElement testScope) {
            if (testScope instanceof CidrTestScopeElementWithSerializerImpl) {
                output.writeInt(0);
                ((CidrTestScopeElementWithSerializerImpl)testScope).write(output);
                return;
            }
            output.writeInt(-1);
        }

        @Override
        @Nullable
        public CidrTestScopeElement read(@NotNull Kryo kryo, @NotNull Input input, @NotNull PsiFile psiFileWithTest) {
            int watermark = input.readInt();
            if (watermark == 0) {
                return CidrTestScopeElementWithSerializerImpl.read(input, psiFileWithTest, this.getGenerator());
            }
            return null;
        }

        @NotNull
        @Contract(pure=true)
        public Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> getGenerator() {
            assert (this.myGenerator != null);
            return this.myGenerator;
        }
    }

    private static abstract class CidrTestScopeElementWithSerializerImpl
    extends CidrTestScopeElementImpl {
        CidrTestScopeElementWithSerializerImpl(@Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
            super(suiteName, testName, generator);
        }

        public abstract void write(@NotNull Output var1);

        @NotNull
        public static CidrTestScopeElement read(@NotNull Input input, @NotNull PsiFile psiFileWithTest, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
            String testName = input.readString();
            String suiteName = input.readString();
            long offsetAsNaturalOrder = input.readLong();
            String uniqueTestBodyElementId = input.readString();
            String name2 = input.readString();
            OCSymbolKind kind = StringUtil.isEmpty((String)name2) ? null : OCSymbolKind.valueOf(name2);
            return CidrTestScopeElementWithSerializerImpl.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, uniqueTestBodyElementId, psiFileWithTest, kind, generator);
        }
    }

    public static class DefaultPropertiesGenerator
    extends AbstractPropertiesGenerator {
        protected CidrTestScopeElementImpl myOwner;

        public DefaultPropertiesGenerator(CidrTestScopeElementImpl owner2) {
            this.myOwner = owner2;
        }

        @Override
        public boolean isTest() {
            return this.myOwner.myTestName != null;
        }

        @Override
        public boolean isPatternLike() {
            return false;
        }

        @Override
        @NotNull
        public String getTestPath() {
            if (this.myOwner.isVirtualPathHolder()) {
                return this.myOwner.getTestPath();
            }
            StringBuilder testName = new StringBuilder();
            if (this.myOwner.mySuiteName != null) {
                testName.append(this.myOwner.mySuiteName);
            }
            if (this.myOwner.myTestName != null) {
                if (testName.length() != 0) {
                    testName.append('/');
                }
                testName.append(this.myOwner.myTestName);
            }
            return testName.toString();
        }

        @Override
        @NotNull
        public String getPattern() {
            return this.getTestPath();
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            if (this.myOwner.myTestName != null) {
                return this.myOwner.myTestName;
            }
            if (this.myOwner.mySuiteName != null) {
                int index = this.myOwner.mySuiteName.lastIndexOf(47);
                return index < 0 ? this.myOwner.mySuiteName : this.myOwner.mySuiteName.substring(index + 1);
            }
            return "";
        }
    }

    public static abstract class AbstractPropertiesGenerator
    implements CidrTestScopeElement {
        @Override
        @NotNull
        public PsiElement getElement() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getSuiteName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getTestName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }
    }
}

