/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestWithScopeElementsFramework<TEST_OBJECT extends CidrTestScopeElement>
extends CidrTestFrameworkBase<TEST_OBJECT> {
    protected final Class<? extends PsiElement>[] myTestHolderClassWithoutMacroCall;
    protected final boolean myCanHaveMacroAsTest;
    protected final boolean myCanHaveNamespaceAsTest;
    protected final boolean myCanHaveClassAsTest;
    protected final boolean myCanHaveFunctionAsTest;
    protected final boolean myCanHaveDeclaratorAsTest;
    protected OCSymbolKind[] myDeclaratorKinds = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE};
    protected final Key<Map<String, TEST_OBJECT>> myObjects = Key.create((String)(this.myFrameworkId + " objects"));
    protected final Key<Boolean> myIsDirty = Key.create((String)(this.myFrameworkId + " dirty"));
    private final Key<Pair<TEST_OBJECT, Long>> myTestScopeInElementWithVersion = Key.create((String)(this.myFrameworkId + "Test Scope With Version"));

    protected CidrTestWithScopeElementsFramework(@NonNls @NotNull String testFrameworkId, @NotNull Function<PsiFile, ModificationTracker> modificationTrackerProducer, @NotNull Class<? extends PsiFile> fileClass, Class<? extends PsiElement> ... testHolderClass) {
        super(testFrameworkId, modificationTrackerProducer, fileClass, testHolderClass);
        this.myTestHolderClassWithoutMacroCall = ContainerUtil.filter((Collection)this.myTestHolderClass, clazz -> !clazz.equals(OCMacroCall.class)).toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        this.myCanHaveMacroAsTest = this.myTestHolderClass.contains(OCMacroCall.class);
        this.myCanHaveNamespaceAsTest = this.myTestHolderClass.contains(OCCppNamespace.class);
        this.myCanHaveClassAsTest = this.myTestHolderClass.contains(OCStruct.class);
        this.myCanHaveFunctionAsTest = this.myTestHolderClass.contains(OCFunctionDefinition.class);
        this.myCanHaveDeclaratorAsTest = this.myTestHolderClass.contains(OCDeclarator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, TEST_OBJECT> getOrCreateObjects(@NotNull PsiFile actualFile, @NotNull CidrTestInfoForFile infoForFile) {
        boolean isDirty;
        if (infoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE) {
            return Collections.emptyMap();
        }
        Map objects = (Map)this.myObjects.get((UserDataHolder)infoForFile);
        boolean bl = isDirty = this.myIsDirty.get((UserDataHolder)infoForFile) == Boolean.TRUE;
        if (objects != null && !isDirty) {
            return objects;
        }
        CidrTestListUpdater updater = this.getUpdater(actualFile.getProject());
        if (!OCTestFrameworks.canWaitInThisThread()) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            return objects != null ? objects : Collections.emptyMap();
        }
        Map<String, TEST_OBJECT> objectsDirectly = this.createTestObjectsDirectly(actualFile);
        CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
        synchronized (cidrTestInfoForFile) {
            this.myIsDirty.set((UserDataHolder)infoForFile, null);
            this.myObjects.set((UserDataHolder)infoForFile, objectsDirectly);
            updater.incTestInfoVersion();
        }
        return objectsDirectly;
    }

    @Override
    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
        this.getOrCreateObjects(file, newTestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
        if (src != null) {
            CidrTestInfoForFile cidrTestInfoForFile = dst;
            synchronized (cidrTestInfoForFile) {
                this.myIsDirty.set((UserDataHolder)dst, (Object)Boolean.TRUE);
                this.myObjects.set((UserDataHolder)dst, this.myObjects.get((UserDataHolder)src));
            }
        }
    }

    @NotNull
    public Map<String, TEST_OBJECT> getTestObjects(@NotNull PsiFile file) {
        return this.getOrCreateObjects(file, this.getTestInfo(file));
    }

    public void updateTestsListOrScheduleUpdateIfCannotWait(@NotNull PsiFile file) {
        this.getTestObjects(file);
    }

    @Override
    @Nullable
    protected TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile file) {
        CidrTestScopeElement scope = CidrTestScopeElementImpl.createTestScopeElementForFile(file, () -> CidrTestScope.createFilePattern(this, () -> CidrTestScope.createEmptyTestScope(this.getPatternSeparatorInCommandLine()), file, this::shouldAddToFileScope));
        return (TEST_OBJECT)scope;
    }

    protected boolean shouldAddToFileScope(@NotNull CidrTestScopeElement testScopeElement) {
        return testScopeElement.isTest();
    }

    @NotNull
    protected abstract Map<String, TEST_OBJECT> createTestObjectsDirectly(@NotNull PsiFile var1);

    @NotNull
    protected abstract String getProtocolPrefix();

    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suite, @Nullable String test) {
        throw new RuntimeException("Not implemented");
    }

    protected TEST_OBJECT getTestObjectFromTestHolder(@NotNull PsiElement maybeTestHolder, @NotNull Set<String> macroNames) {
        Pair pair2 = (Pair)this.myTestScopeInElementWithVersion.get((UserDataHolder)maybeTestHolder);
        Project project2 = maybeTestHolder.getProject();
        long modificationCount = this.getUpdater(project2).getModificationCount();
        if (pair2 != null && (Long)pair2.second == modificationCount) {
            return (TEST_OBJECT)((CidrTestScopeElement)pair2.first);
        }
        TEST_OBJECT ret = null;
        boolean saveResultToCache = false;
        if (this.isTestMacroCandidate(maybeTestHolder, macroNames)) {
            ret = this.findTestObjectFromMacro(maybeTestHolder, macroNames);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveNamespaceAsTest && maybeTestHolder instanceof OCCppNamespace) {
            ret = this.extractTestObject(((OCCppNamespace)maybeTestHolder).getSymbol(), project2, OCSymbolKind.NAMESPACE);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveClassAsTest && maybeTestHolder instanceof OCStruct) {
            ret = this.extractTestObject(((OCStruct)maybeTestHolder).getSymbol(), project2, OCSymbolKind.STRUCT);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveFunctionAsTest && maybeTestHolder instanceof OCFunctionDefinition) {
            ret = this.extractTestObject(((OCFunctionDefinition)maybeTestHolder).getSymbol(), project2, OCSymbolKind.FUNCTION_DECLARATION);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveDeclaratorAsTest && maybeTestHolder instanceof OCDeclarator) {
            ret = this.extractTestObject(((OCDeclarator)maybeTestHolder).getSymbol(), project2, this.myDeclaratorKinds);
            saveResultToCache = true;
        }
        if (saveResultToCache) {
            this.cacheResultForTestHolder(maybeTestHolder, ret);
        }
        return ret;
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret) {
        this.myTestScopeInElementWithVersion.set((UserDataHolder)maybeTestHolder, (Object)Pair.create(ret, (Object)this.getUpdater(maybeTestHolder.getProject()).getModificationCount()));
    }

    @Contract(value="null, _, _ -> null")
    protected TEST_OBJECT extractTestObject(@Nullable OCSymbol symbol, @NotNull Project project2, OCSymbolKind ... kinds) {
        if (symbol == null) {
            return null;
        }
        PsiFile file = symbol.getContainingPsiFile(project2);
        if (file != null && this.isAvailable(file)) {
            for (OCSymbolKind canBe : kinds) {
                if (symbol.getKind() != canBe) continue;
                OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
                String key = this.getTestObjectKeyForSymbol(symbol, context);
                return (TEST_OBJECT)((CidrTestScopeElement)this.getTestObjects(file).get(key));
            }
        }
        return null;
    }

    @Nullable
    protected String getTestObjectKeyForSymbol(@NotNull OCSymbol symbol, OCResolveContext context) {
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return null;
        }
        return CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
    }

    @Contract(value="null, null, _, _, _ -> false")
    protected boolean standardProbe(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Class<?> clazz, @NotNull Project project2, OCSymbolKind ... symbolKind) {
        if (symbol == null && clazz.isInstance(element)) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        return this.extractTestObject(symbol, project2, symbolKind) != null;
    }

    protected TEST_OBJECT findTestObjectFromMacro(@NotNull PsiElement maybeMacro, @NotNull Set<String> testMacroNames) {
        Ref ref = new Ref();
        ((OCMacroCall)maybeMacro).processExpansionLeaves((Processor<PsiElement>)((Processor)leaf -> {
            TEST_OBJECT ret;
            OCElement testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])this.myTestHolderClassWithoutMacroCall);
            if (testHolder != null && testHolder.getComplexOffset() > ((OCMacroCall)maybeMacro).getComplexOffset() && (ret = this.getTestObjectFromTestHolder(testHolder, testMacroNames)) != null) {
                ref.set(ret);
                return false;
            }
            return true;
        }));
        return (TEST_OBJECT)((CidrTestScopeElement)ref.get());
    }

    @Contract(pure=true)
    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        return element instanceof OCMacroCall;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull String pathToFind, @NotNull Project project2, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        Ref result = new Ref();
        this.consumeTestObjects(project2, (SearchScope)scope, testInfo -> {
            if (pathToFind.equals(testInfo.getTestPath())) {
                result.set(testInfo);
                return false;
            }
            return true;
        });
        return (TEST_OBJECT)((CidrTestScopeElement)result.get());
    }

    @NotNull
    public Collection<TEST_OBJECT> collectTestObjects(@NotNull String pathToFind, @NotNull Project project2, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.consumeTestObjects(pathToFind, project2, scope, (Processor<? super TEST_OBJECT>)processor2);
        return processor2.getResults();
    }

    public void consumeTestObjects(@NotNull String pathToFind, @NotNull Project project2, @Nullable GlobalSearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor2) {
        int pathToFindLength = pathToFind.length();
        this.consumeTestObjects(project2, (SearchScope)scope, testInfo -> {
            String infoTestPath = testInfo.getTestPath();
            if (infoTestPath.startsWith(pathToFind) && (pathToFindLength == infoTestPath.length() || infoTestPath.charAt(pathToFindLength) == '/')) {
                processor2.process(testInfo);
            }
            return true;
        });
    }

    public void consumeTestObjects(@NotNull Project project2, @Nullable SearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor2) throws IndexNotReadyException {
        LinkedList<VirtualFile> testFirstCollection = new LinkedList<VirtualFile>();
        CidrTestListUpdater.fillCollectionWithTestFirst(this.getPotentialTestHolderRoots(project2), testFirstCollection);
        this.consumeTestInfo(project2, testFirstCollection.iterator(), scope, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileAndFileInfo -> {
            for (CidrTestScopeElement testScope : this.getOrCreateObjects((PsiFile)fileAndFileInfo.first, (CidrTestInfoForFile)((Object)((Object)fileAndFileInfo.second))).values()) {
                if (processor2.process((Object)testScope)) continue;
                return false;
            }
            return true;
        }));
    }

    @Override
    @Contract(value="null -> null")
    public OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement testElement) {
        if (testElement == null || CidrTestWithScopeElementsFramework.isMacroInjectedIdOwner(testElement)) {
            return null;
        }
        final CidrTestScopeElement testObject = (CidrTestScopeElement)this.getTestObject(testElement);
        if (testObject != null) {
            return new OCTestLineMarkInfo(){

                @Override
                @NotNull
                public String getUrlInTestTree() {
                    return CidrTestWithScopeElementsFramework.this.getTestUrl(testObject);
                }

                @Override
                public boolean isSuite() {
                    return !testObject.isTest();
                }
            };
        }
        return null;
    }

    @NotNull
    protected String getTestUrl(@NotNull TEST_OBJECT testObject) {
        return this.getProtocolPrefix() + testObject.getTestPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestInfoForFile testInfo) {
        CidrTestScopeSerializer serializer2 = this.getTestSerializer();
        if (serializer2 == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = testInfo;
        synchronized (cidrTestInfoForFile) {
            Map map2 = (Map)this.myObjects.get((UserDataHolder)testInfo);
            if (map2 == null) {
                output.writeInt(0);
            } else {
                output.writeInt(map2.size());
                map2.forEach((name2, testScopeElement) -> {
                    output.writeString(name2);
                    serializer2.write(kryo, output, testScopeElement);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
        CidrTestScopeSerializer<TEST_OBJECT> serializer2 = this.getTestSerializer();
        if (serializer2 == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = initTestInfo;
        synchronized (cidrTestInfoForFile) {
            HashMap<String, TEST_OBJECT> links = new HashMap<String, TEST_OBJECT>();
            int testCount = input.readInt();
            for (int i = 0; i < testCount; ++i) {
                String name2 = input.readString();
                TEST_OBJECT scopeElement = serializer2.read(kryo, input, fileWithTest);
                if (scopeElement == null) continue;
                links.put(name2, scopeElement);
            }
            this.myObjects.set((UserDataHolder)initTestInfo, links);
        }
    }

    @Nullable
    protected CidrTestScopeSerializer<TEST_OBJECT> getTestSerializer() {
        return null;
    }

    public static interface CidrTestScopeSerializer<TEST_OBJECT extends CidrTestScopeElement> {
        public void write(@NotNull Kryo var1, @NotNull Output var2, @NotNull TEST_OBJECT var3);

        @Nullable
        public TEST_OBJECT read(@NotNull Kryo var1, @NotNull Input var2, @NotNull PsiFile var3);
    }
}

