/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrFromTagInLineToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostOutputToGeneralTestEventsConverter
extends CidrFromTagInLineToGeneralTestEventsConverter {
    @RegExp
    private static final String TEST_TIME = "(?:; testing time: (\\d+.+))?\n";
    String myPrevLineLocation = null;
    boolean myFirstSuiteIsModule = true;
    boolean myInitialized = false;

    public CidrBoostOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console) {
        super(testFrameworkName, consoleProperties, new CidrTestEventProcessor("boost"), console);
    }

    @Override
    protected void processLine(Key outputType, String text) {
        if (ProcessOutputType.isStderr((Key)outputType) && text.startsWith("*** ")) {
            this.myFinalTestReport = text;
            return;
        }
        CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag = Tag.parse(text);
        GeneralTestEventsProcessor processor2 = this.getProcessor();
        if (tag == null) {
            String testName = this.myTestNameStack.isEmpty() ? "" : (String)this.myTestNameStack.peek();
            String nodeId = this.getCurrentNodeId();
            if (nodeId.equals("0")) {
                processor2.onUncapturedOutput(text, outputType);
                return;
            }
            this.process(ProcessOutputType.isStdout((Key)outputType) ? this.myEventProcessor.testStdOut(testName, nodeId, text) : this.myEventProcessor.testErrOut(testName, nodeId, text));
            return;
        }
        Tag etag = tag.getTag();
        Runnable init = () -> {
            processor2.onTestsReporterAttached();
            processor2.onUncapturedOutput(String.format("Entering test module %s\n", tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME)), ProcessOutputTypes.STDOUT);
            this.myInitialized = true;
        };
        Runnable done = () -> processor2.onUncapturedOutput(String.format("Leaving test module %s\n", tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME)), ProcessOutputTypes.STDOUT);
        switch (etag) {
            case PURE_LOCATION: {
                this.myPrevLineLocation = text;
                break;
            }
            case MODULE_START: {
                this.myFirstSuiteIsModule = false;
                init.run();
                break;
            }
            case SUITE_START: {
                if (this.myFirstSuiteIsModule && !this.myInitialized) {
                    init.run();
                    break;
                }
            }
            case TEST_START: {
                String nodeName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                String parentId = this.getCurrentNodeId();
                this.myTestNameStack.push(nodeName);
                this.myTestResultStack.push(CidrFromTagInLineToGeneralTestEventsConverter.TestResult.create(true, 0));
                String nodeId = this.getCurrentNodeId();
                String location = this.getLocationFromId();
                String metainfo = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM);
                this.process(etag == Tag.TEST_START ? this.myEventProcessor.testStarted(nodeName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(nodeName, parentId, nodeId, location, metainfo));
                break;
            }
            case MODULE_END: {
                done.run();
                break;
            }
            case SUITE_END: {
                if (this.myFirstSuiteIsModule && this.myTestNameStack.isEmpty()) {
                    done.run();
                    break;
                }
            }
            case TEST_END: {
                String nodeName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                long durationInMs = CidrBoostOutputToGeneralTestEventsConverter.getTimeInMs(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME));
                String nodeId = this.getCurrentNodeId();
                this.myTestNameStack.pop();
                boolean succeeded = ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.pop()).success;
                if (!this.myTestResultStack.isEmpty()) {
                    ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(succeeded, durationInMs);
                }
                this.process(etag == Tag.TEST_END ? this.myEventProcessor.testFinished(nodeName, nodeId, String.valueOf(durationInMs), succeeded) : this.myEventProcessor.suiteFinished(nodeName, nodeId));
                break;
            }
            case EXCEPTION: 
            case ERROR: 
            case FATAL_ERROR: {
                if (!this.myTestResultStack.isEmpty()) {
                    ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(false, 0L);
                }
                ((GeneralIdBasedToSMTRunnerEventsConvertor)processor2).onError(this.getCurrentNodeId(), "", StringUtil.notNullize((String)this.myPrevLineLocation) + text, false);
            }
        }
        if (etag != Tag.PURE_LOCATION) {
            this.myPrevLineLocation = null;
        }
    }

    static enum Tag {
        MODULE_START("Entering test module \"(.+)\"\n"),
        MODULE_END("Leaving test module \"(.+)\"(?:; testing time: (\\d+.+))?\n"),
        SUITE_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Entering test suite \"(.*)\"\n"),
        SUITE_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Leaving test suite \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        TEST_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Entering test case \"(.*)\"\n"),
        TEST_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Leaving test case \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        EXCEPTION("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?last checkpoint: \"(.*)\" entry."),
        FATAL_ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?fatal error: in \"(.*)\": (.*)\n"),
        ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?error: in \"(.*)\": (.*)\n"),
        PURE_LOCATION("((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: $");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            this.myTagPattern = Pattern.compile(pattern);
        }

        @Nullable
        public static CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> parse(@NotNull String line) {
            for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.find()) continue;
                HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String> attrs = new HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String>();
                switch (tag) {
                    case MODULE_END: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(2));
                    }
                    case MODULE_START: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                        break;
                    }
                    case SUITE_END: 
                    case TEST_END: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(4));
                    }
                    case SUITE_START: 
                    case TEST_START: 
                    case EXCEPTION: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(3));
                        break;
                    }
                    case ERROR: 
                    case FATAL_ERROR: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(3));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, matcher.group(4));
                        break;
                    }
                    case PURE_LOCATION: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                    }
                }
                return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag>(tag, attrs);
            }
            return null;
        }
    }
}

