/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope(CidrBoostTestFramework.getInstance().getPatternSeparatorInCommandLine());

    public CidrBoostTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        return CidrBoostTestCommandLineState.doCreateRerunFailedTestsActionStandard(this, consoleView, "boost://");
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String suite, @Nullable String test) {
        return CidrBoostTestFramework.getInstance().createTestScopeElementForSuiteAndTest(suite, test);
    }

    @Override
    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        Object configuration = this.getConfiguration();
        configuration.getTestData().setCommandLineTestPattern(CidrTestScope.getAsPatternForCommandLine(configuration.getProject(), CidrBoostTestFramework.getInstance(), EMPTY_TEST_SCOPE_PRODUCER, this.testScope(), progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Override
    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    @Override
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        String commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern();
        if (!StringUtil.isEmpty((String)commandLineTestPattern)) {
            cl.addParameter("--run_test=" + commandLineTestPattern);
        }
        String testLogFormat = "--log_format=";
        String testLogLevel = "--log_level=";
        String testLogger = "--logger=";
        String line = cl.getPreparedCommandLine();
        if (!(line.contains("--log_format=") || line.contains("--log_level=") || line.contains("--logger="))) {
            cl.addParameters(new String[]{"--logger=HRF,all"});
        }
        cl.addParameters(new String[]{"--color_output=false", "--report_format=HRF", "--show_progress=no"});
        return cl;
    }
}

