/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.jetbrains.cidr.execution.testing.CidrAbstractTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestLocationProvider;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CidrBoostTestConsoleProperties
extends CidrAbstractTestConsoleProperties {
    private static final Pattern FAILURE_PATTERN = Pattern.compile("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?(?:last checkpoint|error|fatal error):[^\\n]*");

    public CidrBoostTestConsoleProperties(@NotNull RunConfiguration config, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        super(config, "Boost Test", executor, target);
        this.setIdBasedTestTree(true);
    }

    public SMTestLocator getTestLocator() {
        return CidrBoostTestLocationProvider.INSTANCE;
    }

    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        return new CidrBoostOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties, this.getConsole());
    }

    @Override
    @NotNull
    protected Pattern getAssertionPattern() {
        return FAILURE_PATTERN;
    }
}

