/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static final String BOOST_HEADER_NAME = "unit_test.hpp";
    public static final Set<String> BOOST_TEST_MACRO_NAMES = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])new String[]{"BOOST_FIXTURE_TEST_SUITE", "BOOST_FIXTURE_TEST_CASE", "BOOST_FIXTURE_TEST_CASE_TEMPLATE", "BOOST_CLASS_TEST_CASE", "BOOST_AUTO_TEST_SUITE", "BOOST_AUTO_TEST_CASE", "BOOST_DATA_TEST_CASE", "BOOST_DATA_TEST_CASE_F", "BOOST_DATA_TEST_CASE_WITH_PARAMS", "BOOST_DATA_TEST_CASE_NO_PARAMS", "BOOST_AUTO_TEST_CASE_TEMPLATE", "BOOST_DATA_TEST_CASE_IMPL"}));
    private final Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator = testScopeElement -> new CidrTestScopeElementImpl.DefaultPropertiesGenerator((CidrTestScopeElementImpl)testScopeElement){

        @Override
        @NotNull
        public String getPattern() {
            String pattern_For_Command_Line = this.myOwner.getTestPath();
            if (pattern_For_Command_Line.endsWith("<>")) {
                pattern_For_Command_Line = pattern_For_Command_Line.substring(0, pattern_For_Command_Line.length() - 1) + "*";
            }
            return pattern_For_Command_Line;
        }
    };

    public static CidrBoostTestFramework getInstance() {
        return CidrBoostTestFramework.getInstance(CidrBoostTestFramework.class);
    }

    public CidrBoostTestFramework() {
        super("Boost Test", CidrBoostTestFramework.getCidrTopLevelChangesModificationTracker(), OCFile.class, OCMacroCall.class, OCCppNamespace.class, OCFunctionDefinition.class);
    }

    @Override
    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        return CidrBoostTestFramework.getFrameworkVersionUsingImportedMacro(file, "BOOST_AUTO_TEST_CASE");
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ":";
    }

    @Override
    @NotNull
    protected String getProtocolPrefix() {
        return "boost://";
    }

    @Override
    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        return this.getTestObjectFromTestHolder(element, BOOST_TEST_MACRO_NAMES);
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project2, OCSymbolKind.FUNCTION_DECLARATION);
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestNamespace(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        return this.standardProbe(symbol, element, OCCppNamespace.class, project2, OCSymbolKind.NAMESPACE);
    }

    @Override
    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        return CidrBoostTestUtil.createTestLinks(file);
    }

    @Override
    @NotNull
    public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        return this.myGenerator;
    }
}

