/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "boost";
    public static final String PROTOCOL_PREFIX = "boost://";
    public static final String DATA_TEST_CASE_PREFIX = "_";
    public static final String TYPED_TEXT_SUFFIX = "<>";
    public static final CidrBoostTestLocationProvider INSTANCE = new CidrBoostTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        return this.getLocation(protocol, path, null, project2, scope);
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (!PROTOCOL.equals(protocol)) {
            return Collections.emptyList();
        }
        CidrBoostTestFramework framework = CidrBoostTestFramework.getInstance();
        return framework.getUpdater(project2).getLocation((Computable<List<Location>>)((Computable)() -> {
            List<String> parts = CidrTestScopeElementImpl.splitPath(path);
            int lastIndex = parts.size() - 1;
            String configurationName = parts.get(lastIndex);
            String realPathToTest = CidrContextRunConfigurationProducer.replaceTemplateParamTo(path, TYPED_TEXT_SUFFIX);
            Object scopeElement = framework.findTestObject(realPathToTest, project2, scope);
            if (scopeElement == null) {
                if (parts.size() > 1 && configurationName.startsWith(DATA_TEST_CASE_PREFIX)) {
                    configurationName = parts.get(lastIndex - 1) + "(" + configurationName + ")";
                    parts.remove(lastIndex);
                    scopeElement = framework.findTestObject(CidrTestScopeElementImpl.createPathFromParts(parts), project2, scope);
                }
                if (scopeElement == null) {
                    return Collections.emptyList();
                }
            }
            if (!path.equals(scopeElement.getTestPath())) {
                scopeElement = CidrTestScopeElementImpl.createTestScopeElementForVirtualTestPath(path, configurationName, scopeElement, framework.getGenerator());
            }
            return Collections.singletonList(new CidrTestLocation(project2, scopeElement));
        }));
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project2) {
        return CidrBoostTestFramework.getInstance().getUpdater(project2);
    }
}

