/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestCommandLineState;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = connection -> new CidrBoostTestRunConfigurationData((CidrTestRunConfiguration)connection);
    @NonNls
    public static final String FRAMEWORK_ID = "Boost Test";

    public CidrBoostTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        super(configuration);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        return this.myTestName;
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        Project project2 = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || this.myTestSuite == null || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(project2)) {
            return;
        }
        String errorMessage = CidrTestFrameworkBase.getFromSymbols(null, project2, () -> {
            CidrBoostTestFramework instance2 = CidrBoostTestFramework.getInstance();
            if (instance2.findTestObject(instance2.createTestScopeElementForSuiteAndTest(this.myTestSuite, this.myTestName).getTestPath(), project2, null) == null) {
                return this.myTestName == null ? CidrBundle.message("test.suiteNotFound", this.myTestSuite) : CidrBundle.message("test.testNotFound", this.myTestName);
            }
            return null;
        });
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Override
    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    @Override
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        return new CidrBoostTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @Override
    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        return new CidrBoostTestConsoleProperties(this.myConfiguration, executor, target);
    }
}

