/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsRunConfigurationEditor;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestWithScopeElementsRunConfigurationEditor<BC, TARGET, CONFIGURATION, BCH> {
    private volatile String myBaseSuite;
    private final Set<String> mySuiteFullNames = new HashSet<String>();

    public CidrBoostTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper, CidrBoostTestFramework.class);
    }

    @Override
    protected boolean hasOutOfSuiteTests() {
        return true;
    }

    @Override
    @NotNull
    protected CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter createSuiteAdapter() {
        return new CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter(){

            @Override
            @NotNull
            public Collection<String> collectValuesFromProject(@NotNull Project project2, @Nullable Condition<String> conditionForSuiteName) {
                return CidrBoostTestRunConfigurationEditor.this.collectStringsFromProject(CidrBoostTestRunConfigurationEditor.this.myProject, pair2 -> {
                    CidrTestScopeElement testScopeElement = (CidrTestScopeElement)pair2.first;
                    if (!testScopeElement.isTest()) {
                        String suiteName = StringUtil.notNullize((String)testScopeElement.getSuiteName());
                        Set set = CidrBoostTestRunConfigurationEditor.this.mySuiteFullNames;
                        synchronized (set) {
                            CidrBoostTestRunConfigurationEditor.this.mySuiteFullNames.add(suiteName);
                        }
                        ((Set)pair2.second).addAll(StringUtil.split((String)suiteName, (String)CidrTestScopeElement.SEPARATOR, (boolean)true, (boolean)true));
                    }
                });
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
                return new SuitePrefixMatcher(prefix);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public String getPrefix(@NotNull String text, int offset) {
                Set set = CidrBoostTestRunConfigurationEditor.this.mySuiteFullNames;
                synchronized (set) {
                    int max = text.substring(0, offset).lastIndexOf(47) + 1;
                    CidrBoostTestRunConfigurationEditor.this.myBaseSuite = text.substring(0, max);
                    return text.substring(max, offset);
                }
            }
        };
    }

    @Override
    public boolean isValidSuiteName() {
        return CidrTestFrameworkBase.getFromSymbols(true, this.myProject, () -> {
            String suiteText = this.getTestSuiteText();
            return suiteText == null || CidrBoostTestFramework.getInstance().findTestObject(suiteText, this.myProject, null) != null;
        });
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String suite = this.getTestSuiteText();
        return this.collectStringsFromProject(this.myProject, pair2 -> {
            String testName;
            String suiteName = ((CidrTestScopeElement)pair2.first).getSuiteName();
            if ((suite == null ? suiteName == null : suite.equals(suiteName)) && (testName = ((CidrTestScopeElement)pair2.first).getTestName()) != null) {
                ((Set)pair2.second).add(testName);
            }
        });
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        return ContainerUtil.filter(super.getTargets(), target -> target.isExecutable());
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("test.allTestSuites", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("boost.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("test.configuration.suite", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return CidrBundle.message("test.allTestsInSuite", new Object[0]);
    }

    private class SuitePrefixMatcher
    extends PrefixMatcher {
        SuitePrefixMatcher(String prefix) {
            super(prefix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean prefixMatches(@NotNull String name2) {
            Set set = CidrBoostTestRunConfigurationEditor.this.mySuiteFullNames;
            synchronized (set) {
                return CidrBoostTestRunConfigurationEditor.this.myBaseSuite != null && !name2.equals(this.getPrefix()) && StringUtil.startsWith((CharSequence)name2, (CharSequence)this.getPrefix()) && CidrBoostTestRunConfigurationEditor.this.mySuiteFullNames.contains(CidrBoostTestRunConfigurationEditor.this.myBaseSuite + name2);
            }
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            return new SuitePrefixMatcher(prefix);
        }
    }
}

