/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestUtil {
    static final String TEST_METHOD_NAME = "test_method";
    static final String _IMPL_NAME = "_impl";
    private static final Pattern REGISTRAR = Pattern.compile(".*_registrar\\d+");
    private static final String REGISTRAR_TYPE = "auto_test_unit_registrar";
    private static final String MAKE_TEST_CASE = "make_test_case";
    private static final String MAKE_TEST_CASE_DATA_GEN = "make_test_case_gen";
    private static final String MAKE_TEST_CASE_TEMPLATE_GEN = "template_test_case_gen";
    private static final String INVOKER_SUFFIX = "_invoker";

    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        final Project project2 = file.getProject();
        final VirtualFile virtualFile = file.getVirtualFile();
        final CidrBoostTestFramework testFramework = CidrBoostTestFramework.getInstance();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(project2).value((Object)virtualFile);
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){
            final Stack<OCNamespaceSymbol> namespaces = new Stack();
            final Stack<String> suites = new Stack();
            String myLastSuiteQName;

            public boolean process(@NotNull OCSymbol symbol) {
                List<OCExpression> arguments;
                OCArgumentList argumentList;
                OCDeclarator declarator;
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project2);
                if (psiFile == null || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.namespaces.push((OCNamespaceSymbol)symbol);
                    List<OCSymbol> membersList = ((OCNamespaceSymbol)symbol).getMembersList();
                    if (membersList != null) {
                        for (OCSymbol nsSymbol : membersList) {
                            this.process(nsSymbol);
                        }
                    }
                    String endNamespace = this.namespaces.pop().getName();
                    if (this.suites.size() > 0 && this.suites.peek().equals(endNamespace)) {
                        this.suites.pop();
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE && REGISTRAR.matcher(symbol.getName()).find() && CidrBoostTestUtil.REGISTRAR_TYPE.equals(symbol.getType().getName()) && (declarator = (OCDeclarator)symbol.locateDefinition(project2)) != null && (argumentList = declarator.getArgumentList()) != null && (arguments = argumentList.getArguments()).size() > 0) {
                    OCReferenceElement testFactoryRefElement;
                    OCExpression ref;
                    OCExpression expression = arguments.get(0);
                    if (expression instanceof OCLiteralExpression) {
                        String suiteQName;
                        OCNamespaceSymbol nsSymbol;
                        String suiteName = ((OCLiteralExpression)expression).getEscapedLiteralText();
                        if (!this.namespaces.isEmpty() && (nsSymbol = this.namespaces.peek()).getName().equals(suiteName) && (suiteQName = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(nsSymbol, context)) != null) {
                            this.suites.push(suiteName);
                            links.put(suiteQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, CidrTestScopeElementImpl.createPathFromParts(this.suites), symbol.getComplexOffset(), suiteQName, psiFile, OCSymbolKind.NAMESPACE, testFramework.getGenerator()));
                            this.myLastSuiteQName = suiteQName;
                        }
                    } else if (expression instanceof OCCallExpression && (ref = ((OCCallExpression)expression).getFunctionReferenceExpression()) instanceof OCReferenceExpression && (testFactoryRefElement = ((OCReferenceExpression)ref).getReferenceElement()) != null) {
                        String functionName = testFactoryRefElement.getCanonicalText();
                        List<OCExpression> makeTestCaseArgs = ((OCCallExpression)expression).getArgumentList().getArguments();
                        Pair pair2 = null;
                        boolean testAsSuite = false;
                        if (CidrBoostTestUtil.MAKE_TEST_CASE.equals(functionName)) {
                            pair2 = CidrBoostTestUtil.processOrdinalTest(makeTestCaseArgs, context);
                        } else if (CidrBoostTestUtil.MAKE_TEST_CASE_DATA_GEN.equals(functionName)) {
                            pair2 = CidrBoostTestUtil.processDataGeneratorTest(testFactoryRefElement, makeTestCaseArgs);
                            testAsSuite = true;
                        } else if (CidrBoostTestUtil.MAKE_TEST_CASE_TEMPLATE_GEN.equals(functionName)) {
                            pair2 = CidrBoostTestUtil.processTemplateGeneratorTest(testFactoryRefElement, makeTestCaseArgs);
                        }
                        if (pair2 != null) {
                            String generatorWrapperSuite = null;
                            String testName = (String)pair2.second;
                            String testQName = (String)pair2.first + "::" + (testAsSuite ? CidrBoostTestUtil._IMPL_NAME : CidrBoostTestUtil.TEST_METHOD_NAME);
                            if (testAsSuite && !this.suites.isEmpty()) {
                                generatorWrapperSuite = this.suites.pop();
                            }
                            links.put(testQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(testName, CidrTestScopeElementImpl.createPathFromParts(this.suites), symbol.getComplexOffset(), testQName, psiFile, OCSymbolKind.FUNCTION_DECLARATION, testFramework.getGenerator()));
                            if (generatorWrapperSuite != null) {
                                if (this.myLastSuiteQName != null) {
                                    links.remove(this.myLastSuiteQName);
                                }
                                this.suites.push(generatorWrapperSuite);
                            }
                        }
                    }
                }
                return true;
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, processor2);
        return links;
    }

    @Nullable
    private static Pair<String, String> processDataGeneratorTest(@NotNull OCReferenceElement testFactoryCall, @NotNull List<OCExpression> makeTestCaseArgs) {
        OCExpression testNameHolder;
        if (makeTestCaseArgs.size() > 0 && (testNameHolder = makeTestCaseArgs.get(0)) instanceof OCLiteralExpression) {
            OCElement testClass;
            List listArguments;
            String test = ((OCLiteralExpression)testNameHolder).getEscapedLiteralText();
            OCTemplateArgumentList templateArgumentList = (OCTemplateArgumentList)PsiTreeUtil.findChildOfType((PsiElement)testFactoryCall, OCTemplateArgumentList.class);
            if (templateArgumentList != null && (listArguments = templateArgumentList.getArguments()).size() > 0 && (testClass = (OCElement)listArguments.get(0)) instanceof OCTypeElement) {
                OCResolveContext context = OCResolveContext.forPsi(testFactoryCall);
                String testClassName = ((OCTypeElement)testClass).getType().resolve(context).getCanonicalName(context);
                return Pair.create((Object)testClassName, (Object)test);
            }
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> processTemplateGeneratorTest(@NotNull OCReferenceElement testFactoryCall, @NotNull List<OCExpression> makeTestCaseArgs) {
        OCExpression testNameHolder;
        if (makeTestCaseArgs.size() > 0 && (testNameHolder = makeTestCaseArgs.get(0)) instanceof OCLiteralExpression) {
            OCElement testClass;
            List listArguments;
            String test = ((OCLiteralExpression)testNameHolder).getEscapedLiteralText();
            OCTemplateArgumentList templateArgumentList = (OCTemplateArgumentList)PsiTreeUtil.findChildOfType((PsiElement)testFactoryCall, OCTemplateArgumentList.class);
            if (templateArgumentList != null && (listArguments = templateArgumentList.getArguments()).size() > 0 && (testClass = (OCElement)listArguments.get(0)) instanceof OCTypeElement) {
                OCResolveContext context = OCResolveContext.forPsi(testFactoryCall);
                String testClassName = ((OCTypeElement)testClass).getType().resolve(context).getCanonicalName(context);
                if (testClassName.endsWith(INVOKER_SUFFIX)) {
                    return Pair.create((Object)testClassName.substring(0, testClassName.length() - INVOKER_SUFFIX.length()), (Object)(test + "<>"));
                }
            }
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> processOrdinalTest(@NotNull List<OCExpression> makeTestCaseArgs, @NotNull OCResolveContext context) {
        OCExpression maybeTestName;
        if (makeTestCaseArgs.size() > 1 && (maybeTestName = makeTestCaseArgs.get(1)) instanceof OCLiteralExpression) {
            String name2;
            OCQualifiedName qualifiedName;
            OCSymbol symbolRef;
            OCExpression maybeInvokerRef;
            String test = ((OCLiteralExpression)maybeTestName).getEscapedLiteralText();
            OCExpression maybeInvoker = makeTestCaseArgs.get(0);
            if (maybeInvoker instanceof OCUnaryExpression && (maybeInvokerRef = ((OCUnaryExpression)maybeInvoker).getOperand()) instanceof OCReferenceExpression && (symbolRef = ((OCReferenceExpression)maybeInvokerRef).resolveToSymbol()) instanceof OCFunctionSymbol && (qualifiedName = ((OCFunctionSymbol)symbolRef).getResolvedQualifiedName(context)) != null && (name2 = qualifiedName.getFullName(context)) != null && name2.endsWith(INVOKER_SUFFIX)) {
                String testClassName = name2.substring(0, name2.length() - INVOKER_SUFFIX.length());
                return Pair.create((Object)testClassName, (Object)test);
            }
        }
        return null;
    }
}

