/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrFromTagInLineToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleOutputToGeneralTestEventsConverter
extends CidrFromTagInLineToGeneralTestEventsConverter {
    protected final HashMap<String, String> myRenamedClosedNodeIds = new HashMap();
    @RegExp
    private static final String TEST_TIME = " \\(:?(\\d+ ms)(?: total)?\\)?\n";
    boolean myFinished = false;

    public CidrGoogleOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console) {
        super(testFrameworkName, consoleProperties, new CidrTestEventProcessor("gtest"), console);
    }

    @Override
    protected void processLine(Key outputType, String text) {
        CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag = Tag.parse(text);
        String outText = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
        GeneralTestEventsProcessor processor2 = this.getProcessor();
        if (outText != null && !outText.isEmpty()) {
            String testName = this.myTestNameStack.isEmpty() ? "" : (String)this.myTestNameStack.peek();
            String nodeId = this.getCurrentNodeId();
            if (nodeId.equals("0")) {
                processor2.onUncapturedOutput(outText, outputType);
                return;
            }
            this.process(ProcessOutputType.isStdout((Key)outputType) ? this.myEventProcessor.testStdOut(testName, nodeId, outText) : this.myEventProcessor.testErrOut(testName, nodeId, outText));
        }
        if (this.myFinished) {
            return;
        }
        Tag etag = tag.getTag();
        switch (etag) {
            case MODULE_START: {
                processor2.onTestsReporterAttached();
                break;
            }
            case SUITE_START: 
            case TEST_START: {
                this.ensureOpen(tag, processor2, etag);
                break;
            }
            case MODULE_END: {
                int testStackSize = this.myTestNameStack.size();
                for (int toClose = 0; toClose < testStackSize; ++toClose) {
                    this.closeLastNode(processor2, null, 0L, false);
                }
                this.myFinished = true;
                break;
            }
            case SUITE_END: 
            case TEST_END: {
                this.closeLastNode(processor2, tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED), CidrGoogleOutputToGeneralTestEventsConverter.getTimeInMs(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME)), etag == Tag.TEST_END);
            }
        }
    }

    private void ensureOpen(@NotNull CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag, @NotNull GeneralTestEventsProcessor processor2, @NotNull Tag etag) {
        String attr = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
        if (attr == null) {
            return;
        }
        CidrGoogleTestLinker linker = CidrGoogleTestLinker.parseTestOut(attr);
        if (linker == null) {
            return;
        }
        Pair<String, String> pair2 = CidrGoogleTestLinker.splitByFirst(linker.getPath(), " - ");
        String[] need = ((String)pair2.first).split(CidrTestScopeElement.SEPARATOR);
        if (pair2.second != null && need.length > 0) {
            int n = need.length - 1;
            need[n] = need[n] + " - " + (String)pair2.second;
        }
        int lastCommonParent = 0;
        for (String nodeNames : this.myTestNameStack) {
            if (lastCommonParent >= need.length || !CidrGoogleTestLinker.namesEqual(need[lastCommonParent], nodeNames)) break;
            ++lastCommonParent;
        }
        int testStackSize = this.myTestNameStack.size();
        for (int toClose = lastCommonParent; toClose < testStackSize; ++toClose) {
            this.closeLastNode(processor2, null, 0L, false);
        }
        for (int toOpen = lastCommonParent; toOpen < need.length; ++toOpen) {
            this.openNewNode(processor2, need[toOpen], toOpen == need.length - 1 && etag == Tag.TEST_START);
        }
    }

    @Override
    @NotNull
    protected String getCurrentNodeId() {
        String id = super.getCurrentNodeId();
        while (this.myRenamedClosedNodeIds.containsKey(id)) {
            id = this.myRenamedClosedNodeIds.get(id);
        }
        return id;
    }

    private void openNewNode(@NotNull GeneralTestEventsProcessor processor2, @NotNull String nodeName, boolean isTest) {
        String parentId = this.getCurrentNodeId();
        this.myTestNameStack.push(nodeName);
        String location = this.getLocationFromId();
        this.myTestResultStack.push(CidrFromTagInLineToGeneralTestEventsConverter.TestResult.create(true, 0));
        String nodeId = this.getCurrentNodeId();
        String metainfo = null;
        String presentableName = CidrGoogleOutputToGeneralTestEventsConverter.getPresentableName(nodeName);
        this.process(isTest ? this.myEventProcessor.testStarted(presentableName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(presentableName, parentId, nodeId, location, metainfo));
    }

    @NotNull
    private static String getPresentableName(@NotNull String name2) {
        return StringUtil.notNullize((String)((String)CidrGoogleTestLinker.splitByFirst((String)name2, (String)":").second));
    }

    private void closeLastNode(@NotNull GeneralTestEventsProcessor processor2, @Nullable String statusSucc, long durationInMs, boolean isTest) {
        String nodeId = this.getCurrentNodeId();
        this.myRenamedClosedNodeIds.put(nodeId, nodeId + "/reopen:");
        if (this.myTestNameStack.isEmpty()) {
            return;
        }
        String nodeName = (String)this.myTestNameStack.pop();
        boolean succeeded = ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.pop()).success;
        if (succeeded && statusSucc != null) {
            succeeded = statusSucc.equalsIgnoreCase("OK");
        }
        if (!this.myTestResultStack.isEmpty()) {
            ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(succeeded, durationInMs);
        }
        String presentableName = CidrGoogleOutputToGeneralTestEventsConverter.getPresentableName(nodeName);
        this.process(isTest ? this.myEventProcessor.testFinished(presentableName, nodeId, String.valueOf(durationInMs), succeeded) : this.myEventProcessor.suiteFinished(presentableName, nodeId));
    }

    static enum Tag {
        MODULE_END("\\[==========] \\d+ tests? from \\d+ test cases? ran\\. \\(:?(\\d+ ms)(?: total)?\\)?\n"),
        MODULE_START("\\[==========] Running \\d+ tests? from \\d+ test cases?\\."),
        SUITE_END("\\[----------] \\d+ tests? from (.*?) \\(:?(\\d+ ms)(?: total)?\\)?\n"),
        SUITE_START("\\[----------] \\d+ tests? from (.*?)\n"),
        TEST_END("\\[\\s*(OK|FAILED)\\s*]\\s*(.*?) \\(:?(\\d+ ms)(?: total)?\\)?\n"),
        TEST_START("\\[\\s*RUN\\s*]\\s*(.*?)\n"),
        SETUP_TEARDOWN("\\[----------] Global test environment (set-up|tear-down)[.]?\n"),
        FILTER_NOTE_PREFIX("Note: Google Test filter = (.*?)\n"),
        FINAL_PASS("\\[\\s*PASSED\\s*](.*?)\n"),
        FINAL_FAILED("\\[\\s*FAILED\\s*](.*?)\n"),
        FINAL_FAILED_REPORT("\\s*\\d+ FAILED TESTS?\n"),
        INFO("\\[(?:----------|==========]) (.*?)\n");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            this.myTagPattern = Pattern.compile(pattern);
        }

        @NotNull
        public static CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> parse(@NotNull String line) {
            HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String> attrs = new HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String>();
            for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.find()) continue;
                switch (tag) {
                    case MODULE_END: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(1));
                        break;
                    }
                    case MODULE_START: {
                        break;
                    }
                    case SUITE_START: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                        break;
                    }
                    case SUITE_END: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(2));
                        break;
                    }
                    case TEST_START: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                        break;
                    }
                    case TEST_END: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(3));
                    }
                }
                String outText = line.substring(0, matcher.start());
                if (tag == INFO) {
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, outText + matcher.group(1));
                } else if (!outText.isEmpty()) {
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, outText + "\n");
                }
                return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag>(tag, attrs);
            }
            attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, line);
            return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag>(INFO, attrs);
        }
    }
}

