/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope(CidrGoogleTestFramework.getInstance().getPatternSeparatorInCommandLine());

    public CidrGoogleTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, (Function<Pair<AbstractTestProxy, Project>, String>)((Function)testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith("gtest://")) {
                return CidrGoogleTestLinker.create(url.substring("gtest://".length())).getPatternForCommandLine();
            }
            return null;
        }), this);
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String suiteName, @Nullable String testName) {
        return CidrGoogleTestFramework.getInstance().createTestScopeElementForSuiteAndTest(suiteName, testName);
    }

    @Override
    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        Object configuration = this.getConfiguration();
        configuration.getTestData().setCommandLineTestPattern(CidrTestScope.getAsPatternForCommandLine(configuration.getProject(), CidrGoogleTestFramework.getInstance(), EMPTY_TEST_SCOPE_PRODUCER, this.testScope(), progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Override
    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    @Override
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        String commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern();
        if (!StringUtil.isEmpty((String)commandLineTestPattern)) {
            cl.addParameter("--gtest_filter=" + commandLineTestPattern);
        }
        cl.addParameter("--gtest_color=no");
        return cl;
    }
}

