/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static final Set<String> GOOGLE_TEST_MACRO_NAMES = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])new String[]{"GTEST_TEST", "GTEST_TEST_", "TEST", "TEST_F", "TEST_P", "TYPED_TEST", "TYPED_TEST_P", "TYPED_TEST_CASE", "TYPED_TEST_CASE_P", "REGISTER_TYPED_TEST_CASE_P", "INSTANTIATE_TEST_CASE_P", "INSTANTIATE_TYPED_TEST_CASE_P"}));
    private static final OCSymbolKind[] DECL_KINDS = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, OCSymbolKind.TYPEDEF};
    private final Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator = testScopeElement -> new CidrTestScopeElementImpl.DefaultPropertiesGenerator((CidrTestScopeElementImpl)testScopeElement){

        @NotNull
        private CidrGoogleTestLinker getLinker() {
            return CidrGoogleTestLinker.create(this.getTestPath());
        }

        @Override
        public boolean isPatternLike() {
            return this.getLinker().instantiation != null;
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            return this.getLinker().getConfigurationName();
        }

        @Override
        @NotNull
        public String getPattern() {
            return this.getLinker().getPatternForCommandLine();
        }
    };

    public static CidrGoogleTestFramework getInstance() {
        return CidrGoogleTestFramework.getInstance(CidrGoogleTestFramework.class);
    }

    public CidrGoogleTestFramework() {
        super("Google Test", CidrGoogleTestFramework.getCidrTopLevelChangesModificationTracker(), OCFile.class, OCMacroCall.class, OCStruct.class, OCFunctionDefinition.class, OCDeclarator.class);
        this.myDeclaratorKinds = DECL_KINDS;
    }

    @Override
    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        return CidrGoogleTestFramework.getFrameworkVersionUsingImportedMacro(file, "GTEST_TEST");
    }

    @Override
    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        return element instanceof OCMacroCall && PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDeclaration.class) == null;
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ":";
    }

    @Override
    @NotNull
    protected String getProtocolPrefix() {
        return "gtest://";
    }

    @Override
    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        return this.getTestObjectFromTestHolder(element, GOOGLE_TEST_MACRO_NAMES);
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestClassOrStruct(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        return this.standardProbe(symbol, element, OCStruct.class, project2, OCSymbolKind.STRUCT);
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project2, OCSymbolKind.FUNCTION_DECLARATION);
    }

    @Override
    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        return CidrGoogleTestUtil.createTestLinks(file);
    }

    @Override
    @NotNull
    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suiteName, @Nullable String testName) {
        return CidrTestScopeElementImpl.createTestScopeElementForSuiteAndTest(suiteName == null ? null : "suite:" + suiteName, testName == null ? null : "test:" + testName, this.getGenerator());
    }

    @Override
    @NotNull
    public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        return this.myGenerator;
    }
}

