/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrGoogleTestLinker {
    public static final String DATA = "data";
    public static final String TYPE = "type";
    public static final String SUITE = "suite";
    public static final String TEST = "test";
    public static final String ORDER = "order";
    public static final String ORDER_PARAM_SEPARATOR = " - ";
    public static final String KIND_SEPARATOR = ":";
    public static final String NO_NAME = SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.noname", (Object[])new Object[0]);
    public String instantiation = null;
    public String suite = null;
    public String test = null;
    public String order = null;
    public String typeNameOrParamValue = null;
    public boolean isTyped = false;

    CidrGoogleTestLinker() {
    }

    @NotNull
    public String getPath() {
        StringBuilder path = new StringBuilder();
        CidrGoogleTestLinker.addToPath(path, SUITE, this.suite);
        CidrGoogleTestLinker.addToPath(path, this.isTyped ? TYPE : DATA, this.instantiation);
        if (this.isTyped) {
            CidrGoogleTestLinker.addToPath(path, ORDER, this.getOrderName());
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
        } else {
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
            CidrGoogleTestLinker.addToPath(path, ORDER, this.getOrderName());
        }
        return path.toString();
    }

    @Contract(pure=true)
    @Nullable
    private String getOrderName() {
        if (this.order == null) {
            return null;
        }
        return this.order + (this.typeNameOrParamValue == null ? "" : ORDER_PARAM_SEPARATOR + this.typeNameOrParamValue);
    }

    public String getFindPath() {
        StringBuilder path = new StringBuilder();
        CidrGoogleTestLinker.addToPath(path, SUITE, this.suite);
        if (this.test != null) {
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
        } else if (this.instantiation != null) {
            CidrGoogleTestLinker.addToPath(path, this.isTyped ? TYPE : DATA, this.instantiation);
        }
        return path.toString();
    }

    private static void addToPath(@NotNull StringBuilder path, @NotNull String partKind, @Nullable String part) {
        if (part != null) {
            if (path.length() != 0) {
                path.append('/');
            }
            path.append(partKind).append(KIND_SEPARATOR).append(part);
        }
    }

    @Nullable
    static CidrGoogleTestLinker parseTestOut(@NotNull String text) {
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        Pair<String, String> beforeAfter = CidrGoogleTestLinker.splitByFirst(text, ",");
        testInfo.typeNameOrParamValue = CidrGoogleTestLinker.getParam((String)beforeAfter.second);
        List parts = StringUtil.split((String)((String)beforeAfter.first), (String)"/", (boolean)true, (boolean)false);
        switch (parts.size()) {
            case 1: {
                Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(0), ".");
                testInfo.suite = (String)suiteTest.first;
                testInfo.test = (String)suiteTest.second;
                break;
            }
            case 2: {
                Pair<String, String> orderTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(1), ".");
                if (orderTest.second == null) {
                    if (testInfo.typeNameOrParamValue == null) {
                        testInfo.instantiation = (String)parts.get(0);
                        testInfo.suite = (String)parts.get(1);
                        break;
                    }
                    Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(0), ".");
                    testInfo.suite = (String)suiteTest.first;
                    testInfo.test = (String)suiteTest.second;
                    testInfo.order = (String)parts.get(1);
                    testInfo.isTyped = testInfo.test == null;
                    break;
                }
                testInfo.suite = (String)parts.get(0);
                testInfo.order = (String)orderTest.first;
                testInfo.test = (String)orderTest.second;
                testInfo.isTyped = true;
                break;
            }
            case 3: {
                testInfo.instantiation = (String)parts.get(0);
                Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(1), ".");
                if (suiteTest.second != null) {
                    testInfo.suite = (String)suiteTest.first;
                    testInfo.test = (String)suiteTest.second;
                    testInfo.order = (String)parts.get(2);
                    break;
                }
                testInfo.isTyped = true;
                testInfo.suite = (String)parts.get(1);
                Pair<String, String> orderTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(2), ".");
                testInfo.order = (String)orderTest.first;
                testInfo.test = (String)orderTest.second;
                break;
            }
            default: {
                return null;
            }
        }
        return testInfo;
    }

    @Contract(value="null -> null")
    private static String getParam(@Nullable String afterComma) {
        if (afterComma == null) {
            return null;
        }
        return (String)CidrGoogleTestLinker.splitByFirst((String)afterComma, (String)" = ").second;
    }

    @NotNull
    public static Pair<String, String> splitByFirst(@NotNull String text, @NotNull String separator) {
        String after2;
        String before;
        int commaPos = StringUtil.indexOf((CharSequence)text, (CharSequence)separator);
        if (commaPos < 0) {
            before = text;
            after2 = null;
        } else {
            before = commaPos == 0 ? "" : text.substring(0, commaPos);
            after2 = commaPos == text.length() - separator.length() ? "" : text.substring(commaPos + separator.length(), text.length());
        }
        return Pair.create((Object)before, after2);
    }

    @NotNull
    static CidrGoogleTestLinker create(@NotNull String testPath) {
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        List<String> parts = CidrTestScopeElementImpl.splitPath(testPath);
        for (String pair2 : parts) {
            Pair<String, String> keyValue = CidrGoogleTestLinker.splitByFirst(pair2, KIND_SEPARATOR);
            if (keyValue.second == null) continue;
            String key = (String)keyValue.first;
            String value = (String)keyValue.second;
            if (DATA.equals(key)) {
                testInfo.instantiation = value;
                testInfo.isTyped = false;
                continue;
            }
            if (TYPE.equals(key)) {
                testInfo.instantiation = value;
                testInfo.isTyped = true;
                continue;
            }
            if (SUITE.equals(key)) {
                testInfo.suite = value;
                continue;
            }
            if (TEST.equals(key)) {
                testInfo.test = value;
                continue;
            }
            if (!ORDER.equals(key)) continue;
            Pair<String, String> orderParam = CidrGoogleTestLinker.splitByFirst(value, ORDER_PARAM_SEPARATOR);
            testInfo.order = (String)orderParam.first;
            testInfo.typeNameOrParamValue = (String)orderParam.second;
        }
        return testInfo;
    }

    public String getConfigurationName() {
        StringBuilder cn = new StringBuilder();
        if (this.instantiation != null) {
            cn.append(this.instantiation).append("-");
        }
        if (this.suite != null) {
            cn.append(this.suite);
        }
        if (this.test != null) {
            cn.append(".").append(this.test);
        }
        if (this.order != null) {
            cn.append("[").append(this.order);
            if (this.typeNameOrParamValue != null) {
                cn.append(ORDER_PARAM_SEPARATOR).append(this.typeNameOrParamValue);
            }
            cn.append("]");
        }
        return cn.toString();
    }

    public String getPatternForCommandLine() {
        String test = StringUtil.notNullize((String)this.test, (String)"*");
        String suite = StringUtil.notNullize((String)this.suite, (String)"*");
        String order = StringUtil.notNullize((String)this.order, (String)"*");
        if (this.instantiation != null) {
            return String.format("%s/%s.%s/%s:%s/%s/%s.%s", this.instantiation, suite, test, order, this.instantiation, suite, order, test);
        }
        if (this.suite == null) {
            return "*";
        }
        return String.format("%s.%s:%s/%s.%s:*/%s.%s/*:*/%s/*.%s", suite, test, suite, order, test, suite, test, suite, test);
    }

    public static boolean namesEqual(@NotNull String name1, @NotNull String name2) {
        return CidrGoogleTestLinker.getSignificantPart(name1).equals(CidrGoogleTestLinker.getSignificantPart(name2));
    }

    private static String getSignificantPart(@NotNull String name1) {
        return (String)StringUtil.split((String)name1, (String)ORDER_PARAM_SEPARATOR).get(0);
    }
}

