/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "gtest";
    public static final String PROTOCOL_PREFIX = "gtest://";
    public static final CidrGoogleTestLocationProvider INSTANCE = new CidrGoogleTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        return this.getLocation(protocol, path, null, project2, scope);
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (!PROTOCOL.equals(protocol)) {
            return Collections.emptyList();
        }
        CidrGoogleTestFramework framework = CidrGoogleTestFramework.getInstance();
        return framework.getUpdater(project2).getLocation((Computable<List<Location>>)((Computable)() -> {
            CidrGoogleTestLinker linker = CidrGoogleTestLinker.create(path);
            Collection elements = framework.collectTestObjects(linker.getFindPath(), project2, scope);
            if (elements.isEmpty()) {
                return Collections.emptyList();
            }
            CidrTestScopeElement scopeElement = elements.stream().min(Comparator.comparingLong(CidrTestScopeElement::getSortIndex)).get();
            if (!path.equals(scopeElement.getTestPath())) {
                scopeElement = CidrTestScopeElementImpl.createTestScopeElementForVirtualTestPath(path, linker.getConfigurationName(), scopeElement, framework.getGenerator());
            }
            return Collections.singletonList(new CidrTestLocation<CidrTestScopeElement>(project2, scopeElement));
        }));
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project2) {
        return CidrGoogleTestFramework.getInstance().getUpdater(project2);
    }
}

