/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = connection -> new CidrGoogleTestRunConfigurationData((CidrTestRunConfiguration)connection);
    @NonNls
    public static final String FRAMEWORK_ID = "Google Test";

    public CidrGoogleTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        super(configuration);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        return this.myTestName;
    }

    @Override
    public void setSuiteName(@Nullable String suiteNameOrPart) {
        this.myTestSuite = CidrGoogleTestRunConfigurationData.getPureName(suiteNameOrPart);
    }

    @Override
    public void setTestName(@Nullable String testNameOrPart) {
        this.myTestName = CidrGoogleTestRunConfigurationData.getPureName(testNameOrPart);
    }

    @Nullable
    private static String getPureName(@Nullable String nameOrPart) {
        String nullize = StringUtil.nullize((String)nameOrPart, (boolean)true);
        if (nullize == null) {
            return null;
        }
        List split = StringUtil.split((String)nullize, (String)":");
        switch (split.size()) {
            case 1: {
                return ((String)split.get(0)).trim();
            }
            case 2: {
                return ((String)split.get(1)).trim();
            }
        }
        return null;
    }

    @Override
    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        return scope.isPatternLike() ? this.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && Comparing.equal((String)this.getTestPattern(), (String)scope.getPattern()) : this.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST && Comparing.equal((String)this.getTestSuite(), (String)CidrGoogleTestRunConfigurationData.getPureName(scope.getSuiteName())) && Comparing.equal((String)this.getTestName(), (String)CidrGoogleTestRunConfigurationData.getPureName(scope.getTestName()));
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        Project project2 = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || this.myTestSuite == null || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(project2)) {
            return;
        }
        String errorMessage = CidrTestFrameworkBase.getFromSymbols(null, project2, () -> {
            CidrGoogleTestFramework instance2 = CidrGoogleTestFramework.getInstance();
            if (instance2.collectTestObjects(instance2.createTestScopeElementForSuiteAndTest(this.myTestSuite, this.myTestName).getTestPath(), project2, null).isEmpty()) {
                return this.myTestName == null ? CidrBundle.message("test.suiteNotFound", this.myTestSuite) : CidrBundle.message("test.testNotFound", this.myTestName);
            }
            return null;
        });
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Override
    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    @Override
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        return new CidrGoogleTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @Override
    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        return new CidrGoogleTestConsoleProperties(this.myConfiguration, executor, target);
    }
}

