/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsRunConfigurationEditor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestWithScopeElementsRunConfigurationEditor<BC, TARGET, CONFIGURATION, BCH> {
    public CidrGoogleTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper, CidrGoogleTestFramework.class);
    }

    @Override
    protected boolean hasOutOfSuiteTests() {
        return true;
    }

    @Override
    @NotNull
    protected CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter createSuiteAdapter() {
        return new CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter(){

            @Override
            @NotNull
            public Collection<String> collectValuesFromProject(@NotNull Project project2, @Nullable Condition<String> conditionForSuiteName) {
                return CidrGoogleTestRunConfigurationEditor.this.collectStringsFromProject(CidrGoogleTestRunConfigurationEditor.this.myProject, pair2 -> {
                    String suiteName = CidrGoogleTestRunConfigurationEditor.getNonNullName(CidrGoogleTestLinker.create((String)StringUtil.notNullize((String)((CidrTestScopeElement)pair2.first).getSuiteName())).suite);
                    if (conditionForSuiteName == null || conditionForSuiteName.value((Object)suiteName)) {
                        ((Set)pair2.second).add(CidrGoogleTestRunConfigurationEditor.getNonNullName(suiteName));
                    }
                });
            }
        };
    }

    @Override
    public boolean isValidSuiteName() {
        return CidrTestFrameworkBase.getFromSymbols(true, this.myProject, () -> {
            String suitePart = this.getSuitePart();
            if (suitePart == null) {
                return true;
            }
            return !CidrGoogleTestFramework.getInstance().collectTestObjects(CidrGoogleTestLinker.create(suitePart).getFindPath(), this.myProject, null).isEmpty();
        });
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String suitePart = this.getSuitePart();
        return this.collectStringsFromProject(this.myProject, pair2 -> {
            String testPart;
            String suitePath = ((CidrTestScopeElement)pair2.first).getSuiteName();
            if ((suitePart == null ? suitePath == null : suitePart.equals(suitePath)) && (testPart = ((CidrTestScopeElement)pair2.first).getTestName()) != null) {
                ((Set)pair2.second).add(CidrGoogleTestRunConfigurationEditor.getNonNullName(CidrGoogleTestLinker.create((String)testPart).test));
            }
        });
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        return ContainerUtil.filter(super.getTargets(), target -> target.isExecutable());
    }

    @Nullable
    private String getSuitePart() {
        String suiteName = this.getTestSuiteText();
        return suiteName == null ? null : "suite:" + CidrGoogleTestRunConfigurationEditor.getRealName(suiteName);
    }

    @Contract(pure=true)
    @NotNull
    private static String getNonNullName(@Nullable String name2) {
        return StringUtil.notNullize((String)name2, (String)CidrGoogleTestLinker.NO_NAME);
    }

    @Contract(pure=true)
    @NotNull
    private static String getRealName(@NotNull String maybeNoName) {
        return CidrGoogleTestLinker.NO_NAME.equals(maybeNoName) ? "" : maybeNoName;
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("test.allTestSuites", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("gtest.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("test.configuration.suite", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return CidrBundle.message("test.allTestsInSuite", new Object[0]);
    }
}

