/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestUtil {
    private static final Pattern INSTANTIATE_DATA_TEST = Pattern.compile("gtest_(\\w*)_dummy_");
    private static final Pattern INSTANTIATE_TYPED_TEST = Pattern.compile("gtest_(\\w*)_(\\w*)");
    private static final Pattern SKIP_REGISTRATION_TEST = Pattern.compile("gtest_(\\w*)_(\\w*)_registered_");
    private static final Pattern REGISTER_TYPED_TEST = Pattern.compile("gtest_registered_test_names_(\\w*)_");
    private static final Pattern TYPED_TEST_CASE_P = Pattern.compile("gtest_typed_test_case_p_state_(\\w*)_");
    private static final Pattern TYPED_TEST_CASE = Pattern.compile("gtest_type_params_(\\w*)_");
    public static final String TEST_BODY = "TestBody";
    private static final String ADD_TO_REGISTRY = "AddToRegistry";
    private static final String REGISTER = "Register";
    private static final String TEST_INFO = "test_info_";
    private static final Set<String> GTEST_API = ContainerUtil.newHashSet((Object[])new String[]{"gmock-all.cc", "gtest-all.cc", "gtest-death-test-internal.h", "gtest-death-test.h", "gtest-filepath.h", "gtest-internal.h", "gtest-linked_ptr.h", "gtest-message.h", "gtest-param-test.h", "gtest-param-util-generated.h", "gtest-param-util.h", "gtest-port-arch.h", "gtest-port.h", "gtest-printers.h", "gtest-spi.h", "gtest-string.h", "gtest-test-part.h", "gtest-tuple.h", "gtest-type-util.h", "gtest-typed-test.h", "gtest.h", "gtest_pred_impl.h", "gtest_prod.h"});

    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        final Project project2 = file.getProject();
        final CidrGoogleTestFramework testFramework = CidrGoogleTestFramework.getInstance();
        final VirtualFile virtualFile = file.getVirtualFile();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(file.getProject()).value((Object)virtualFile);
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(@NotNull OCSymbol symbol) {
                OCStructSymbol test;
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project2);
                if (psiFile == null || CidrGoogleTestUtil.skipFile(psiFile) || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                if (CidrTestUtil.processNamespaceRecursively(symbol, this)) {
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    String testRefQName;
                    OCDeclaratorSymbol test2 = (OCDeclaratorSymbol)symbol;
                    String varName = test2.getName();
                    Matcher matcher = TYPED_TEST_CASE_P.matcher(varName);
                    if (matcher.find() && (testRefQName = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(test2, context)) != null) {
                        links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + matcher.group(1), symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, testFramework.getGenerator()));
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.TYPEDEF) {
                    String testRefQName;
                    OCDeclaratorSymbol test3 = (OCDeclaratorSymbol)symbol;
                    String varName = test3.getName();
                    Matcher matcher = TYPED_TEST_CASE.matcher(varName);
                    if (matcher.find() && (testRefQName = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(test3, context)) != null) {
                        links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + matcher.group(1), symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.TYPEDEF, testFramework.getGenerator()));
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE) {
                    String testRefQName;
                    OCDeclaratorSymbol test4 = (OCDeclaratorSymbol)symbol;
                    String varName = test4.getName();
                    Matcher matcher = SKIP_REGISTRATION_TEST.matcher(varName);
                    if (matcher.find()) {
                        return true;
                    }
                    matcher = REGISTER_TYPED_TEST.matcher(varName);
                    if (matcher.find()) {
                        String testRefQName2 = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(test4, context);
                        if (testRefQName2 != null) {
                            links.put(testRefQName2, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + matcher.group(1), symbol.getComplexOffset(), testRefQName2, psiFile, OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                        }
                        return true;
                    }
                    matcher = INSTANTIATE_DATA_TEST.matcher(varName);
                    if (matcher.find()) {
                        Couple suite_data = CidrGoogleTestUtil.extractInstantiateTestName(test4, project2);
                        testRefQName = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(test4, context);
                        if (suite_data != null && testRefQName != null) {
                            links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + (String)suite_data.getFirst() + CidrTestScopeElement.SEPARATOR + "data" + ":" + (String)suite_data.getSecond(), symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                            return true;
                        }
                    }
                    if ((matcher = INSTANTIATE_TYPED_TEST.matcher(varName)).find()) {
                        Couple instantiate_suite = CidrGoogleTestUtil.extractInstantiateTypedTestName(test4, project2);
                        testRefQName = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol(test4, context);
                        if (instantiate_suite != null && testRefQName != null) {
                            links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + (String)instantiate_suite.getSecond() + CidrTestScopeElement.SEPARATOR + "type" + ":" + (String)instantiate_suite.getFirst(), symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                            return true;
                        }
                    }
                } else if (symbol instanceof OCStructSymbol && CidrGoogleTestUtil.hasGTAsBaseClasses(test = (OCStructSymbol)symbol, context)) {
                    Couple<String> suite_test;
                    String testRefQName = test.getType().getCanonicalName(context);
                    String className = test.getName();
                    CommonProcessors.FindFirstAndOnlyProcessor firstAndOnlyProcessor = new CommonProcessors.FindFirstAndOnlyProcessor();
                    test.processFunctions(CidrGoogleTestUtil.TEST_BODY, (Processor<? super OCFunctionSymbol>)firstAndOnlyProcessor);
                    if (firstAndOnlyProcessor.getFoundValue() != null && (suite_test = CidrGoogleTestUtil.extractGoogleTestName(test, project2)) != null) {
                        String bodyQName = testRefQName + "::" + CidrGoogleTestUtil.TEST_BODY;
                        String testName = "test:" + (String)suite_test.getSecond();
                        String suiteName = "suite:" + (String)suite_test.getFirst();
                        links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(testName, suiteName, symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.STRUCT, testFramework.getGenerator()));
                        links.put(bodyQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(testName, suiteName, ((OCFunctionSymbol)firstAndOnlyProcessor.getFoundValue()).getComplexOffset(), bodyQName, psiFile, OCSymbolKind.FUNCTION_DECLARATION, testFramework.getGenerator()));
                        return true;
                    }
                    links.put(testRefQName, CidrTestScopeElementImpl.createTestScopeElementForCaching(null, "suite:" + className, symbol.getComplexOffset(), testRefQName, psiFile, OCSymbolKind.STRUCT, testFramework.getGenerator()));
                }
                return true;
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, processor2);
        return links;
    }

    private static boolean skipFile(@NotNull PsiFile file) {
        return GTEST_API.contains(file.getName());
    }

    private static boolean hasGTAsBaseClasses(@NotNull OCStructSymbol struct, @NotNull OCResolveContext context) {
        return !struct.processAllBaseClasses(context, (symbol, visibility) -> !symbol.getType().getCanonicalName(context).equals("::testing::Test"), true);
    }

    @Nullable
    private static Couple<String> extractInstantiateTypedTestName(@NotNull OCDeclaratorSymbol inst2test, @NotNull Project project2) {
        PsiElement idRegister;
        PsiElement registerCall;
        PsiElement element = inst2test.locateDefinition(project2);
        if (element instanceof OCDeclarator && (registerCall = element.getLastChild()) instanceof OCCallExpression && OCElementUtil.getElementType(idRegister = PsiTreeUtil.getDeepestLast((PsiElement)registerCall.getFirstChild())) == OCTokenTypes.IDENTIFIER && REGISTER.equals(idRegister.getText())) {
            List<OCExpression> registerCallArgs = ((OCCallExpression)registerCall).getArguments();
            if (registerCallArgs.size() == 3 && registerCallArgs.get(0) instanceof OCLiteralExpression && registerCallArgs.get(1) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)registerCallArgs.get(0)).getUnescapedLiteralText(), (Object)((OCLiteralExpression)registerCallArgs.get(1)).getUnescapedLiteralText());
            }
            if (registerCallArgs.size() == 5 && registerCallArgs.get(0) instanceof OCLiteralExpression && registerCallArgs.get(3) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)registerCallArgs.get(0)).getUnescapedLiteralText(), (Object)((OCLiteralExpression)registerCallArgs.get(3)).getUnescapedLiteralText());
            }
        }
        return null;
    }

    @Nullable
    private static Couple<String> extractInstantiateTestName(@NotNull OCDeclaratorSymbol regInstantiate, @NotNull Project project2) {
        OCExpression addTestCaseInstantiationCallArg0;
        List<OCExpression> addTestCaseInstantiationCallArgs;
        PsiElement addTestCaseInstantiationCall;
        PsiElement element = regInstantiate.locateDefinition(project2);
        if (element instanceof OCDeclarator && (addTestCaseInstantiationCall = element.getLastChild()) instanceof OCCallExpression && !(addTestCaseInstantiationCallArgs = ((OCCallExpression)addTestCaseInstantiationCall).getArguments()).isEmpty() && (addTestCaseInstantiationCallArg0 = addTestCaseInstantiationCallArgs.get(0)) instanceof OCLiteralExpression) {
            OCExpression getTestCasePatternHolderCallArg0;
            List<OCExpression> getTestCasePatternHolderCallArgs;
            PsiElement getTestCasePatternHolderCall;
            String test = ((OCLiteralExpression)addTestCaseInstantiationCallArg0).getUnescapedLiteralText();
            PsiElement qe = addTestCaseInstantiationCall.getFirstChild();
            if (qe instanceof OCQualifiedExpression && (getTestCasePatternHolderCall = qe.getFirstChild()) instanceof OCCallExpression && !(getTestCasePatternHolderCallArgs = ((OCCallExpression)getTestCasePatternHolderCall).getArguments()).isEmpty() && (getTestCasePatternHolderCallArg0 = getTestCasePatternHolderCallArgs.get(0)) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)getTestCasePatternHolderCallArg0).getUnescapedLiteralText(), (Object)test);
            }
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractGoogleTestName(@Nullable OCStructSymbol symbol, @NotNull Project project2) {
        List<Object> arguments = Collections.emptyList();
        if (symbol != null) {
            OCDeclarator varDeclarator;
            OCDeclaration declaration;
            String name2 = symbol.getName();
            if (name2.endsWith("_Test") && (declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)symbol.locateDefinition(project2), OCDeclaration.class)) != null && (varDeclarator = (OCDeclarator)PsiTreeUtil.getChildOfType((PsiElement)(declaration = (OCDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration, OCDeclaration.class)), OCDeclarator.class)) != null) {
                if (TEST_INFO.equals(varDeclarator.getName())) {
                    arguments = CidrGoogleTestUtil.extractMethodArguments(varDeclarator);
                } else {
                    String varName = "gtest_" + name2.substring(0, name2.length() - "_Test".length()) + "_registered_";
                    if (varName.equals(varDeclarator.getName())) {
                        List<OCExpression> result = CidrGoogleTestUtil.extractMethodArguments(varDeclarator);
                        if (result.size() >= 5) {
                            arguments = result.subList(2, 4);
                        } else if (result.size() >= 3) {
                            arguments = result.subList(1, 3);
                        }
                    }
                }
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractMethodArguments(symbol, ADD_TO_REGISTRY, project2);
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol, project2);
            }
        }
        if (arguments.size() >= 2) {
            String className = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(0)));
            String methodName = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(1)));
            return Couple.of((Object)className, (Object)methodName);
        }
        return null;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable PsiElement psiElement) {
        PsiElement parent;
        OCCallExpression expression;
        if (psiElement != null && (expression = (OCCallExpression)PsiTreeUtil.findChildOfType((PsiElement)(parent = psiElement.getParent()), OCCallExpression.class)) != null) {
            return expression.getArguments();
        }
        return Collections.emptyList();
    }

    private static List<OCExpression> extractTypeParameterizedArguments(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        List<OCExpression> arguments = Collections.emptyList();
        if (symbol.getParent() instanceof OCNamespaceSymbol && (arguments = CidrGoogleTestUtil.extractMethodArguments((OCNamespaceSymbol)symbol.getParent(), "gtest_" + symbol.getName() + "_defined_", project2)).size() >= 4) {
            arguments = arguments.subList(2, 4);
        }
        return arguments;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCNamespaceSymbol parent, @NotNull String methodName, @NotNull Project project2) {
        OCSymbol member = parent.findMember(methodName);
        return member != null ? CidrGoogleTestUtil.extractMethodArguments(member, project2) : Collections.emptyList();
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCSymbol symbol, @NotNull Project project2) {
        return CidrGoogleTestUtil.extractMethodArguments(symbol.locateDefinition(project2));
    }

    @NotNull
    public static String extractArgumentValue(@Nullable PsiElement element) {
        LeafPsiElement leafPsiElement = (LeafPsiElement)PsiTreeUtil.findChildOfType((PsiElement)element, LeafPsiElement.class);
        return leafPsiElement == null ? "" : StringUtil.notNullize((String)leafPsiElement.getText());
    }
}

