/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestUtilObsolete {
    @Nullable
    public static OCMacroCall findGoogleTestMacros(@Nullable PsiElement element) {
        return CidrGoogleTestUtilObsolete.findMacros(element, ContainerUtil.newHashSet((Object[])new String[]{"GTEST_TEST_", "TEST_P", "TYPED_TEST", "TYPED_TEST_P"}));
    }

    @Nullable
    private static OCMacroCall findMacros(@Nullable PsiElement element, @NotNull Set<String> macroNames) {
        element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class});
        while (element instanceof OCMacroCall) {
            String referenceName;
            OCReferenceElement referenceElement = ((OCMacroCall)element).getMacroReferenceElement();
            String string = referenceName = referenceElement == null ? null : referenceElement.getName();
            if (macroNames.contains(referenceName)) {
                return (OCMacroCall)element;
            }
            element = element.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractFullSuiteNameFromMacro(@NotNull PsiElement element) {
        Pair<String, List<String>> result = CidrGoogleTestUtilObsolete.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST", "INSTANTIATE_TEST_CASE_P", "INSTANTIATE_TYPED_TEST_CASE_P"}), 0, 1);
        if (result == null) {
            result = CidrGoogleTestUtilObsolete.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST_CASE", "TYPED_TEST_CASE_P", "REGISTER_TYPED_TEST_CASE_P"}), 0, 0);
            return result == null ? null : Couple.of(((List)result.second).get(0), null);
        }
        return "TYPED_TEST".equals(result.first) ? Couple.of(((List)result.second).get(0), ((List)result.second).get(1)) : Couple.of(((List)result.second).get(1), ((List)result.second).get(0));
    }

    @Nullable
    private static Pair<String, List<String>> extractMacroArgumentValues(@NotNull PsiElement element, @NotNull Set<String> macroNames, int beginIndex, int endIndex) {
        OCMacroCall macroCall = CidrGoogleTestUtilObsolete.findMacros(element, macroNames);
        if (macroCall != null) {
            OCReferenceElement referenceElement = macroCall.getMacroReferenceElement();
            String macroName = referenceElement == null ? "" : referenceElement.getName();
            List<OCMacroCallArgument> arguments = macroCall.getArguments();
            if (arguments.size() > endIndex) {
                ArrayList<String> result = new ArrayList<String>();
                while (beginIndex <= endIndex) {
                    result.add(CidrGoogleTestUtil.extractArgumentValue(arguments.get(beginIndex++)));
                }
                return Pair.create((Object)macroName, result);
            }
        }
        return null;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isGoogleTestFixture(@Nullable OCStructSymbol symbol, boolean recursively, @NotNull Project project2) {
        return symbol != null && CidrGoogleTestUtilObsolete.findGoogleTestFixture(symbol, recursively, project2) != null;
    }

    @Nullable
    public static OCStructSymbol findGoogleTestFixture(@NotNull OCStructSymbol symbol, boolean recursively, @NotNull Project project2) {
        if (CidrGoogleTestUtilObsolete.isGoogleTestClass(symbol, project2) && CidrGoogleTestUtil.extractGoogleTestName(symbol, project2) == null) {
            return symbol;
        }
        if (!recursively) {
            return null;
        }
        Ref found2 = Ref.create();
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        symbol.processAllBaseClasses(context, (symbol1, visibility) -> {
            boolean ok;
            boolean bl = ok = symbol1 instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.isGoogleTestFixture((OCStructSymbol)symbol1, false, project2);
            if (ok) {
                found2.set((Object)((OCStructSymbol)symbol1));
            }
            return !ok;
        }, false);
        return (OCStructSymbol)found2.get();
    }

    public static boolean isGoogleTestClass(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        return symbol.getKind() == OCSymbolKind.STRUCT && CidrGoogleTestUtilObsolete.isGoogleTestClassWithAnyAncestor(symbol, context, "Test");
    }

    public static boolean isGoogleTestClassWithAnyAncestor(@NotNull OCStructSymbol symbol, @NotNull OCResolveContext context, String ... ancestorNames) {
        Set canonicalNames = ContainerUtil.map2Set((Object[])ancestorNames, s -> "::testing::" + s);
        return !symbol.processAllBaseClasses((symbol1, visibility) -> {
            if (!(symbol1 instanceof OCSymbolWithQualifiedName)) {
                return true;
            }
            OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol1).getResolvedQualifiedNameWithoutArguments(context);
            return qualifiedName == null || !canonicalNames.contains(qualifiedName.getFullName(context));
        }, context);
    }

    @Nullable
    public static OCStructSymbol findGoogleTestSymbol(@NotNull Project project2, @NotNull String suiteName, @NotNull String testName) {
        boolean found2;
        Ref result = new Ref();
        boolean bl = found2 = !OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.googleTestNameMatches((OCStructSymbol)ocSymbol, suiteName, testName, project2)) {
                result.set((Object)((OCStructSymbol)ocSymbol));
                return false;
            }
            return true;
        }), suiteName + "_" + testName + "_Test");
        if (!found2) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)((Processor)symbol -> {
                OCSymbol res;
                OCSymbol oCSymbol = res = symbol instanceof OCNamespaceSymbol ? ((OCNamespaceSymbol)symbol).findMember(testName) : null;
                if (res instanceof OCStructSymbol) {
                    result.set((Object)((OCStructSymbol)res));
                }
                return true;
            }), "gtest_case_" + suiteName + "_");
        }
        return (OCStructSymbol)result.get();
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName, @Nullable String testName, @NotNull Project project2) {
        Couple<String> name2 = CidrGoogleTestUtil.extractGoogleTestName(symbol, project2);
        return name2 != null && suiteName.equals(name2.first) && (testName == null || testName.equals(name2.second));
    }
}

