/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope(CidrCatchTestFramework.getInstance().getPatternSeparatorInCommandLine());

    public CidrCatchTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    @Contract(value="_ -> !null")
    public CidrTestScope getFromString(@Nullable String arg) {
        return this.createEmptyTestScope().configureForPreRenderedScope(StringUtil.notNullize((String)arg));
    }

    @Override
    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            return this.myFailedTests;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN) {
            return this.getFromString(delegate.getTestPattern());
        }
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST) {
            if (delegate.getTestName() == null && delegate.getTestSuite() == null) {
                return this.getFromString(null);
            }
            if (delegate.getTestName() == null && delegate.getTestSuite() != null) {
                return this.getFromString(delegate.getTestSuite());
            }
            return this.getFromString(this.prepareTestNameForScope(delegate.getTestName()));
        }
        CidrTestLog.LOG.error("Unknown CidrTestRunConfigurationData.Mode: " + (Object)((Object)delegate.getTestMode()));
        return this.getFromString("*");
    }

    @NotNull
    protected String prepareTestNameForScope(String testName) {
        return StringUtil.escapeChars((String)testName, (char[])new char[]{',', '[', ']'});
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        return CidrCatchTestCommandLineState.doCreateRerunFailedTestsActionStandard(this, consoleView, "catch://");
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testTags, @Nullable String testMethod) {
        return CidrCatchTestFramework.getInstance().createTestScopeElementForSuiteAndTest(testTags, testMethod);
    }

    @Override
    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        Object configuration = this.getConfiguration();
        configuration.getTestData().setCommandLineTestPattern(CidrTestScope.getAsPatternForCommandLine(configuration.getProject(), CidrCatchTestFramework.getInstance(), EMPTY_TEST_SCOPE_PRODUCER, this.testScope(), progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Override
    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    @Override
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        String commandLineTestPattern;
        cl.addParameters(new String[]{"-r", "xml", "-d", "yes"});
        String testOrderSwitch = "--order";
        if (!cl.getParametersList().hasParameter("--order")) {
            cl.addParameters(new String[]{"--order", "lex"});
        }
        if (!StringUtil.isEmpty((String)(commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern()))) {
            CidrCatchTestCommandLineState.fixtureForAllTestsInFile(cl, commandLineTestPattern);
            cl.addParameter(commandLineTestPattern);
        }
        return cl;
    }

    private static void fixtureForAllTestsInFile(@NotNull GeneralCommandLine cl, @NotNull String maybeRunAllInFileScope) {
        if (maybeRunAllInFileScope.startsWith("[#") && maybeRunAllInFileScope.endsWith("]")) {
            cl.addParameter("-#");
        }
    }
}

