/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.jetbrains.cidr.execution.testing.CidrAbstractTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLocationProvider;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CidrCatchTestConsoleProperties
extends CidrAbstractTestConsoleProperties {
    private static final Pattern FAILURE_PATTERN = Pattern.compile("(.+?):(\\d+): Failure:[^\\n]*");

    public CidrCatchTestConsoleProperties(@NotNull RunConfiguration config, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        super(config, "Catch", executor, target);
        this.setIdBasedTestTree(true);
    }

    public SMTestLocator getTestLocator() {
        return CidrCatchTestLocationProvider.INSTANCE;
    }

    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        return new CidrCatchOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties, this.getConsole());
    }

    @Override
    @NotNull
    protected Pattern getAssertionPattern() {
        return FAILURE_PATTERN;
    }
}

