/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static final String CATCH_HEADER_NAME = "catch.hpp";
    public static final Set<String> CATCH_TEST_MACRO_NAMES = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])new String[]{"SCENARIO", "SCENARIO_METHOD", "TEST_CASE", "TEST_CASE_METHOD", "METHOD_AS_TEST_CASE", "REGISTER_TEST_CASE", "ANON_TEST_CASE", "CATCH_SCENARIO", "CATCH_SCENARIO_METHOD", "CATCH_TEST_CASE", "CATCH_TEST_CASE_METHOD", "CATCH_METHOD_AS_TEST_CASE", "CATCH_REGISTER_TEST_CASE", "CATCH_ANON_TEST_CASE"}));
    public static final String NULL_TEST_PRESENTATION_NAME = "Anonymous test case *";
    private final Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator = testScopeElement -> new CidrTestScopeElementImpl.DefaultPropertiesGenerator((CidrTestScopeElementImpl)testScopeElement){

        @NotNull
        String getNonNullTestName() {
            return StringUtil.notNullize((String)this.myOwner.getTestName(), (String)CidrCatchTestFramework.NULL_TEST_PRESENTATION_NAME);
        }

        @Override
        @NotNull
        public String getTestPath() {
            return this.getNonNullTestName();
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            return this.getNonNullTestName();
        }
    };

    public static CidrCatchTestFramework getInstance() {
        return CidrCatchTestFramework.getInstance(CidrCatchTestFramework.class);
    }

    public CidrCatchTestFramework() {
        super("Catch Test", CidrCatchTestFramework.getCidrTopLevelChangesModificationTracker(), OCFile.class, OCMacroCall.class, OCDeclarator.class, OCFunctionDefinition.class);
    }

    @Override
    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        return CidrCatchTestFramework.getFrameworkVersionUsingImportedMacro(file, "INTERNAL_CATCH_TEST");
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ",";
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project2, OCSymbolKind.FUNCTION_DECLARATION);
    }

    @Override
    @NotNull
    protected String getProtocolPrefix() {
        return "catch://";
    }

    @Override
    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        return this.getTestObjectFromTestHolder(element, CATCH_TEST_MACRO_NAMES);
    }

    @Override
    @Nullable
    protected CidrTestScopeElement createFileTestObjectIfPossible(@NotNull PsiFile file) {
        return CidrTestScopeElementImpl.createTestScopeElementForFile(file, () -> "[#" + file.getVirtualFile().getNameWithoutExtension() + "]");
    }

    @Override
    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        return CidrCatchTestUtil.createTestLinks(file);
    }

    @Override
    @NotNull
    public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        return this.myGenerator;
    }
}

