/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "catch";
    public static final String PROTOCOL_PREFIX = "catch://";
    public static final CidrCatchTestLocationProvider INSTANCE = new CidrCatchTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        return this.getLocation(protocol, path, null, project2, scope);
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (!PROTOCOL.equals(protocol)) {
            return Collections.emptyList();
        }
        CidrCatchTestFramework instance2 = CidrCatchTestFramework.getInstance();
        return instance2.getUpdater(project2).getLocation((Computable<List<Location>>)((Computable)() -> {
            String value;
            Object info = instance2.findTestObject(path, project2, scope);
            if (info == null) {
                return Collections.emptyList();
            }
            if (metainfo != null && (value = StringUtil.substringAfter((String)metainfo, (String)"line:")) != null) {
                PsiElement el;
                Document document2;
                PsiFile file;
                int lineNumber = -1;
                try {
                    lineNumber = Integer.parseInt(value) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (lineNumber >= 0 && (file = info.getElement().getContainingFile()) != null && (document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file)) != null && lineNumber < document2.getLineCount() && (el = file.findElementAt(DocumentUtil.getFirstNonSpaceCharOffset((Document)document2, (int)lineNumber))) != null && info.equals(instance2.findTestObject(el))) {
                    return Collections.singletonList(new PsiLocation(el));
                }
            }
            return Collections.singletonList(new CidrTestLocation(project2, info));
        }));
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project2) {
        return CidrCatchTestFramework.getInstance().getUpdater(project2);
    }
}

