/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCommandLineState;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = connection -> new CidrCatchTestRunConfigurationData((CidrTestRunConfiguration)connection);
    @NonNls
    public static final String FRAMEWORK_ID = "Catch Test";

    public CidrCatchTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        super(configuration);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        return this.myTestName;
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        Project project2 = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(project2)) {
            return;
        }
        if (this.myTestName == null && this.myTestSuite == null) {
            return;
        }
        Set<String> configTags = CidrCatchTestUtil.splitTags(this.myTestSuite);
        int tagGrammarCount = configTags.size();
        if (!CidrCatchTestUtil.isValidStringOfTags(this.myTestSuite)) {
            throw new RuntimeConfigurationError(CidrBundle.message("catch.notValidTags", tagGrammarCount + 1, this.myTestSuite));
        }
        String errorMessage = CidrTestFrameworkBase.getFromSymbols(null, project2, () -> {
            boolean[] validConfig = new boolean[]{false};
            CidrCatchTestFramework.getInstance().consumeTestObjects(project2, null, testInfo -> {
                Set<String> testTags = CidrCatchTestUtil.splitTags(testInfo.getSuiteName());
                if (testTags.containsAll(configTags) && (this.myTestName == null || this.myTestName.equals(testInfo.getTestPath()))) {
                    validConfig[0] = true;
                    return false;
                }
                return true;
            });
            if (!validConfig[0]) {
                return this.myTestName == null ? CidrBundle.message("catch.noTestsWithTags", tagGrammarCount, this.myTestSuite) : (this.myTestSuite == null ? CidrBundle.message("test.testNotFound", this.myTestName) : CidrBundle.message("catch.testNotFound", this.myTestName, tagGrammarCount, this.myTestSuite));
            }
            return null;
        });
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Override
    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    @Override
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        return new CidrCatchTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @Override
    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        return new CidrCatchTestConsoleProperties(this.myConfiguration, executor, target);
    }
}

