/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsRunConfigurationEditor;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestWithScopeElementsRunConfigurationEditor<BC, TARGET, CONFIGURATION, BCH> {
    public CidrCatchTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper, CidrCatchTestFramework.class);
    }

    @Override
    @NotNull
    protected CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter createSuiteAdapter() {
        return new CidrTestWithScopeElementsRunConfigurationEditor.MyOCFieldAdapter(){

            @Override
            @NotNull
            @Contract(pure=true)
            public String getName(String item) {
                return item == null ? "non-tagged" : item;
            }

            @Override
            @NotNull
            public Collection<String> collectValuesFromProject(@NotNull Project project2, @Nullable Condition<String> condition) {
                return CidrCatchTestRunConfigurationEditor.this.collectStringsFromProject(CidrCatchTestRunConfigurationEditor.this.myProject, pair2 -> {
                    if (condition == null || condition.value((Object)((CidrTestScopeElement)pair2.first).getSuiteName())) {
                        ((Set)pair2.second).addAll(CidrCatchTestUtil.splitTags(((CidrTestScopeElement)pair2.first).getSuiteName()));
                    }
                });
            }

            @Override
            @NotNull
            public String getPrefix(@NotNull String text, int offset) {
                int i = Math.max(text.lastIndexOf(93, offset - 1), text.lastIndexOf(32, offset - 1)) + 1;
                int j = text.lastIndexOf(10, offset - 1) + 1;
                return text.substring(Math.max(i, j), offset);
            }
        };
    }

    @Override
    public boolean isValidSuiteName() {
        String tagsInLine = this.getTestSuiteText();
        if (tagsInLine == null) {
            return false;
        }
        return "non-tagged".equals(tagsInLine) || CidrCatchTestUtil.isValidStringOfTags(tagsInLine);
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String tags = this.getTestSuiteText();
        if (tags == null) {
            return Collections.emptySet();
        }
        Set<String> suiteTags = CidrCatchTestUtil.splitTags(tags);
        return this.collectStringsFromProject(this.myProject, pair2 -> {
            if (CidrCatchTestUtil.splitTags(((CidrTestScopeElement)pair2.first).getSuiteName()).containsAll(suiteTags)) {
                ((Set)pair2.second).add(((CidrTestScopeElement)pair2.first).getTestPath());
            }
        });
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        return ContainerUtil.filter(super.getTargets(), target -> target.isExecutable());
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("catch.allTestTags", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("catch.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("catch.configuration.tags", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return "non-tagged".equals(this.getTestSuiteText()) ? CidrBundle.message("catch.selectTestForNonTagged", new Object[0]) : CidrBundle.message("catch.allTestForTags", new Object[0]);
    }
}

